/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Holidays;
import de.jollyday.config.RelativeToWeekdayInMonth;
import de.jollyday.config.When;
import de.jollyday.parser.impl.FixedWeekdayInMonthParser;
import java.time.LocalDate;
import java.util.Set;

public class RelativeToWeekdayInMonthParser
extends FixedWeekdayInMonthParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (RelativeToWeekdayInMonth rtfw : config.getRelativeToWeekdayInMonth()) {
            int direction;
            if (!this.isValid(rtfw, year)) continue;
            LocalDate date = this.parse(year, rtfw.getFixedWeekday()).plusDays(1L);
            int n = direction = rtfw.getWhen() == When.BEFORE ? -1 : 1;
            while (date.getDayOfWeek() != this.xmlUtil.getWeekday(rtfw.getWeekday())) {
                date = date.plusDays(direction);
            }
            HolidayType type = this.xmlUtil.getType(rtfw.getLocalizedType());
            holidays.add(new Holiday(date, rtfw.getDescriptionPropertiesKey(), type));
        }
    }
}

