/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Holidays;
import de.jollyday.config.RelativeToFixed;
import de.jollyday.config.When;
import de.jollyday.parser.AbstractHolidayParser;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Set;

public class RelativeToFixedParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (RelativeToFixed rf : config.getRelativeToFixed()) {
            if (!this.isValid(rf, year)) continue;
            LocalDate fixed = this.calendarUtil.create(year, rf.getDate());
            if (rf.getWeekday() != null) {
                DayOfWeek day = this.xmlUtil.getWeekday(rf.getWeekday());
                int direction = rf.getWhen() == When.BEFORE ? -1 : 1;
                fixed = fixed.plusDays(direction);
                while (fixed.getDayOfWeek() != day) {
                    fixed = fixed.plusDays(direction);
                }
            } else if (rf.getDays() != null) {
                fixed = fixed.plusDays(rf.getWhen() == When.BEFORE ? (long)(-rf.getDays().intValue()) : (long)rf.getDays().intValue());
            }
            HolidayType type = this.xmlUtil.getType(rf.getLocalizedType());
            holidays.add(new Holiday(fixed, rf.getDescriptionPropertiesKey(), type));
        }
    }
}

