/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Holidays;
import de.jollyday.config.RelativeToEasterSunday;
import de.jollyday.parser.AbstractHolidayParser;
import java.time.LocalDate;
import java.util.Set;

public class RelativeToEasterSundayParser
extends AbstractHolidayParser {
    private static final String PREFIX_PROPERTY_CHRISTIAN = "christian.";

    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (RelativeToEasterSunday ch : config.getRelativeToEasterSunday()) {
            if (!this.isValid(ch, year)) continue;
            LocalDate easterSunday = this.getEasterSunday(year, ch.getChronology()).plusDays(ch.getDays());
            String propertiesKey = PREFIX_PROPERTY_CHRISTIAN + ch.getDescriptionPropertiesKey();
            this.addChristianHoliday(easterSunday, propertiesKey, ch.getLocalizedType(), holidays);
        }
    }

    protected void addChristianHoliday(LocalDate day, String propertiesKey, de.jollyday.config.HolidayType holidayType, Set<Holiday> holidays) {
        HolidayType type = this.xmlUtil.getType(holidayType);
        Holiday h = new Holiday(day, propertiesKey, type);
        holidays.add(h);
    }
}

