/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Holidays;
import de.jollyday.config.IslamicHoliday;
import de.jollyday.parser.AbstractHolidayParser;
import java.time.LocalDate;
import java.util.Set;

public class IslamicHolidayParser
extends AbstractHolidayParser {
    private static final String PREFIX_PROPERTY_ISLAMIC = "islamic.";

    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (IslamicHoliday i : config.getIslamicHoliday()) {
            Set<LocalDate> islamicHolidays;
            if (!this.isValid(i, year)) continue;
            switch (i.getType()) {
                case NEWYEAR: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 1, 1);
                    break;
                }
                case ASCHURA: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 1, 10);
                    break;
                }
                case RAMADAN_END: {
                    islamicHolidays = this.calendarUtil.getRelativeIslamicHolidaysInGregorianYear(year, 10, 1, -1);
                    break;
                }
                case ID_AL_FITR: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 10, 1);
                    break;
                }
                case ID_AL_FITR_2: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 10, 2);
                    break;
                }
                case ID_AL_FITR_3: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 10, 3);
                    break;
                }
                case ARAFAAT: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 12, 9);
                    break;
                }
                case ID_UL_ADHA: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 12, 10);
                    break;
                }
                case ID_UL_ADHA_2: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 12, 11);
                    break;
                }
                case ID_UL_ADHA_3: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 12, 12);
                    break;
                }
                case LAILAT_AL_BARAT: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 8, 15);
                    break;
                }
                case LAILAT_AL_MIRAJ: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 7, 27);
                    break;
                }
                case LAILAT_AL_QADR: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 9, 27);
                    break;
                }
                case MAWLID_AN_NABI: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 3, 12);
                    break;
                }
                case RAMADAN: {
                    islamicHolidays = this.calendarUtil.getIslamicHolidaysInGregorianYear(year, 9, 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown islamic holiday " + (Object)((Object)i.getType()));
                }
            }
            String propertiesKey = PREFIX_PROPERTY_ISLAMIC + i.getType().name();
            HolidayType type = this.xmlUtil.getType(i.getLocalizedType());
            for (LocalDate d : islamicHolidays) {
                holidays.add(new Holiday(d, propertiesKey, type));
            }
        }
    }
}

