/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.FixedWeekdayRelativeToFixed;
import de.jollyday.config.Holidays;
import de.jollyday.config.When;
import de.jollyday.parser.AbstractHolidayParser;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.Set;
import org.threeten.extra.Days;

public class FixedWeekdayRelativeToFixedParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (FixedWeekdayRelativeToFixed f : config.getFixedWeekdayRelativeToFixed()) {
            if (!this.isValid(f, year)) continue;
            LocalDate day = this.calendarUtil.create(year, f.getDay());
            day = this.moveDateToFirstOccurrenceOfWeekday(f, day);
            int days = this.determineNumberOfDays(f);
            day = f.getWhen() == When.AFTER ? day.plusDays(days) : day.minusDays(days);
            HolidayType type = this.xmlUtil.getType(f.getLocalizedType());
            holidays.add(new Holiday(day, f.getDescriptionPropertiesKey(), type));
        }
    }

    private LocalDate moveDateToFirstOccurrenceOfWeekday(FixedWeekdayRelativeToFixed f, LocalDate day) {
        TemporalAdjuster adjuster;
        DayOfWeek weekday = this.xmlUtil.getWeekday(f.getWeekday());
        switch (f.getWhen()) {
            case AFTER: {
                adjuster = TemporalAdjusters.next(weekday);
                break;
            }
            case BEFORE: {
                adjuster = TemporalAdjusters.previous(weekday);
                break;
            }
            case CLOSEST: {
                adjuster = FixedWeekdayRelativeToFixedParser.closest(weekday);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported when adjustment: " + (Object)((Object)f.getWhen()));
            }
        }
        return day.with(adjuster);
    }

    private int determineNumberOfDays(FixedWeekdayRelativeToFixed f) {
        if (f.getWhen() == When.CLOSEST) {
            return 0;
        }
        switch (f.getWhich()) {
            case SECOND: {
                return 7;
            }
            case THIRD: {
                return 14;
            }
            case FOURTH: {
                return 21;
            }
        }
        return 0;
    }

    public static TemporalAdjuster closest(DayOfWeek dayOfWeek) {
        return temporal -> {
            int nextDays;
            Temporal previous = temporal.with(TemporalAdjusters.previousOrSame(dayOfWeek));
            Temporal next = temporal.with(TemporalAdjusters.nextOrSame(dayOfWeek));
            int previousDays = Days.between((Temporal)temporal, (Temporal)previous).abs().getAmount();
            return previousDays <= (nextDays = Days.between((Temporal)temporal, (Temporal)next).abs().getAmount()) ? previous : next;
        };
    }
}

