/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.FixedWeekdayInMonth;
import de.jollyday.config.Holidays;
import de.jollyday.config.Which;
import de.jollyday.parser.AbstractHolidayParser;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Set;

public class FixedWeekdayInMonthParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (FixedWeekdayInMonth fwm : config.getFixedWeekday()) {
            if (!this.isValid(fwm, year)) continue;
            LocalDate date = this.parse(year, fwm);
            HolidayType type = this.xmlUtil.getType(fwm.getLocalizedType());
            holidays.add(new Holiday(date, fwm.getDescriptionPropertiesKey(), type));
        }
    }

    protected LocalDate parse(int year, FixedWeekdayInMonth fwm) {
        DayOfWeek weekday = this.xmlUtil.getWeekday(fwm.getWeekday());
        LocalDate date = LocalDate.of(year, this.xmlUtil.getMonth(fwm.getMonth()), 1);
        if (Which.LAST == fwm.getWhich()) {
            return date.with(TemporalAdjusters.lastInMonth(weekday));
        }
        return date.with(TemporalAdjusters.dayOfWeekInMonth(fwm.getWhich().ordinal() + 1, weekday));
    }
}

