/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.FixedWeekdayBetweenFixed;
import de.jollyday.config.Holidays;
import de.jollyday.parser.AbstractHolidayParser;
import java.time.LocalDate;
import java.util.Set;

public class FixedWeekdayBetweenFixedParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (FixedWeekdayBetweenFixed fwm : config.getFixedWeekdayBetweenFixed()) {
            if (!this.isValid(fwm, year)) continue;
            LocalDate from = this.calendarUtil.create(year, fwm.getFrom());
            LocalDate to = this.calendarUtil.create(year, fwm.getTo());
            LocalDate result = null;
            while (!from.isAfter(to)) {
                if (from.getDayOfWeek() == this.xmlUtil.getWeekday(fwm.getWeekday())) {
                    result = from;
                    break;
                }
                from = from.plusDays(1L);
            }
            if (result == null) continue;
            HolidayType type = this.xmlUtil.getType(fwm.getLocalizedType());
            holidays.add(new Holiday(result, fwm.getDescriptionPropertiesKey(), type));
        }
    }
}

