/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.EthiopianOrthodoxHoliday;
import de.jollyday.config.Holidays;
import de.jollyday.parser.AbstractHolidayParser;
import java.time.LocalDate;
import java.util.Set;

public class EthiopianOrthodoxHolidayParser
extends AbstractHolidayParser {
    private static final String PREFIX_PROPERTY_ETHIOPIAN_ORTHODOX = "ethiopian.orthodox.";

    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (EthiopianOrthodoxHoliday h : config.getEthiopianOrthodoxHoliday()) {
            Set<LocalDate> ethiopianHolidays;
            if (!this.isValid(h, year)) continue;
            switch (h.getType()) {
                case TIMKAT: {
                    ethiopianHolidays = this.calendarUtil.getEthiopianOrthodoxHolidaysInGregorianYear(year, 5, 10);
                    break;
                }
                case ENKUTATASH: {
                    ethiopianHolidays = this.calendarUtil.getEthiopianOrthodoxHolidaysInGregorianYear(year, 1, 1);
                    break;
                }
                case MESKEL: {
                    ethiopianHolidays = this.calendarUtil.getEthiopianOrthodoxHolidaysInGregorianYear(year, 1, 17);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ethiopian orthodox holiday type " + (Object)((Object)h.getType()));
                }
            }
            String propertiesKey = PREFIX_PROPERTY_ETHIOPIAN_ORTHODOX + h.getType().name();
            HolidayType type = this.xmlUtil.getType(h.getLocalizedType());
            for (LocalDate d : ethiopianHolidays) {
                holidays.add(new Holiday(d, propertiesKey, type));
            }
        }
    }
}

