/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.config.ChristianHoliday;
import de.jollyday.config.Holidays;
import de.jollyday.parser.impl.RelativeToEasterSundayParser;
import java.time.LocalDate;
import java.util.Set;

public class ChristianHolidayParser
extends RelativeToEasterSundayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (ChristianHoliday ch : config.getChristianHoliday()) {
            if (!this.isValid(ch, year)) continue;
            LocalDate easterSunday = this.getEasterSunday(year, ch.getChronology());
            switch (ch.getType()) {
                case EASTER: {
                    break;
                }
                case CLEAN_MONDAY: 
                case SHROVE_MONDAY: {
                    easterSunday = easterSunday.minusDays(48L);
                    break;
                }
                case MARDI_GRAS: 
                case CARNIVAL: {
                    easterSunday = easterSunday.minusDays(47L);
                    break;
                }
                case ASH_WEDNESDAY: {
                    easterSunday = easterSunday.minusDays(46L);
                    break;
                }
                case MAUNDY_THURSDAY: {
                    easterSunday = easterSunday.minusDays(3L);
                    break;
                }
                case GOOD_FRIDAY: {
                    easterSunday = easterSunday.minusDays(2L);
                    break;
                }
                case EASTER_SATURDAY: {
                    easterSunday = easterSunday.minusDays(1L);
                    break;
                }
                case EASTER_MONDAY: {
                    easterSunday = easterSunday.plusDays(1L);
                    break;
                }
                case EASTER_TUESDAY: {
                    easterSunday = easterSunday.plusDays(2L);
                    break;
                }
                case GENERAL_PRAYER_DAY: {
                    easterSunday = easterSunday.plusDays(26L);
                    break;
                }
                case ASCENSION_DAY: {
                    easterSunday = easterSunday.plusDays(39L);
                    break;
                }
                case PENTECOST: 
                case WHIT_SUNDAY: {
                    easterSunday = easterSunday.plusDays(49L);
                    break;
                }
                case WHIT_MONDAY: 
                case PENTECOST_MONDAY: {
                    easterSunday = easterSunday.plusDays(50L);
                    break;
                }
                case CORPUS_CHRISTI: {
                    easterSunday = easterSunday.plusDays(60L);
                    break;
                }
                case SACRED_HEART: {
                    easterSunday = easterSunday.plusDays(68L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown christian holiday type " + (Object)((Object)ch.getType()));
                }
            }
            easterSunday = this.moveDate(ch, easterSunday);
            String propertiesKey = ch.getDescriptionPropertiesKey();
            String defaultPropertiesKey = "christian." + ch.getType().name();
            if (propertiesKey == null || propertiesKey.isEmpty()) {
                propertiesKey = defaultPropertiesKey;
            }
            this.addChristianHoliday(easterSunday, propertiesKey, ch.getLocalizedType(), holidays);
        }
    }
}

