/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser;

import de.jollyday.config.ChronologyType;
import de.jollyday.config.Holiday;
import de.jollyday.config.MoveableHoliday;
import de.jollyday.config.MovingCondition;
import de.jollyday.config.With;
import de.jollyday.parser.HolidayParser;
import de.jollyday.util.CalendarUtil;
import de.jollyday.util.XMLUtil;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;

public abstract class AbstractHolidayParser
implements HolidayParser {
    private static final String EVERY_YEAR = "EVERY_YEAR";
    private static final String ODD_YEARS = "ODD_YEARS";
    private static final String EVEN_YEARS = "EVEN_YEARS";
    private static final String TWO_YEARS = "2_YEARS";
    private static final String THREE_YEARS = "3_YEARS";
    private static final String FOUR_YEARS = "4_YEARS";
    private static final String FIVE_YEARS = "5_YEARS";
    private static final String SIX_YEARS = "6_YEARS";
    protected CalendarUtil calendarUtil = new CalendarUtil();
    protected XMLUtil xmlUtil = new XMLUtil();

    protected <T extends Holiday> boolean isValid(T h, int year) {
        return this.isValidInYear(h, year) && this.isValidForCycle(h, year);
    }

    private <T extends Holiday> boolean isValidForCycle(T h, int year) {
        if (h.getEvery() != null && !EVERY_YEAR.equals(h.getEvery())) {
            if (ODD_YEARS.equals(h.getEvery())) {
                return year % 2 != 0;
            }
            if (EVEN_YEARS.equals(h.getEvery())) {
                return year % 2 == 0;
            }
            if (h.getValidFrom() != null) {
                int cycleYears;
                if (TWO_YEARS.equalsIgnoreCase(h.getEvery())) {
                    cycleYears = 2;
                } else if (THREE_YEARS.equalsIgnoreCase(h.getEvery())) {
                    cycleYears = 3;
                } else if (FOUR_YEARS.equalsIgnoreCase(h.getEvery())) {
                    cycleYears = 4;
                } else if (FIVE_YEARS.equalsIgnoreCase(h.getEvery())) {
                    cycleYears = 5;
                } else if (SIX_YEARS.equalsIgnoreCase(h.getEvery())) {
                    cycleYears = 6;
                } else {
                    throw new IllegalArgumentException("Cannot handle unknown cycle type '" + h.getEvery() + "'.");
                }
                return (year - h.getValidFrom()) % cycleYears == 0;
            }
        }
        return true;
    }

    private <T extends Holiday> boolean isValidInYear(T h, int year) {
        return !(h.getValidFrom() != null && h.getValidFrom() > year || h.getValidTo() != null && h.getValidTo() < year);
    }

    protected LocalDate moveDate(MoveableHoliday fm, LocalDate fixed) {
        for (MovingCondition mc : fm.getMovingCondition()) {
            if (!this.shallBeMoved(fixed, mc)) continue;
            fixed = this.moveDate(mc, fixed);
            break;
        }
        return fixed;
    }

    protected boolean shallBeMoved(LocalDate fixed, MovingCondition mc) {
        return fixed.getDayOfWeek() == this.xmlUtil.getWeekday(mc.getSubstitute());
    }

    private LocalDate moveDate(MovingCondition mc, LocalDate fixed) {
        DayOfWeek weekday = this.xmlUtil.getWeekday(mc.getWeekday());
        return fixed.with(mc.getWith() == With.NEXT ? TemporalAdjusters.nextOrSame(weekday) : TemporalAdjusters.previousOrSame(weekday));
    }

    protected LocalDate getEasterSunday(int year, ChronologyType ct) {
        LocalDate easterSunday = ct == ChronologyType.JULIAN ? this.calendarUtil.getJulianEasterSunday(year) : (ct == ChronologyType.GREGORIAN ? this.calendarUtil.getGregorianEasterSunday(year) : this.calendarUtil.getEasterSunday(year));
        return easterSunday;
    }
}

