/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.impl.DefaultHolidayManager;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Set;

public class JapaneseHolidayManager
extends DefaultHolidayManager {
    private static final String BRIDGING_HOLIDAY_PROPERTIES_KEY = "BRIDGING_HOLIDAY";

    @Override
    public Set<Holiday> getHolidays(int year, String ... args) {
        Set<Holiday> holidays = super.getHolidays(year, args);
        HashSet<Holiday> additionalHolidays = new HashSet<Holiday>();
        for (Holiday d : holidays) {
            LocalDate twoDaysLater = d.getDate().plusDays(2L);
            if (!this.calendarUtil.contains(holidays, twoDaysLater)) continue;
            LocalDate bridgingDate = twoDaysLater.minusDays(1L);
            additionalHolidays.add(new Holiday(bridgingDate, BRIDGING_HOLIDAY_PROPERTIES_KEY, HolidayType.OFFICIAL_HOLIDAY));
        }
        holidays.addAll(additionalHolidays);
        return holidays;
    }
}

