/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.impl;

import de.jollyday.CalendarHierarchy;
import de.jollyday.Holiday;
import de.jollyday.HolidayManager;
import de.jollyday.config.Configuration;
import de.jollyday.config.Holidays;
import de.jollyday.parser.HolidayParser;
import de.jollyday.util.ClassLoadingUtil;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultHolidayManager
extends HolidayManager {
    private static final Logger LOG = Logger.getLogger(DefaultHolidayManager.class.getName());
    private static final String PARSER_IMPL_PREFIX = "parser.impl.";
    private final Map<String, HolidayParser> parserCache = new HashMap<String, HolidayParser>();
    protected Configuration configuration;
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    @Override
    public Set<Holiday> getHolidays(int year, String ... args) {
        Set<Holiday> holidaySet = Collections.synchronizedSet(new HashSet());
        this.getHolidays(year, this.configuration, holidaySet, args);
        return holidaySet;
    }

    @Override
    public Set<Holiday> getHolidays(LocalDate startDateInclusive, LocalDate endDateInclusive, String ... args) {
        Objects.requireNonNull(startDateInclusive, "startDateInclusive is null");
        Objects.requireNonNull(endDateInclusive, "endInclusive is null");
        HashSet<Holiday> holidays = new HashSet<Holiday>();
        for (int year = startDateInclusive.getYear(); year <= endDateInclusive.getYear(); ++year) {
            Set<Holiday> yearHolidays = this.getHolidays(year, args);
            for (Holiday h : yearHolidays) {
                if (startDateInclusive.isAfter(h.getDate()) || endDateInclusive.isBefore(h.getDate())) continue;
                holidays.add(h);
            }
        }
        return holidays;
    }

    private void getHolidays(int year, Configuration c, Set<Holiday> holidaySet, String ... args) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Adding holidays for " + c.getDescription());
        }
        this.parseHolidays(year, holidaySet, c.getHolidays());
        if (args != null && args.length > 0) {
            String hierarchy = args[0];
            for (Configuration config : c.getSubConfigurations()) {
                if (!hierarchy.equalsIgnoreCase(config.getHierarchy())) continue;
                this.getHolidays(year, config, holidaySet, this.copyOfRange(args, 1, args.length));
                break;
            }
        }
    }

    private String[] copyOfRange(String[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        String[] copy = new String[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private void parseHolidays(int year, Set<Holiday> holidays, Holidays config) {
        Collection<HolidayParser> parsers = this.getParsers(config);
        for (HolidayParser p : parsers) {
            p.parse(year, holidays, config);
        }
    }

    private Collection<HolidayParser> getParsers(Holidays config) {
        HashSet<HolidayParser> parsers = new HashSet<HolidayParser>();
        try {
            PropertyDescriptor[] propertiesDescs;
            for (PropertyDescriptor propertyDescriptor : propertiesDescs = Introspector.getBeanInfo(config.getClass()).getPropertyDescriptors()) {
                String className;
                HolidayParser holidayParser;
                List l;
                if (!List.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || (l = (List)propertyDescriptor.getReadMethod().invoke((Object)config, new Object[0])).isEmpty() || (holidayParser = this.instantiateParser(className = l.get(0).getClass().getName())) == null) continue;
                parsers.add(holidayParser);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create parsers.", e);
        }
        return parsers;
    }

    private HolidayParser instantiateParser(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        HolidayParser holidayParser = this.parserCache.get(className);
        if (holidayParser == null) {
            String propName = PARSER_IMPL_PREFIX + className;
            String parserClassName = this.getManagerParameter().getProperty(propName);
            if (parserClassName != null) {
                Class<?> parserClass = this.classLoadingUtil.loadClass(parserClassName);
                holidayParser = (HolidayParser)parserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.parserCache.put(className, holidayParser);
            }
        }
        return holidayParser;
    }

    @Override
    public void doInit() {
        this.configuration = this.getConfigurationDataSource().getConfiguration(this.getManagerParameter());
        DefaultHolidayManager.validateConfigurationHierarchy(this.configuration);
        DefaultHolidayManager.logHierarchy(this.configuration, 0);
    }

    protected static void logHierarchy(Configuration c, int level) {
        if (LOG.isLoggable(Level.FINER)) {
            StringBuilder space = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                space.append("-");
            }
            LOG.finer(space + " " + c.getDescription() + "(" + c.getHierarchy() + ").");
            for (Configuration sub : c.getSubConfigurations()) {
                DefaultHolidayManager.logHierarchy(sub, level + 1);
            }
        }
    }

    protected static void validateConfigurationHierarchy(Configuration c) {
        HashMap<String, Integer> hierarchyMap = new HashMap<String, Integer>();
        HashSet<String> multipleHierarchies = new HashSet<String>();
        for (Configuration configuration : c.getSubConfigurations()) {
            String hierarchy = configuration.getHierarchy();
            if (!hierarchyMap.containsKey(hierarchy)) {
                hierarchyMap.put(hierarchy, 1);
                continue;
            }
            int count = (Integer)hierarchyMap.get(hierarchy);
            hierarchyMap.put(hierarchy, ++count);
            multipleHierarchies.add(hierarchy);
        }
        if (!multipleHierarchies.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Configuration for ").append(c.getHierarchy()).append(" contains  multiple SubConfigurations with the same hierarchy id. ");
            for (String hierarchy : multipleHierarchies) {
                msg.append(hierarchy).append(" ").append(((Integer)hierarchyMap.get(hierarchy)).toString()).append(" times ");
            }
            throw new IllegalArgumentException(msg.toString().trim());
        }
        for (Configuration configuration : c.getSubConfigurations()) {
            DefaultHolidayManager.validateConfigurationHierarchy(configuration);
        }
    }

    @Override
    public CalendarHierarchy getCalendarHierarchy() {
        return DefaultHolidayManager.createConfigurationHierarchy(this.configuration, null);
    }

    private static CalendarHierarchy createConfigurationHierarchy(Configuration c, CalendarHierarchy h) {
        h = new CalendarHierarchy(h, c.getHierarchy());
        h.setFallbackDescription(c.getDescription());
        for (Configuration sub : c.getSubConfigurations()) {
            CalendarHierarchy subHierarchy = DefaultHolidayManager.createConfigurationHierarchy(sub, h);
            h.getChildren().put(subHierarchy.getId(), subHierarchy);
        }
        return h;
    }
}

