/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.datasource.impl;

import de.jollyday.ManagerParameter;
import de.jollyday.config.Configuration;
import de.jollyday.datasource.ConfigurationDataSource;
import de.jollyday.util.XMLUtil;
import java.io.InputStream;
import java.net.URL;

public class XmlFileDataSource
implements ConfigurationDataSource {
    private XMLUtil xmlUtil = new XMLUtil();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Configuration getConfiguration(ManagerParameter parameter) {
        URL resourceUrl = parameter.createResourceUrl();
        try (InputStream inputStream = resourceUrl.openStream();){
            Configuration configuration = this.xmlUtil.unmarshallConfiguration(inputStream);
            return configuration;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate configuration from URL '" + resourceUrl + "'.", e);
        }
    }
}

