/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.datasource;

import de.jollyday.ManagerParameter;
import de.jollyday.datasource.ConfigurationDataSource;
import de.jollyday.util.ClassLoadingUtil;

public class ConfigurationDataSourceManager {
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public ConfigurationDataSource getConfigurationDataSource(ManagerParameter parameter) {
        this.validateConfiguration(parameter);
        String dataSourceClassName = parameter.getProperty("configuration.datasource.impl");
        return this.instantiateDataSource(dataSourceClassName);
    }

    private ConfigurationDataSource instantiateDataSource(String dataSourceClassName) {
        try {
            Class<?> dataSourceClass = this.classLoadingUtil.loadClass(dataSourceClassName);
            return (ConfigurationDataSource)ConfigurationDataSource.class.cast(dataSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate datasource instance of " + dataSourceClassName, e);
        }
    }

    private void validateConfiguration(ManagerParameter parameter) {
        if (parameter.getProperty("configuration.datasource.impl") == null) {
            throw new IllegalStateException("Missing holiday configuration datasource implementation class under config key configuration.datasource.impl");
        }
    }
}

