/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.configuration.impl;

import de.jollyday.configuration.ConfigurationProvider;
import de.jollyday.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationProvider.class.getName());
    private static final String CONFIG_FILE = "jollyday.properties";
    private final ResourceUtil resourceUtil = new ResourceUtil();

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        try {
            URL config = this.resourceUtil.getResource(CONFIG_FILE);
            if (config == null) {
                throw new IllegalStateException("Properties file jollyday.properties not found on classpath.");
            }
            try (InputStream stream = config.openStream();){
                if (stream != null) {
                    properties.load(stream);
                } else {
                    LOG.log(Level.WARNING, "Could not load default properties file '{0}' from classpath.", new Object[]{CONFIG_FILE});
                }
            }
            return properties;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load default properties from classpath.", e);
        }
    }
}

