/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.configuration;

import de.jollyday.ManagerParameter;
import de.jollyday.configuration.ConfigurationProvider;
import de.jollyday.configuration.impl.DefaultConfigurationProvider;
import de.jollyday.configuration.impl.URLConfigurationProvider;
import de.jollyday.util.ClassLoadingUtil;
import java.util.logging.Logger;

public class ConfigurationProviderManager {
    private static final Logger LOG = Logger.getLogger(ConfigurationProviderManager.class.getName());
    private ConfigurationProvider defaultConfigurationProvider = new DefaultConfigurationProvider();
    private ConfigurationProvider urlConfigurationProvider = new URLConfigurationProvider();
    private ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public void mergeConfigurationProperties(ManagerParameter parameter) {
        this.addInternalConfigurationProviderProperties(parameter);
        this.addCustomConfigurationProviderProperties(parameter);
    }

    private void addInternalConfigurationProviderProperties(ManagerParameter parameter) {
        parameter.mergeProperties(this.urlConfigurationProvider.getProperties());
        parameter.mergeProperties(this.defaultConfigurationProvider.getProperties());
    }

    private void addCustomConfigurationProviderProperties(ManagerParameter parameter) {
        String providersStrList = System.getProperty("de.jollyday.config.providers");
        if (providersStrList != null) {
            String[] providersClassNames;
            for (String providerClassName : providersClassNames = providersStrList.split(",")) {
                if (providerClassName == null || "".equals(providerClassName)) continue;
                try {
                    Class<?> providerClass = Class.forName(providerClassName.trim(), true, this.classLoadingUtil.getClassloader());
                    ConfigurationProvider configurationProvider = (ConfigurationProvider)ConfigurationProvider.class.cast(providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    parameter.mergeProperties(configurationProvider.getProperties());
                }
                catch (Exception e) {
                    LOG.warning("Cannot load configuration from provider class '" + providerClassName + "'. " + e.getClass().getSimpleName() + " (" + e.getMessage() + ").");
                }
            }
        }
    }
}

