/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.caching;

import de.jollyday.HolidayManager;
import de.jollyday.ManagerParameter;
import de.jollyday.datasource.ConfigurationDataSource;
import de.jollyday.datasource.ConfigurationDataSourceManager;
import de.jollyday.util.Cache;
import de.jollyday.util.ClassLoadingUtil;

public class HolidayManagerValueHandler
implements Cache.ValueHandler<HolidayManager> {
    private final ManagerParameter parameter;
    private final String managerImplClassName;
    private final ConfigurationDataSourceManager configurationDataSourceManager = new ConfigurationDataSourceManager();
    private final ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public HolidayManagerValueHandler(ManagerParameter parameter, String managerImplClassName) {
        this.parameter = parameter;
        this.managerImplClassName = managerImplClassName;
    }

    @Override
    public String getKey() {
        return this.parameter.createCacheKey();
    }

    @Override
    public HolidayManager createValue() {
        HolidayManager manager = this.instantiateManagerImpl(this.managerImplClassName);
        ConfigurationDataSource configurationDataSource = this.configurationDataSourceManager.getConfigurationDataSource(this.parameter);
        manager.setConfigurationDataSource(configurationDataSource);
        manager.init(this.parameter);
        return manager;
    }

    private HolidayManager instantiateManagerImpl(String managerImplClassName) {
        try {
            Class<?> managerImplClass = this.classLoadingUtil.loadClass(managerImplClassName);
            Object managerImplObject = managerImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return (HolidayManager)HolidayManager.class.cast(managerImplObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create manager class " + managerImplClassName, e);
        }
    }
}

