/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday;

import de.jollyday.util.ResourceUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CalendarHierarchy {
    private final String id;
    private Map<String, CalendarHierarchy> children = new HashMap<String, CalendarHierarchy>();
    private final CalendarHierarchy parent;
    private final ResourceUtil resourceUtil = new ResourceUtil();
    private String fallbackDescription;

    public CalendarHierarchy(CalendarHierarchy parent, String id) {
        this.parent = parent;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale l) {
        String descr = this.resourceUtil.getCountryDescription(l, this.getPropertiesKey());
        if ("undefined".equals(descr) && this.fallbackDescription != null) {
            descr = this.fallbackDescription;
        }
        return descr;
    }

    private String getPropertiesKey() {
        if (this.parent != null) {
            return this.parent.getPropertiesKey() + "." + this.getId();
        }
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CalendarHierarchy) {
            return ((CalendarHierarchy)obj).getId().equals(this.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void setChildren(Map<String, CalendarHierarchy> children) {
        this.children = children;
    }

    public Map<String, CalendarHierarchy> getChildren() {
        return this.children;
    }

    public void setFallbackDescription(String description) {
        this.fallbackDescription = description;
    }
}

