/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.rest.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.ManagedRuleProvider;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleExecution;
import org.openhab.core.automation.RuleManager;
import org.openhab.core.automation.RulePredicates;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.dto.ActionDTO;
import org.openhab.core.automation.dto.ActionDTOMapper;
import org.openhab.core.automation.dto.ConditionDTO;
import org.openhab.core.automation.dto.ConditionDTOMapper;
import org.openhab.core.automation.dto.ModuleDTO;
import org.openhab.core.automation.dto.RuleDTO;
import org.openhab.core.automation.dto.RuleDTOMapper;
import org.openhab.core.automation.dto.TriggerDTO;
import org.openhab.core.automation.dto.TriggerDTOMapper;
import org.openhab.core.automation.events.AutomationEventFactory;
import org.openhab.core.automation.events.ExecutionEvent;
import org.openhab.core.automation.rest.internal.dto.EnrichedRuleDTO;
import org.openhab.core.automation.rest.internal.dto.EnrichedRuleDTOMapper;
import org.openhab.core.automation.util.ModuleBuilder;
import org.openhab.core.automation.util.RuleBuilder;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangedRunnableListener;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.io.rest.DTOMapper;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.library.types.DateTimeType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="rules")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="rules")
@Component
@JaxrsResource
@JaxrsName(value="rules")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class RuleResource
implements RESTResource {
    public static final String PATH_RULES = "rules";
    private final Logger logger = LoggerFactory.getLogger(RuleResource.class);
    private final DTOMapper dtoMapper;
    private final RuleManager ruleManager;
    private final RuleRegistry ruleRegistry;
    private final ManagedRuleProvider managedRuleProvider;
    private final RegistryChangedRunnableListener<Rule> resetLastModifiedChangeListener = new RegistryChangedRunnableListener(() -> {
        Date date = this.cacheableListLastModified = null;
    });
    @Context
    @NonNullByDefault(value={})
    private UriInfo uriInfo;
    private @Nullable Date cacheableListLastModified = null;

    @Activate
    public RuleResource(@Reference DTOMapper dtoMapper, @Reference RuleManager ruleManager, @Reference RuleRegistry ruleRegistry, @Reference ManagedRuleProvider managedRuleProvider) {
        this.dtoMapper = dtoMapper;
        this.ruleManager = ruleManager;
        this.ruleRegistry = ruleRegistry;
        this.managedRuleProvider = managedRuleProvider;
        this.ruleRegistry.addRegistryChangeListener(this.resetLastModifiedChangeListener);
    }

    @Deactivate
    void deactivate() {
        this.ruleRegistry.removeRegistryChangeListener(this.resetLastModifiedChangeListener);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Produces(value={"application/json"})
    @Operation(operationId="getRules", summary="Get available rules, optionally filtered by tags and/or prefix.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EnrichedRuleDTO.class)))})})
    public Response get(@Context SecurityContext securityContext, @Context Request request, @QueryParam(value="prefix") @Nullable String prefix, @QueryParam(value="tags") @Nullable List<String> tags, @QueryParam(value="summary") @Parameter(description="summary fields only") @Nullable Boolean summary, @DefaultValue(value="false") @QueryParam(value="staticDataOnly") @Parameter(description="provides a cacheable list of values not expected to change regularly and honors the If-Modified-Since header, all other parameters are ignored") boolean staticDataOnly) {
        if (!(summary != null && summary.booleanValue() || securityContext.isUserInRole("administrator"))) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (String)"Authentication required");
        }
        if (staticDataOnly) {
            if (this.cacheableListLastModified != null) {
                Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.cacheableListLastModified);
                if (responseBuilder != null) {
                    return responseBuilder.build();
                }
            } else {
                this.cacheableListLastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
            }
            Stream rules = this.ruleRegistry.stream().map(rule -> EnrichedRuleDTOMapper.map(rule, this.ruleManager, this.managedRuleProvider));
            CacheControl cc = new CacheControl();
            cc.setNoCache(true);
            cc.setMustRevalidate(true);
            cc.setPrivate(true);
            rules = this.dtoMapper.limitToFields(rules, "uid,templateUID,name,visibility,description,tags,editable");
            return Response.ok((Object)new Stream2JSONInputStream(rules)).lastModified(this.cacheableListLastModified).cacheControl(cc).build();
        }
        Predicate<Rule> p = r -> true;
        if (prefix != null) {
            p = p.and(RulePredicates.hasPrefix((String)prefix));
        }
        p = p.and(RulePredicates.hasAllTags(tags));
        Stream rules = this.ruleRegistry.stream().filter(p).map(rule -> EnrichedRuleDTOMapper.map(rule, this.ruleManager, this.managedRuleProvider));
        if (summary != null && summary.booleanValue()) {
            rules = this.dtoMapper.limitToFields(rules, "uid,templateUID,name,visibility,description,status,tags,editable");
        }
        return Response.ok((Object)new Stream2JSONInputStream(rules)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="createRule", summary="Creates a rule.", responses={@ApiResponse(responseCode="201", description="Created", headers={@Header(name="Location", description="Newly created Rule", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="409", description="Creation of the rule is refused. Rule with the same UID already exists."), @ApiResponse(responseCode="400", description="Creation of the rule is refused. Missing required parameter.")})
    public Response create(@Parameter(description="rule data", required=true) RuleDTO rule) throws IOException {
        try {
            Rule newRule = this.ruleRegistry.add(RuleDTOMapper.map((RuleDTO)rule));
            return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)("rules/" + URLEncoder.encode(newRule.getUID(), StandardCharsets.UTF_8))).build();
        }
        catch (IllegalArgumentException e) {
            String errMessage = "Creation of the rule is refused: " + e.getMessage();
            this.logException(e, errMessage);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.CONFLICT, (String)errMessage);
        }
        catch (RuntimeException e) {
            String errMessage = "Creation of the rule is refused: " + e.getMessage();
            this.logException(e, errMessage);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)errMessage);
        }
    }

    private void logException(RuntimeException e, String errMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.warn("{}", (Object)errMessage, (Object)e);
        } else {
            this.logger.warn("{}", (Object)errMessage);
        }
    }

    @GET
    @Path(value="/{ruleUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getRuleById", summary="Gets the rule corresponding to the given UID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedRuleDTO.class))}), @ApiResponse(responseCode="404", description="Rule not found")})
    public Response getByUID(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)((Object)EnrichedRuleDTOMapper.map(rule, this.ruleManager, this.managedRuleProvider))).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="/{ruleUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="deleteRule", summary="Removes an existing rule corresponding to the given UID.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response remove(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID) {
        Rule removedRule = (Rule)this.ruleRegistry.remove((Object)ruleUID);
        if (removedRule == null) {
            this.logger.info("Received HTTP DELETE request at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @PUT
    @Path(value="/{ruleUID}")
    @Consumes(value={"application/json"})
    @Operation(operationId="updateRule", summary="Updates an existing rule corresponding to the given UID.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response update(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @Parameter(description="rule data", required=true) RuleDTO rule) throws IOException {
        rule.uid = ruleUID;
        Rule oldRule = (Rule)this.ruleRegistry.update((Identifiable)RuleDTOMapper.map((RuleDTO)rule));
        if (oldRule == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @GET
    @Path(value="/{ruleUID}/config")
    @Produces(value={"application/json"})
    @Operation(operationId="getRuleConfiguration", summary="Gets the rule configuration values.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response getConfiguration(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP GET request for config at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)rule.getConfiguration().getProperties()).build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @PUT
    @Path(value="/{ruleUID}/config")
    @Consumes(value={"application/json"})
    @Operation(operationId="updateRuleConfiguration", summary="Sets the rule configuration values.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response updateConfiguration(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @Parameter(description="config") Map<String, @Nullable Object> configurationParameters) throws IOException {
        @Nullable Map config = ConfigUtil.normalizeTypes(configurationParameters);
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP PUT request for update config at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        rule = RuleBuilder.create((Rule)rule).withConfiguration(new Configuration(config)).build();
        this.ruleRegistry.update((Identifiable)rule);
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/{ruleUID}/enable")
    @Consumes(value={"text/plain"})
    @Operation(operationId="enableRule", summary="Sets the rule enabled status.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response enableRule(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @Parameter(description="enable", required=true) String enabled) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP PUT request for set enabled at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.ruleManager.setEnabled(ruleUID, !"false".equalsIgnoreCase(enabled));
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{ruleUID}/runnow")
    @Consumes(value={"application/json"})
    @Operation(operationId="runRuleNow", summary="Executes actions of the rule.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response runNow(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @Parameter(description="the context for running this rule", allowEmptyValue=true) @Nullable Map<String, Object> context) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP POST request for run now at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (context == null || context.isEmpty()) {
            ExecutionEvent event = AutomationEventFactory.createExecutionEvent((String)ruleUID, null, (String)"manual");
            this.ruleManager.runNow(ruleUID, false, Map.of("event", event));
        } else {
            this.ruleManager.runNow(ruleUID, false, context);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{ruleUID}/runnow")
    @Consumes(value={"text/plain"})
    @Operation(deprecated=true, operationId="runRuleNow", summary="Executes actions of the rule.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response runNow(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID) throws IOException {
        return this.runNow(ruleUID, null);
    }

    @GET
    @Path(value="/{ruleUID}/triggers")
    @Produces(value={"application/json"})
    @Operation(operationId="getRuleTriggers", summary="Gets the rule triggers.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TriggerDTO.class)))}), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response getTriggers(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)TriggerDTOMapper.map((Collection)rule.getTriggers())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/schedule/simulations")
    @Produces(value={"application/json"})
    @Operation(operationId="getScheduleRuleSimulations", summary="Simulates the executions of rules filtered by tag 'Schedule' within the given times.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RuleExecution.class)))}), @ApiResponse(responseCode="400", description="The max. simulation duration of 180 days is exceeded.")})
    public Response simulateRules(@Parameter(description="Start time of the simulated rule executions. Will default to the current time. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]") @QueryParam(value="from") @Nullable String from, @Parameter(description="End time of the simulated rule executions. Will default to 30 days after the start time. Must be less than 180 days after the given start time. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]") @QueryParam(value="until") @Nullable String until) {
        ZonedDateTime untilDate;
        ZonedDateTime fromDate = from == null || from.isEmpty() ? ZonedDateTime.now() : RuleResource.parseTime(from);
        ZonedDateTime zonedDateTime = untilDate = until == null || until.isEmpty() ? fromDate.plusDays(31L) : RuleResource.parseTime(until);
        if (RuleResource.daysBetween(fromDate, untilDate) >= 180L) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Simulated time span must be smaller than 180 days.");
        }
        Stream ruleExecutions = this.ruleManager.simulateRuleExecutions(fromDate, untilDate);
        return Response.ok(ruleExecutions.toList()).build();
    }

    private static ZonedDateTime parseTime(String sTime) {
        DateTimeType dateTime = new DateTimeType(sTime);
        return dateTime.getZonedDateTime();
    }

    private static long daysBetween(ZonedDateTime d1, ZonedDateTime d2) {
        return ChronoUnit.DAYS.between(d1, d2);
    }

    @GET
    @Path(value="/{ruleUID}/conditions")
    @Produces(value={"application/json"})
    @Operation(operationId="getRuleConditions", summary="Gets the rule conditions.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConditionDTO.class)))}), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response getConditions(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)ConditionDTOMapper.map((List)rule.getConditions())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/actions")
    @Produces(value={"application/json"})
    @Operation(operationId="getRuleActions", summary="Gets the rule actions.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ActionDTO.class)))}), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found.")})
    public Response getActions(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)ActionDTOMapper.map((Collection)rule.getActions())).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}")
    @Produces(value={"application/json"})
    @Operation(operationId="getRuleModuleById", summary="Gets the rule's module corresponding to the given Category and ID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ModuleDTO.class))}), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleById(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @PathParam(value="moduleCategory") @Parameter(description="moduleCategory") String moduleCategory, @PathParam(value="id") @Parameter(description="id") String id) {
        ModuleDTO dto;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (dto = this.getModuleDTO(rule, moduleCategory, id)) != null) {
            return Response.ok((Object)dto).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config")
    @Produces(value={"application/json"})
    @Operation(operationId="getRuleModuleConfig", summary="Gets the module's configuration.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleConfig(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @PathParam(value="moduleCategory") @Parameter(description="moduleCategory") String moduleCategory, @PathParam(value="id") @Parameter(description="id") String id) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            return Response.ok((Object)module.getConfiguration().getProperties()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config/{param}")
    @Produces(value={"text/plain"})
    @Operation(operationId="getRuleModuleConfigParameter", summary="Gets the module's configuration parameter.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleConfigParam(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @PathParam(value="moduleCategory") @Parameter(description="moduleCategory") String moduleCategory, @PathParam(value="id") @Parameter(description="id") String id, @PathParam(value="param") @Parameter(description="param") String param) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            return Response.ok(module.getConfiguration().getProperties().get(param)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config/{param}")
    @Operation(operationId="setRuleModuleConfigParameter", summary="Sets the module's configuration parameter value.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    @Consumes(value={"text/plain"})
    public Response setModuleConfigParam(@PathParam(value="ruleUID") @Parameter(description="ruleUID") String ruleUID, @PathParam(value="moduleCategory") @Parameter(description="moduleCategory") String moduleCategory, @PathParam(value="id") @Parameter(description="id") String id, @PathParam(value="param") @Parameter(description="param") String param, @Parameter(description="value", required=true) String value) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            Configuration configuration = module.getConfiguration();
            configuration.put(param, ConfigUtil.normalizeType((Object)value));
            module = ModuleBuilder.create((Module)module).withConfiguration(configuration).build();
            this.ruleRegistry.update((Identifiable)rule);
            return Response.ok(null, (String)"text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected <T extends Module> @Nullable T getModuleById(@Nullable Collection<T> coll, String id) {
        if (coll == null) {
            return null;
        }
        for (Module module : coll) {
            if (!module.getId().equals(id)) continue;
            return (T)module;
        }
        return null;
    }

    protected @Nullable Trigger getTrigger(Rule rule, String id) {
        return (Trigger)this.getModuleById(rule.getTriggers(), id);
    }

    protected @Nullable Condition getCondition(Rule rule, String id) {
        return (Condition)this.getModuleById(rule.getConditions(), id);
    }

    protected @Nullable Action getAction(Rule rule, String id) {
        return (Action)this.getModuleById(rule.getActions(), id);
    }

    protected @Nullable Module getModule(Rule rule, String moduleCategory, String id) {
        if ("triggers".equals(moduleCategory)) {
            return this.getTrigger(rule, id);
        }
        if ("conditions".equals(moduleCategory)) {
            return this.getCondition(rule, id);
        }
        if ("actions".equals(moduleCategory)) {
            return this.getAction(rule, id);
        }
        return null;
    }

    protected @Nullable ModuleDTO getModuleDTO(Rule rule, String moduleCategory, String id) {
        if ("triggers".equals(moduleCategory)) {
            Trigger trigger = this.getTrigger(rule, id);
            return trigger == null ? null : TriggerDTOMapper.map((Trigger)trigger);
        }
        if ("conditions".equals(moduleCategory)) {
            Condition condition = this.getCondition(rule, id);
            return condition == null ? null : ConditionDTOMapper.map((Condition)condition);
        }
        if ("actions".equals(moduleCategory)) {
            Action action = this.getAction(rule, id);
            return action == null ? null : ActionDTOMapper.map((Action)action);
        }
        return null;
    }
}

