/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.internal.extension;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.ConsoleCommandCompleter;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.io.console.internal.extension.ItemConsoleCommandCompleter;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemNotUniqueException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
@NonNullByDefault
public class UpdateConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private final ItemRegistry itemRegistry;
    private final EventPublisher eventPublisher;

    @Activate
    public UpdateConsoleCommandExtension(@Reference ItemRegistry itemRegistry, @Reference EventPublisher eventPublisher) {
        super("update", "Send a state update to an item.");
        this.itemRegistry = itemRegistry;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public List<String> getUsages() {
        return List.of(this.buildCommandUsage("<item> <state>", "sends a status update for an item"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(String[] args, Console console) {
        block10: {
            if (args.length > 0) {
                itemName = args[0];
                try {
                    item = this.itemRegistry.getItemByPattern(itemName);
                    if (args.length > 1) {
                        stateName = args[1];
                        state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateName);
                        if (state != null) {
                            this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)state));
                            console.println("Update has been sent successfully.");
                        } else {
                            console.println("Error: State '" + stateName + "' is not valid for item '" + itemName + "'");
                            console.print("Valid data types are: ( ");
                            for (Class acceptedType : item.getAcceptedDataTypes()) {
                                console.print(String.valueOf(acceptedType.getSimpleName()) + " ");
                            }
                            console.println(")");
                        }
                    } else {
                        this.printUsage(console);
                    }
                    break block10;
                }
                catch (ItemNotFoundException e) {
                    console.println("Error: Item '" + itemName + "' does not exist.");
                    break block10;
                }
                catch (ItemNotUniqueException e) {
                    console.print("Error: Multiple items match this pattern: ");
                    ** for (item : e.getMatchingItems())
                }
lbl-1000:
                // 1 sources

                {
                    console.print(String.valueOf(item.getName()) + " ");
                    continue;
lbl29:
                    // 1 sources

                    break block10;
                }
            }
            this.printUsage(console);
        }
    }

    @Override
    public @Nullable ConsoleCommandCompleter getCompleter() {
        return new ItemConsoleCommandCompleter(this.itemRegistry, i -> (Class[])i.getAcceptedDataTypes().toArray(Class[]::new));
    }
}

