/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console;

import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.console.ConsoleCommandCompleter;

@NonNullByDefault
public class StringsCompleter
implements ConsoleCommandCompleter {
    private final SortedSet<String> strings;
    private final boolean caseSensitive;

    public StringsCompleter() {
        this(List.of(), false);
    }

    public StringsCompleter(Collection<String> strings, boolean caseSensitive) {
        this.strings = new TreeSet<String>(caseSensitive ? String::compareTo : String::compareToIgnoreCase);
        this.caseSensitive = caseSensitive;
        this.strings.addAll(strings);
    }

    public SortedSet<String> getStrings() {
        return this.strings;
    }

    @Override
    public boolean complete(String[] args, int cursorArgumentIndex, int cursorPosition, List<String> candidates) {
        String argument = cursorArgumentIndex >= 0 && cursorArgumentIndex < args.length ? args[cursorArgumentIndex].substring(0, cursorPosition) : "";
        if (!this.caseSensitive) {
            argument = argument.toLowerCase();
        }
        SortedSet<String> matches = this.getStrings().tailSet(argument);
        for (String match : matches) {
            String s;
            String string = s = this.caseSensitive ? match : match.toLowerCase();
            if (!s.startsWith(argument)) break;
            candidates.add(String.valueOf(match) + " ");
        }
        return !candidates.isEmpty();
    }
}

