/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ConsoleInterpreter {
    public static String getHelp(String base, String separator, Collection<ConsoleCommandExtension> extensions) {
        List<String> usages = ConsoleInterpreter.getUsages(extensions);
        StringBuilder buffer = new StringBuilder();
        buffer.append("---openHAB commands---\n\t");
        int i = 0;
        while (i < usages.size()) {
            String usageString = usages.get(i);
            buffer.append(String.format("%s%s%s\n", base, separator, usageString));
            if (usages.size() > i + 1) {
                buffer.append("\t");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void printHelp(Console console, String base, String separator, Collection<ConsoleCommandExtension> extensions) {
        console.println(ConsoleInterpreter.getHelp(base, separator, extensions));
    }

    public static void execute(Console console, ConsoleCommandExtension extension, String[] args) {
        try {
            extension.execute(args, console);
        }
        catch (Exception ex) {
            Logger logger = LoggerFactory.getLogger(ConsoleInterpreter.class);
            logger.error("An error occurred while executing the console command.", (Throwable)ex);
            console.println("An unexpected error occurred during execution.");
        }
    }

    public static String getUsage(Collection<ConsoleCommandExtension> consoleCommandExtensions) {
        StringBuilder sb = new StringBuilder();
        for (String usage : ConsoleInterpreter.getUsages(consoleCommandExtensions)) {
            sb.append(String.valueOf(usage) + "\n");
        }
        return sb.toString();
    }

    public static List<String> getUsages(Collection<ConsoleCommandExtension> consoleCommandExtensions) {
        ArrayList<String> usages = new ArrayList<String>();
        for (ConsoleCommandExtension consoleCommandExtension : consoleCommandExtensions) {
            usages.addAll(consoleCommandExtension.getUsages());
        }
        return usages;
    }
}

