/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.rule.runtime.internal;

import com.google.inject.Injector;
import com.google.inject.Provider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.openhab.core.model.rule.RulesStandaloneSetup;
import org.openhab.core.model.rule.rules.RuleModel;
import org.openhab.core.model.rule.rules.VariableDeclaration;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.openhab.core.model.script.engine.ScriptExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleContextHelper {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static synchronized IEvaluationContext getContext(RuleModel ruleModel) {
        Logger logger = LoggerFactory.getLogger(RuleContextHelper.class);
        Injector injector = RulesStandaloneSetup.getInjector();
        for (Adapter adapter : ruleModel.eAdapters()) {
            if (!(adapter instanceof RuleContextAdapter var5_5)) continue;
            return contextAdapter.getContext();
        }
        @NonNull Provider contextProvider = injector.getProvider(IEvaluationContext.class);
        ScriptEngine scriptEngine = (ScriptEngine)injector.getInstance(ScriptEngine.class);
        IEvaluationContext evaluationContext = (IEvaluationContext)contextProvider.get();
        for (VariableDeclaration var : ruleModel.getVariables()) {
            try {
                Object initialValue = var.getRight() == null ? null : scriptEngine.newScriptFromXExpression(var.getRight()).execute();
                evaluationContext.newValue(QualifiedName.create((String)var.getName()), initialValue);
            }
            catch (ScriptExecutionException e) {
                logger.warn("Variable '{}' on rule file '{}' cannot be initialized with value '{}': {}", new Object[]{var.getName(), ruleModel.eResource().getURI().path(), var.getRight(), e.getMessage()});
            }
        }
        ruleModel.eAdapters().add((Object)new RuleContextAdapter(evaluationContext));
        return evaluationContext;
    }

    public static synchronized String getVariableDeclaration(RuleModel ruleModel) {
        StringBuilder vars = new StringBuilder();
        for (VariableDeclaration var : ruleModel.getVariables()) {
            vars.append(NodeModelUtils.findActualNodeFor((EObject)var).getText());
        }
        return vars.toString();
    }

    private static class RuleContextAdapter
    extends EContentAdapter {
        private final IEvaluationContext context;

        public RuleContextAdapter(IEvaluationContext context) {
            this.context = context;
        }

        public IEvaluationContext getContext() {
            return this.context;
        }
    }
}

