/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.items;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelGroupFunction implements Enumerator
{
    EQUALITY(0, "EQUALITY", "EQUALITY"),
    AND(1, "AND", "AND"),
    OR(2, "OR", "OR"),
    NAND(3, "NAND", "NAND"),
    NOR(4, "NOR", "NOR"),
    AVG(5, "AVG", "AVG"),
    SUM(6, "SUM", "SUM"),
    MAX(7, "MAX", "MAX"),
    MIN(8, "MIN", "MIN"),
    COUNT(9, "COUNT", "COUNT"),
    LATEST(10, "LATEST", "LATEST"),
    EARLIEST(11, "EARLIEST", "EARLIEST");

    public static final int EQUALITY_VALUE = 0;
    public static final int AND_VALUE = 1;
    public static final int OR_VALUE = 2;
    public static final int NAND_VALUE = 3;
    public static final int NOR_VALUE = 4;
    public static final int AVG_VALUE = 5;
    public static final int SUM_VALUE = 6;
    public static final int MAX_VALUE = 7;
    public static final int MIN_VALUE = 8;
    public static final int COUNT_VALUE = 9;
    public static final int LATEST_VALUE = 10;
    public static final int EARLIEST_VALUE = 11;
    private static final ModelGroupFunction[] VALUES_ARRAY;
    public static final List<ModelGroupFunction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelGroupFunction[]{EQUALITY, AND, OR, NAND, NOR, AVG, SUM, MAX, MIN, COUNT, LATEST, EARLIEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelGroupFunction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelGroupFunction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelGroupFunction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelGroupFunction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelGroupFunction get(int value) {
        switch (value) {
            case 0: {
                return EQUALITY;
            }
            case 1: {
                return AND;
            }
            case 2: {
                return OR;
            }
            case 3: {
                return NAND;
            }
            case 4: {
                return NOR;
            }
            case 5: {
                return AVG;
            }
            case 6: {
                return SUM;
            }
            case 7: {
                return MAX;
            }
            case 8: {
                return MIN;
            }
            case 9: {
                return COUNT;
            }
            case 10: {
                return LATEST;
            }
            case 11: {
                return EARLIEST;
            }
        }
        return null;
    }

    private ModelGroupFunction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

