/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.sitemap.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.sitemap.SitemapProvider;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={SitemapProvider.class})
public class SitemapProviderImpl
implements SitemapProvider,
ModelRepositoryChangeListener {
    private static final String SITEMAP_MODEL_NAME = "sitemap";
    protected static final String SITEMAP_FILEEXT = ".sitemap";
    private final Logger logger = LoggerFactory.getLogger(SitemapProviderImpl.class);
    private final ModelRepository modelRepo;
    private final Map<String, Sitemap> sitemapModelCache = new ConcurrentHashMap<String, Sitemap>();
    private final Set<ModelRepositoryChangeListener> modelChangeListeners = new CopyOnWriteArraySet<ModelRepositoryChangeListener>();

    @Activate
    public SitemapProviderImpl(@Reference ModelRepository modelRepo) {
        this.modelRepo = modelRepo;
        this.refreshSitemapModels();
        modelRepo.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    @Deactivate
    protected void deactivate() {
        this.modelRepo.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.sitemapModelCache.clear();
    }

    @Override
    public @Nullable Sitemap getSitemap(String sitemapName) {
        String filename = String.valueOf(sitemapName) + SITEMAP_FILEEXT;
        Sitemap sitemap = this.sitemapModelCache.get(filename);
        if (sitemap == null) {
            this.logger.trace("Sitemap {} cannot be found", (Object)sitemapName);
            return null;
        }
        if (!sitemap.getName().equals(sitemapName)) {
            this.logger.warn("Filename `{}` does not match the name `{}` of the sitemap - please fix this as you might see unexpected behavior otherwise.", (Object)filename, (Object)sitemap.getName());
        }
        return sitemap;
    }

    @Override
    public Set<String> getSitemapNames() {
        return this.sitemapModelCache.keySet().stream().map(name -> name.substring(0, name.length() - SITEMAP_FILEEXT.length())).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith(SITEMAP_FILEEXT)) {
            if (type == EventType.REMOVED) {
                this.sitemapModelCache.remove(modelName);
            } else {
                Object object;
                EObject sitemap = this.modelRepo.getModel(modelName);
                EObject eObject = sitemap;
                if (eObject instanceof Sitemap && (object = (Sitemap)eObject) == (Sitemap)eObject) {
                    void sitemap1;
                    this.sitemapModelCache.put(modelName, (Sitemap)sitemap1);
                }
            }
        }
        for (ModelRepositoryChangeListener listener : this.modelChangeListeners) {
            listener.modelChanged(modelName, type);
        }
    }

    private void refreshSitemapModels() {
        this.sitemapModelCache.clear();
        Iterable sitemapNames = this.modelRepo.getAllModelNamesOfType(SITEMAP_MODEL_NAME);
        for (String sitemapName : sitemapNames) {
            Sitemap sitemap = (Sitemap)this.modelRepo.getModel(sitemapName);
            if (sitemap == null) continue;
            this.sitemapModelCache.put(sitemapName, sitemap);
        }
    }

    @Override
    public void addModelChangeListener(ModelRepositoryChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    @Override
    public void removeModelChangeListener(ModelRepositoryChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }
}

