/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.http.auth.internal;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.AuthenticationProvider;
import org.openhab.core.auth.ManagedUser;
import org.openhab.core.auth.User;
import org.openhab.core.auth.UserRegistry;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.io.http.auth.internal.AbstractAuthPageServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;

@NonNullByDefault
@Component(immediate=true, service={Servlet.class})
@HttpWhiteboardServletName(value="/createApiToken")
@HttpWhiteboardServletPattern(value={"/createApiToken/*"})
public class CreateAPITokenPageServlet
extends AbstractAuthPageServlet {
    private static final long serialVersionUID = 5340598701104679843L;
    public static final String SERVLET_PATH = "/createApiToken";

    @Activate
    public CreateAPITokenPageServlet(BundleContext bundleContext, @Reference UserRegistry userRegistry, @Reference AuthenticationProvider authProvider, @Reference LocaleProvider localeProvider) {
        super(bundleContext, userRegistry, authProvider, localeProvider);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map params = req.getParameterMap();
        try {
            String message = this.getLocalizedMessage("auth.createapitoken.prompt");
            resp.setContentType("text/html;charset=UTF-8");
            resp.getWriter().append(this.getPageBody(params, message, false));
            resp.getWriter().close();
        }
        catch (Exception e) {
            resp.setContentType("text/plain;charset=UTF-8");
            resp.getWriter().append(e.getMessage());
            resp.getWriter().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map params = req.getParameterMap();
        try {
            User user;
            if (!params.containsKey("username")) {
                throw new AuthenticationException("no username");
            }
            if (!params.containsKey("password")) {
                throw new AuthenticationException("no password");
            }
            if (!params.containsKey("token_name")) {
                throw new AuthenticationException("no token name");
            }
            if (!params.containsKey("csrf_token") || !this.csrfTokens.containsKey(((String[])params.get("csrf_token"))[0])) {
                throw new AuthenticationException("CSRF check failed");
            }
            this.removeCsrfToken(((String[])params.get("csrf_token"))[0]);
            String username = ((String[])params.get("username"))[0];
            String password = ((String[])params.get("password"))[0];
            String tokenName = ((String[])params.get("token_name"))[0];
            String tokenScope = ((String[])params.get("token_scope"))[0];
            User user2 = user = this.login(username, password);
            if (user2 instanceof ManagedUser var10_11) {
                void managedUser;
                if (managedUser.getApiTokens().stream().anyMatch(apiToken -> apiToken.getName().equals(tokenName))) {
                    resp.setContentType("text/html;charset=UTF-8");
                    resp.getWriter().append(this.getPageBody(params, this.getLocalizedMessage("auth.createapitoken.name.unique.fail"), false));
                    resp.getWriter().close();
                    return;
                }
                if (!tokenName.matches("[a-zA-Z0-9]+")) {
                    resp.setContentType("text/html;charset=UTF-8");
                    resp.getWriter().append(this.getPageBody(params, this.getLocalizedMessage("auth.createapitoken.name.format.fail"), false));
                    resp.getWriter().close();
                    return;
                }
            } else {
                throw new AuthenticationException("User is not managed");
            }
            String newApiToken = this.userRegistry.addUserApiToken(user, tokenName, tokenScope);
            String resultMessage = String.valueOf(this.getLocalizedMessage("auth.createapitoken.success")) + "<br /><br /><code>" + newApiToken + "</code>";
            resultMessage = String.valueOf(resultMessage) + "<br /><br /><small>" + this.getLocalizedMessage("auth.createapitoken.success.footer") + "</small>";
            resp.setContentType("text/html;charset=UTF-8");
            resp.getWriter().append(this.getResultPageBody(params, resultMessage));
            resp.getWriter().close();
        }
        catch (AuthenticationException e) {
            this.processFailedLogin(resp, req.getRemoteAddr(), params, e.getMessage());
        }
    }

    @Override
    protected String getPageBody(Map<String, String[]> params, String message, boolean hideForm) {
        String responseBody = this.getPageTemplate().replace("{form_fields}", this.getFormFields(params));
        String buttonLabel = this.getLocalizedMessage("auth.button.createapitoken");
        responseBody = responseBody.replace("{message}", message);
        responseBody = responseBody.replace("{formAction}", SERVLET_PATH);
        responseBody = responseBody.replace("{formClass}", hideForm ? "hide" : "show");
        responseBody = responseBody.replace("{repeatPasswordFieldType}", "hidden");
        responseBody = responseBody.replace("{newPasswordFieldType}", "hidden");
        responseBody = responseBody.replace("{tokenNameFieldType}", "text");
        responseBody = responseBody.replace("{tokenScopeFieldType}", "text");
        responseBody = responseBody.replace("{buttonLabel}", buttonLabel);
        responseBody = responseBody.replace("{resultClass}", "");
        return responseBody;
    }

    protected String getResultPageBody(Map<String, String[]> params, String message) {
        String responseBody = this.getPageTemplate().replace("{form_fields}", "");
        responseBody = responseBody.replace("{message}", message);
        responseBody = responseBody.replace("{formAction}", SERVLET_PATH);
        responseBody = responseBody.replace("{formClass}", "hide");
        responseBody = responseBody.replace("{repeatPasswordFieldType}", "hidden");
        responseBody = responseBody.replace("{newPasswordFieldType}", "hidden");
        responseBody = responseBody.replace("{tokenNameFieldType}", "text");
        responseBody = responseBody.replace("{tokenScopeFieldType}", "text");
        responseBody = responseBody.replace("{resultClass}", "Password");
        return responseBody;
    }

    @Override
    protected String getFormFields(Map<String, String[]> params) {
        String hiddenFormFields = "";
        String csrfToken = this.addCsrfToken();
        hiddenFormFields = String.valueOf(hiddenFormFields) + "<input type=\"hidden\" name=\"csrf_token\" value=\"" + csrfToken + "\">";
        return hiddenFormFields;
    }
}

