/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.upnp.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jupnp.UpnpService;
import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.SubscriptionCallback;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.Service;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.UDAServiceId;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryListener;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.io.transport.upnp.UpnpIOParticipant;
import org.openhab.core.io.transport.upnp.UpnpIOService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class UpnpIOServiceImpl
implements UpnpIOService,
RegistryListener {
    private final Logger logger = LoggerFactory.getLogger(UpnpIOServiceImpl.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"upnp-io");
    private static final int DEFAULT_POLLING_INTERVAL = 60;
    private static final String POOL_NAME = "upnp-io";
    private final UpnpService upnpService;
    final Set<UpnpIOParticipant> participants = new CopyOnWriteArraySet<UpnpIOParticipant>();
    final Map<UpnpIOParticipant, ScheduledFuture> pollingJobs = new ConcurrentHashMap<UpnpIOParticipant, ScheduledFuture>();
    final Map<UpnpIOParticipant, Boolean> currentStates = new ConcurrentHashMap<UpnpIOParticipant, Boolean>();
    final Map<Service, UpnpSubscriptionCallback> subscriptionCallbacks = new ConcurrentHashMap<Service, UpnpSubscriptionCallback>();

    @Activate
    public UpnpIOServiceImpl(@Reference UpnpService upnpService) {
        this.upnpService = upnpService;
    }

    @Activate
    public void activate() {
        this.logger.debug("Starting UPnP IO service...");
        this.upnpService.getRegistry().getRemoteDevices().forEach(device -> this.informParticipants((RemoteDevice)device, true));
        this.upnpService.getRegistry().addListener((RegistryListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.logger.debug("Stopping UPnP IO service...");
        this.upnpService.getRegistry().removeListener((RegistryListener)this);
    }

    private Device getDevice(UpnpIOParticipant participant) {
        return this.upnpService.getRegistry().getDevice(new UDN(participant.getUDN()), true);
    }

    @Override
    public void addSubscription(UpnpIOParticipant participant, String serviceID, int duration) {
        if (participant != null && serviceID != null) {
            this.registerParticipant(participant);
            Device device = this.getDevice(participant);
            if (device != null) {
                Service subService = this.searchSubService(serviceID, device);
                if (subService != null) {
                    this.logger.trace("Setting up an UPNP service subscription '{}' for particpant '{}'", (Object)serviceID, (Object)participant.getUDN());
                    UpnpSubscriptionCallback callback = new UpnpSubscriptionCallback(subService, duration);
                    this.subscriptionCallbacks.put(subService, callback);
                    this.upnpService.getControlPoint().execute((SubscriptionCallback)callback);
                } else {
                    this.logger.trace("Could not find service '{}' for device '{}'", (Object)serviceID, (Object)device.getIdentity().getUdn());
                }
            } else {
                this.logger.trace("Could not find an upnp device for participant '{}'", (Object)participant.getUDN());
            }
        }
    }

    private Service searchSubService(String serviceID, Device device) {
        Device[] embedded;
        Service subService = this.findService(device, serviceID);
        if (subService == null && (embedded = device.getEmbeddedDevices()) != null) {
            Device[] deviceArray = embedded;
            int n = embedded.length;
            int n2 = 0;
            while (n2 < n) {
                Device aDevice = deviceArray[n2];
                subService = this.findService(aDevice, serviceID);
                if (subService != null) break;
                ++n2;
            }
        }
        return subService;
    }

    @Override
    public void removeSubscription(UpnpIOParticipant participant, String serviceID) {
        if (participant != null && serviceID != null) {
            Device device = this.getDevice(participant);
            if (device != null) {
                Service subService = this.searchSubService(serviceID, device);
                if (subService != null) {
                    this.logger.trace("Removing an UPNP service subscription '{}' for particpant '{}'", (Object)serviceID, (Object)participant.getUDN());
                    UpnpSubscriptionCallback callback = this.subscriptionCallbacks.remove(subService);
                    if (callback != null) {
                        callback.end();
                    }
                } else {
                    this.logger.trace("Could not find service '{}' for device '{}'", (Object)serviceID, (Object)device.getIdentity().getUdn());
                }
            } else {
                this.logger.trace("Could not find an upnp device for participant '{}'", (Object)participant.getUDN());
            }
        }
    }

    @Override
    public Map<String, String> invokeAction(UpnpIOParticipant participant, String serviceID, String actionID, Map<String, String> inputs) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (serviceID != null && actionID != null && participant != null) {
            this.registerParticipant(participant);
            Device device = this.getDevice(participant);
            if (device != null) {
                Service service = this.findService(device, serviceID);
                if (service != null) {
                    Action action = service.getAction(actionID);
                    if (action != null) {
                        Map result;
                        ActionInvocation invocation = new ActionInvocation(action);
                        if (inputs != null) {
                            for (String variable : inputs.keySet()) {
                                invocation.setInput(variable, (Object)inputs.get(variable));
                            }
                        }
                        this.logger.trace("Invoking Action '{}' of service '{}' for participant '{}'", new Object[]{actionID, serviceID, participant.getUDN()});
                        new ActionCallback.Default(invocation, this.upnpService.getControlPoint()).run();
                        ActionException anException = invocation.getFailure();
                        if (anException != null && anException.getMessage() != null) {
                            this.logger.debug("{}", (Object)anException.getMessage());
                        }
                        if ((result = invocation.getOutputMap()) != null) {
                            for (String variable : result.keySet()) {
                                ActionArgumentValue newArgument;
                                try {
                                    newArgument = (ActionArgumentValue)result.get(variable);
                                }
                                catch (Exception ex) {
                                    this.logger.debug("An exception '{}' occurred, cannot get argument for variable '{}'", (Object)ex.getMessage(), (Object)variable);
                                    continue;
                                }
                                try {
                                    if (newArgument.getValue() == null) continue;
                                    resultMap.put(variable, newArgument.getValue().toString());
                                }
                                catch (Exception ex) {
                                    this.logger.debug("An exception '{}' occurred processing ActionArgumentValue '{}' with value '{}'", new Object[]{ex.getMessage(), newArgument.getArgument().getName(), newArgument.getValue()});
                                }
                            }
                        }
                    } else {
                        this.logger.debug("Could not find action '{}' for participant '{}'", (Object)actionID, (Object)participant.getUDN());
                    }
                } else {
                    this.logger.debug("Could not find service '{}' for participant '{}'", (Object)serviceID, (Object)participant.getUDN());
                }
            } else {
                this.logger.debug("Could not find an upnp device for participant '{}'", (Object)participant.getUDN());
            }
        }
        return resultMap;
    }

    @Override
    public boolean isRegistered(UpnpIOParticipant participant) {
        return this.upnpService.getRegistry().getDevice(new UDN(participant.getUDN()), true) != null;
    }

    @Override
    public void registerParticipant(UpnpIOParticipant participant) {
        if (participant != null) {
            this.participants.add(participant);
        }
    }

    @Override
    public void unregisterParticipant(UpnpIOParticipant participant) {
        if (participant != null) {
            this.stopPollingForParticipant(participant);
            this.pollingJobs.remove(participant);
            this.currentStates.remove(participant);
            this.participants.remove(participant);
        }
    }

    @Override
    public URL getDescriptorURL(UpnpIOParticipant participant) {
        RemoteDevice device = this.upnpService.getRegistry().getRemoteDevice(new UDN(participant.getUDN()), true);
        if (device != null) {
            return ((RemoteDeviceIdentity)device.getIdentity()).getDescriptorURL();
        }
        return null;
    }

    private Service findService(Device device, String serviceID) {
        Service service = null;
        String namespace = device.getType().getNamespace();
        service = "upnp-org".equals(namespace) || "schemas-upnp-org".equals(namespace) ? device.findService((ServiceId)new UDAServiceId(serviceID)) : device.findService(new ServiceId(namespace, serviceID));
        return service;
    }

    private void informParticipants(RemoteDevice device, boolean status) {
        for (UpnpIOParticipant participant : this.participants) {
            if (!participant.getUDN().equals(((RemoteDeviceIdentity)device.getIdentity()).getUdn().getIdentifierString())) continue;
            this.setDeviceStatus(participant, status);
        }
    }

    private void setDeviceStatus(UpnpIOParticipant participant, boolean newStatus) {
        if (!Objects.equals(this.currentStates.get(participant), newStatus)) {
            this.currentStates.put(participant, newStatus);
            this.logger.debug("Device '{}' reachability status changed to '{}'", (Object)participant.getUDN(), (Object)newStatus);
            participant.onStatusChanged(newStatus);
        }
    }

    @Override
    public void addStatusListener(UpnpIOParticipant participant, String serviceID, String actionID, int interval) {
        if (participant != null) {
            this.registerParticipant(participant);
            int pollingInterval = interval == 0 ? 60 : interval;
            this.stopPollingForParticipant(participant);
            this.currentStates.put(participant, true);
            UPNPPollingRunnable pollingRunnable = new UPNPPollingRunnable(participant, serviceID, actionID);
            this.pollingJobs.put(participant, this.scheduler.scheduleWithFixedDelay(pollingRunnable, 0L, pollingInterval, TimeUnit.SECONDS));
        }
    }

    private void stopPollingForParticipant(UpnpIOParticipant participant) {
        ScheduledFuture pollingJob;
        if (this.pollingJobs.containsKey(participant) && (pollingJob = this.pollingJobs.get(participant)) != null) {
            pollingJob.cancel(true);
        }
    }

    @Override
    public void removeStatusListener(UpnpIOParticipant participant) {
        if (participant != null) {
            this.unregisterParticipant(participant);
        }
    }

    public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
        this.informParticipants(device, true);
    }

    public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
    }

    public void remoteDeviceRemoved(Registry registry, RemoteDevice device) {
        this.informParticipants(device, false);
    }

    public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
    }

    public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
    }

    public void localDeviceAdded(Registry registry, LocalDevice device) {
    }

    public void localDeviceRemoved(Registry registry, LocalDevice device) {
    }

    public void beforeShutdown(Registry registry) {
    }

    public void afterShutdown() {
    }

    private class UPNPPollingRunnable
    implements Runnable {
        private final UpnpIOParticipant participant;
        private final String serviceID;
        private final String actionID;

        public UPNPPollingRunnable(UpnpIOParticipant participant, String serviceID, String actionID) {
            this.participant = participant;
            this.serviceID = serviceID;
            this.actionID = actionID;
        }

        @Override
        public void run() {
            try {
                Device device = UpnpIOServiceImpl.this.getDevice(this.participant);
                if (device != null) {
                    Service service = UpnpIOServiceImpl.this.findService(device, this.serviceID);
                    if (service != null) {
                        Action action = service.getAction(this.actionID);
                        if (action != null) {
                            ActionInvocation invocation = new ActionInvocation(action);
                            UpnpIOServiceImpl.this.logger.debug("Polling participant '{}' through Action '{}' of Service '{}' ", new Object[]{this.participant.getUDN(), this.actionID, this.serviceID});
                            new ActionCallback.Default(invocation, UpnpIOServiceImpl.this.upnpService.getControlPoint()).run();
                            ActionException anException = invocation.getFailure();
                            if (anException != null && anException.getMessage().contains("Connection error or no response received")) {
                                UpnpIOServiceImpl.this.setDeviceStatus(this.participant, false);
                            } else {
                                UpnpIOServiceImpl.this.setDeviceStatus(this.participant, true);
                            }
                        } else {
                            UpnpIOServiceImpl.this.logger.debug("Could not find action '{}' for participant '{}'", (Object)this.actionID, (Object)this.participant.getUDN());
                        }
                    } else {
                        UpnpIOServiceImpl.this.logger.debug("Could not find service '{}' for participant '{}'", (Object)this.serviceID, (Object)this.participant.getUDN());
                    }
                }
            }
            catch (Exception e) {
                UpnpIOServiceImpl.this.logger.error("An exception occurred while polling an UPNP device: '{}'", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public class UpnpSubscriptionCallback
    extends SubscriptionCallback {
        public UpnpSubscriptionCallback(Service service) {
            super(service);
        }

        public UpnpSubscriptionCallback(Service service, int requestedDurationSeconds) {
            super(service, requestedDurationSeconds);
        }

        protected void ended(GENASubscription subscription, CancelReason reason, UpnpResponse response) {
            Service service = subscription.getService();
            if (service != null) {
                ControlPoint cp;
                DeviceIdentity deviceRootIdentity;
                Device deviceRoot;
                ServiceId serviceId = service.getServiceId();
                Device device = service.getDevice();
                if (device != null && (deviceRoot = device.getRoot()) != null && (deviceRootIdentity = deviceRoot.getIdentity()) != null) {
                    UDN deviceRootUdn = deviceRootIdentity.getUdn();
                    UpnpIOServiceImpl.this.logger.debug("A GENA subscription '{}' for device '{}' was ended", (Object)serviceId.getId(), (Object)deviceRootUdn);
                }
                if ((CancelReason.EXPIRED.equals((Object)reason) || CancelReason.RENEWAL_FAILED.equals((Object)reason)) && UpnpIOServiceImpl.this.upnpService != null && (cp = UpnpIOServiceImpl.this.upnpService.getControlPoint()) != null) {
                    UpnpSubscriptionCallback callback = new UpnpSubscriptionCallback(service, subscription.getActualDurationSeconds());
                    cp.execute((SubscriptionCallback)callback);
                }
            }
        }

        protected void established(GENASubscription subscription) {
            Device deviceRoot = subscription.getService().getDevice().getRoot();
            String serviceId = subscription.getService().getServiceId().getId();
            UpnpIOServiceImpl.this.logger.trace("A GENA subscription '{}' for device '{}' is established", (Object)serviceId, (Object)deviceRoot.getIdentity().getUdn());
            for (UpnpIOParticipant participant : UpnpIOServiceImpl.this.participants) {
                if (!Objects.equals(UpnpIOServiceImpl.this.getDevice(participant), deviceRoot)) continue;
                try {
                    participant.onServiceSubscribed(serviceId, true);
                }
                catch (Exception e) {
                    UpnpIOServiceImpl.this.logger.error("Participant threw an exception onServiceSubscribed", (Throwable)e);
                }
            }
        }

        protected void eventReceived(GENASubscription sub) {
            Map values = sub.getCurrentValues();
            Device deviceRoot = sub.getService().getDevice().getRoot();
            String serviceId = sub.getService().getServiceId().getId();
            UpnpIOServiceImpl.this.logger.trace("Receiving a GENA subscription '{}' response for device '{}'", (Object)serviceId, (Object)deviceRoot.getIdentity().getUdn());
            for (UpnpIOParticipant participant : UpnpIOServiceImpl.this.participants) {
                if (!Objects.equals(UpnpIOServiceImpl.this.getDevice(participant), deviceRoot)) continue;
                for (String stateVariable : values.keySet()) {
                    StateVariableValue value = (StateVariableValue)values.get(stateVariable);
                    if (value.getValue() == null) continue;
                    try {
                        participant.onValueReceived(stateVariable, value.getValue().toString(), serviceId);
                    }
                    catch (Exception e) {
                        UpnpIOServiceImpl.this.logger.error("Participant threw an exception onValueReceived", (Throwable)e);
                    }
                }
            }
        }

        protected void eventsMissed(GENASubscription subscription, int numberOfMissedEvents) {
            UpnpIOServiceImpl.this.logger.debug("A GENA subscription '{}' for device '{}' missed events", (Object)subscription.getService().getServiceId(), (Object)subscription.getService().getDevice().getRoot().getIdentity().getUdn());
        }

        protected void failed(GENASubscription subscription, UpnpResponse response, Exception e, String defaultMsg) {
            Device deviceRoot = subscription.getService().getDevice().getRoot();
            String serviceId = subscription.getService().getServiceId().getId();
            UpnpIOServiceImpl.this.logger.debug("A GENA subscription '{}' for device '{}' failed", (Object)serviceId, (Object)deviceRoot.getIdentity().getUdn());
            for (UpnpIOParticipant participant : UpnpIOServiceImpl.this.participants) {
                if (!Objects.equals(UpnpIOServiceImpl.this.getDevice(participant), deviceRoot)) continue;
                try {
                    participant.onServiceSubscribed(serviceId, false);
                }
                catch (Exception e2) {
                    UpnpIOServiceImpl.this.logger.error("Participant threw an exception onServiceSubscribed", (Throwable)e2);
                }
            }
        }
    }
}

