/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sse.internal;

import java.time.DateTimeException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.measure.Unit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.OutboundSseEvent;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.sse.internal.dto.StateDTO;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.service.StartLevelService;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationHelper;
import org.openhab.core.types.State;
import org.openhab.core.types.StateOption;
import org.openhab.core.types.UnDefType;
import org.openhab.core.types.util.UnitUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SseItemStatesEventBuilder.class})
@NonNullByDefault
public class SseItemStatesEventBuilder {
    private final Logger logger = LoggerFactory.getLogger(SseItemStatesEventBuilder.class);
    private final BundleContext bundleContext;
    private final ItemRegistry itemRegistry;
    private final LocaleService localeService;
    private final StartLevelService startLevelService;

    @Activate
    public SseItemStatesEventBuilder(BundleContext bundleContext, @Reference ItemRegistry itemRegistry, @Reference LocaleService localeService, @Reference StartLevelService startLevelService) {
        this.bundleContext = bundleContext;
        this.itemRegistry = itemRegistry;
        this.localeService = localeService;
        this.startLevelService = startLevelService;
    }

    public @Nullable OutboundSseEvent buildEvent(OutboundSseEvent.Builder eventBuilder, Set<String> itemNames) {
        HashMap<String, StateDTO> payload = new HashMap<String, StateDTO>(itemNames.size());
        for (String itemName : itemNames) {
            try {
                Item item = this.itemRegistry.getItem(itemName);
                StateDTO stateDto = new StateDTO();
                stateDto.state = item.getState().toString();
                stateDto.type = SseItemStatesEventBuilder.getStateType(item.getState());
                String displayState = this.getDisplayState(item, this.localeService.getLocale(null));
                if (stateDto.state != null && !stateDto.state.equals(displayState)) {
                    stateDto.displayState = displayState;
                }
                payload.put(itemName, stateDto);
            }
            catch (ItemNotFoundException e) {
                if (this.startLevelService.getStartLevel() < 20) continue;
                this.logger.warn("Attempting to send a state update of an item which doesn't exist: {}", (Object)itemName);
            }
        }
        if (!payload.isEmpty()) {
            return eventBuilder.mediaType(MediaType.APPLICATION_JSON_TYPE).data(payload).build();
        }
        return null;
    }

    private @Nullable String getDisplayState(Item item, Locale locale) {
        block15: {
            block16: {
                stateDescription = item.getStateDescription(locale);
                state = item.getState();
                displayState = state.toString();
                if (state instanceof UnDefType || stateDescription == null) break block15;
                if (stateDescription.getOptions().isEmpty()) break block16;
                for (StateOption option : stateDescription.getOptions()) {
                    if (!option.getValue().equals(state.toString()) || option.getLabel() == null) continue;
                    displayState = option.getLabel();
                    break block15;
                }
                break block15;
            }
            String pattern = stateDescription.getPattern();
            if (pattern == null) break block15;
            if (TransformationHelper.isTransform((String)pattern)) {
                try {
                    displayState = TransformationHelper.transform((BundleContext)this.bundleContext, (String)pattern, (String)state.toString());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (TransformationException e) {
                    this.logger.warn("Failed transforming the state '{}' on item '{}' with pattern '{}': {}", new Object[]{state, item.getName(), pattern, e.getMessage()});
                }
            } else {
                if (state instanceof QuantityType e) {
                    Unit patternUnit = UnitUtils.parseUnit((String)pattern);
                    if (patternUnit != null && !quantityState.getUnit().equals(patternUnit)) {
                        quantityState = quantityState.toInvertibleUnit(patternUnit);
                    }
                    if (quantityState != null) {
                        state = quantityState;
                    }
                } else {
                    if (state instanceof DateTimeType patternUnit) {
                        try {
                            state = type.toLocaleZone();
                        }
                        catch (DateTimeException dateTimeException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    displayState = state.format(pattern);
                }
                catch (IllegalArgumentException e) {
                    this.logger.debug("Unable to format value '{}' of item {} with format '{}': {}, displaying raw state", new Object[]{state, item.getName(), pattern, e.getMessage()});
                    displayState = state.toString();
                }
            }
        }
        return displayState;
    }

    private static String getStateType(State state) {
        String stateClassName = state.getClass().getSimpleName();
        return stateClassName.substring(0, stateClassName.length() - "Type".length());
    }
}

