/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.bin2json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.igormaznitsa.jbbp.JBBPParser;
import com.igormaznitsa.jbbp.exceptions.JBBPException;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPFieldBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldByte;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldUShort;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.bin2json.ConversionException;
import org.openhab.core.util.HexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class Bin2Json {
    private final Logger logger = LoggerFactory.getLogger(Bin2Json.class);
    private final JBBPParser parser;

    public Bin2Json(String parserRule) throws ConversionException {
        try {
            this.parser = JBBPParser.prepare((String)parserRule);
        }
        catch (JBBPException e) {
            throw new ConversionException(String.format("Illegal parser rule, reason: %s", e.getMessage()), e);
        }
    }

    public JsonObject convert(String hexString) throws ConversionException {
        try {
            return this.convert(HexUtils.hexToBytes((String)hexString));
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(String.format("Illegal hexstring , reason: %s", e.getMessage()), e);
        }
    }

    public JsonObject convert(byte[] data) throws ConversionException {
        try {
            return this.convert(this.parser.parse(data));
        }
        catch (JBBPException | IOException e) {
            throw new ConversionException(String.format("Unexpected error, reason: %s", e.getMessage()), e);
        }
    }

    public JsonObject convert(InputStream inputStream) throws ConversionException {
        try {
            return this.convert(this.parser.parse(inputStream));
        }
        catch (JBBPException | IOException e) {
            throw new ConversionException(String.format("Unexpected error, reason: %s", e.getMessage()), e);
        }
    }

    private JsonObject convert(JBBPFieldStruct data) throws ConversionException {
        try {
            LocalDateTime start = LocalDateTime.now();
            JsonObject json = this.convertToJSon((JBBPAbstractField)data);
            if (this.logger.isTraceEnabled()) {
                Duration duration = Duration.between(start, LocalDateTime.now());
                this.logger.trace("Conversion time={}, json={}", (Object)duration, (Object)json);
            }
            return json;
        }
        catch (JBBPException e) {
            throw new ConversionException(String.format("Unexpected error, reason: %s", e.getMessage()), e);
        }
    }

    private JsonObject convertToJSon(JBBPAbstractField field) throws ConversionException {
        return this.convertToJSon(null, field);
    }

    private JsonObject convertToJSon(@Nullable JsonObject json, JBBPAbstractField field) throws ConversionException {
        JsonObject jsn = json == null ? new JsonObject() : json;
        String string = fieldName = field.getFieldName() == null ? "nonamed" : field.getFieldName();
        if (field instanceof JBBPAbstractArrayField) {
            JsonArray jsonArray = new JsonArray();
            if (field instanceof JBBPFieldArrayBit var6_9) {
                byte[] byArray = bit.getArray();
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                    ++n2;
                }
            } else {
                if (field instanceof JBBPFieldArrayBoolean b) {
                    boolean[] blArray = boolean1.getArray();
                    int n = blArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        boolean b = blArray[n3];
                        jsonArray.add((JsonElement)new JsonPrimitive(Boolean.valueOf(b)));
                        ++n3;
                    }
                } else {
                    if (field instanceof JBBPFieldArrayByte b) {
                        byte[] byArray = byte1.getArray();
                        int n = byArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            byte b = byArray[n4];
                            jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                            ++n4;
                        }
                    } else {
                        if (field instanceof JBBPFieldArrayInt b) {
                            int[] nArray = int1.getArray();
                            int n = nArray.length;
                            int n5 = 0;
                            while (n5 < n) {
                                int b = nArray[n5];
                                jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                                ++n5;
                            }
                        } else {
                            if (field instanceof JBBPFieldArrayLong b) {
                                long[] lArray = long1.getArray();
                                int n = lArray.length;
                                int n6 = 0;
                                while (n6 < n) {
                                    long b = lArray[n6];
                                    jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                                    ++n6;
                                }
                            } else {
                                if (field instanceof JBBPFieldArrayShort b) {
                                    short[] sArray = short1.getArray();
                                    int n = sArray.length;
                                    int n7 = 0;
                                    while (n7 < n) {
                                        short b = sArray[n7];
                                        jsonArray.add((JsonElement)new JsonPrimitive((Number)b));
                                        ++n7;
                                    }
                                } else {
                                    if (field instanceof JBBPFieldArrayStruct b) {
                                        int i = 0;
                                        while (i < array.size()) {
                                            jsonArray.add((JsonElement)this.convertToJSon(new JsonObject(), (JBBPAbstractField)array.getElementAt(i)));
                                            ++i;
                                        }
                                    } else {
                                        if (field instanceof JBBPFieldArrayUByte i) {
                                            byte[] byArray = byte1.getArray();
                                            int n = byArray.length;
                                            int n8 = 0;
                                            while (n8 < n) {
                                                byte b = byArray[n8];
                                                jsonArray.add((JsonElement)new JsonPrimitive((Number)(b & 0xFF)));
                                                ++n8;
                                            }
                                        } else {
                                            if (field instanceof JBBPFieldArrayUShort b) {
                                                short[] sArray = short1.getArray();
                                                int n = sArray.length;
                                                int n9 = 0;
                                                while (n9 < n) {
                                                    short b = sArray[n9];
                                                    jsonArray.add((JsonElement)new JsonPrimitive((Number)(b & 0xFFFF)));
                                                    ++n9;
                                                }
                                            } else {
                                                throw new ConversionException(String.format("Unexpected field type '%s'", field));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            jsn.add(fieldName, (JsonElement)jsonArray);
        } else {
            if (field instanceof JBBPFieldBit jsonArray) {
                jsn.addProperty(fieldName, (Number)bit.getAsInt());
            } else {
                 instanceOfPatternExpressionValue = field;
                if ( instanceOfPatternExpressionValue instanceof JBBPFieldBoolean && ( instanceOfPatternExpressionValue = (JBBPFieldBoolean) instanceOfPatternExpressionValue) == (JBBPFieldBoolean) instanceOfPatternExpressionValue) {
                    jsn.addProperty(fieldName, Boolean.valueOf(boolean1.getAsBool()));
                } else {
                     instanceOfPatternExpressionValue = field;
                    if ( instanceOfPatternExpressionValue instanceof JBBPFieldByte && ( instanceOfPatternExpressionValue = (JBBPFieldByte) instanceOfPatternExpressionValue) == (JBBPFieldByte) instanceOfPatternExpressionValue) {
                        jsn.addProperty(fieldName, (Number)byte1.getAsInt());
                    } else {
                         instanceOfPatternExpressionValue = field;
                        if ( instanceOfPatternExpressionValue instanceof JBBPFieldInt && ( instanceOfPatternExpressionValue = (JBBPFieldInt) instanceOfPatternExpressionValue) == (JBBPFieldInt) instanceOfPatternExpressionValue) {
                            jsn.addProperty(fieldName, (Number)int1.getAsInt());
                        } else {
                             instanceOfPatternExpressionValue = field;
                            if ( instanceOfPatternExpressionValue instanceof JBBPFieldLong && ( instanceOfPatternExpressionValue = (JBBPFieldLong) instanceOfPatternExpressionValue) == (JBBPFieldLong) instanceOfPatternExpressionValue) {
                                jsn.addProperty(fieldName, (Number)long1.getAsLong());
                            } else {
                                 instanceOfPatternExpressionValue = field;
                                if ( instanceOfPatternExpressionValue instanceof JBBPFieldShort && ( instanceOfPatternExpressionValue = (JBBPFieldShort) instanceOfPatternExpressionValue) == (JBBPFieldShort) instanceOfPatternExpressionValue) {
                                    jsn.addProperty(fieldName, (Number)short1.getAsInt());
                                } else {
                                     instanceOfPatternExpressionValue = field;
                                    if ( instanceOfPatternExpressionValue instanceof JBBPFieldStruct && ( instanceOfPatternExpressionValue = (JBBPFieldStruct) instanceOfPatternExpressionValue) == (JBBPFieldStruct) instanceOfPatternExpressionValue) {
                                        JsonObject obj = new JsonObject();
                                        JBBPAbstractField[] jBBPAbstractFieldArray = struct.getArray();
                                        int short1 = jBBPAbstractFieldArray.length;
                                        int n = 0;
                                        while (n < short1) {
                                            JBBPAbstractField f = jBBPAbstractFieldArray[n];
                                            this.convertToJSon(obj, f);
                                            ++n;
                                        }
                                        if (json == null) {
                                            return obj;
                                        }
                                        jsn.add(fieldName, (JsonElement)obj);
                                    } else {
                                        if (field instanceof JBBPFieldUByte obj) {
                                            jsn.addProperty(fieldName, (Number)byte1.getAsInt());
                                        } else {
                                             instanceOfPatternExpressionValue = field;
                                            if ( instanceOfPatternExpressionValue instanceof JBBPFieldUShort && (n = (JBBPFieldUShort) instanceOfPatternExpressionValue) == (JBBPFieldUShort) instanceOfPatternExpressionValue) {
                                                jsn.addProperty(fieldName, (Number)short1.getAsInt());
                                            } else {
                                                throw new ConversionException(String.format("Unexpected field '%s'", field));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return jsn;
    }
}

