/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.mdns;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.openhab.core.io.transport.mdns.MDNSClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="mdns-addon-suggestion-finder")
public class MDNSAddonFinder
extends BaseAddonFinder
implements ServiceListener {
    public static final String SERVICE_TYPE = "mdns";
    public static final String SERVICE_NAME = "mdns-addon-suggestion-finder";
    public static final String MDNS_SERVICE_TYPE = "mdnsServiceType";
    private static final String NAME = "name";
    private static final String APPLICATION = "application";
    private final Logger logger = LoggerFactory.getLogger(MDNSAddonFinder.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"mdns-addon-suggestion-finder");
    private final Map<String, ServiceInfo> services = new ConcurrentHashMap<String, ServiceInfo>();
    private MDNSClient mdnsClient;

    @Activate
    public MDNSAddonFinder(@Reference MDNSClient mdnsClient) {
        this.mdnsClient = mdnsClient;
    }

    public void addService(ServiceInfo service, boolean isResolved) {
        String qualifiedName = service.getQualifiedName();
        if ((isResolved || !this.services.containsKey(qualifiedName)) && this.services.put(qualifiedName, service) == null) {
            this.logger.trace("Added service: {}", (Object)qualifiedName);
        }
    }

    @Deactivate
    public void deactivate() {
        this.services.clear();
        this.unsetAddonCandidates();
    }

    public void setAddonCandidates(List<AddonInfo> candidates) {
        this.addonCandidates.stream().filter(c -> !candidates.contains(c)).forEach(c -> c.getDiscoveryMethods().stream().filter(m -> SERVICE_TYPE.equals(m.getServiceType())).filter(m -> !this.getMdnsServiceType((AddonDiscoveryMethod)m).isEmpty()).forEach(m -> this.mdnsClient.removeServiceListener(this.getMdnsServiceType((AddonDiscoveryMethod)m), (ServiceListener)this)));
        super.setAddonCandidates(candidates);
        this.addonCandidates.forEach(c -> c.getDiscoveryMethods().stream().filter(m -> SERVICE_TYPE.equals(m.getServiceType())).filter(m -> !this.getMdnsServiceType((AddonDiscoveryMethod)m).isEmpty()).forEach(m -> {
            String serviceType = this.getMdnsServiceType((AddonDiscoveryMethod)m);
            this.mdnsClient.addServiceListener(serviceType, (ServiceListener)this);
            this.scheduler.submit(() -> this.mdnsClient.list(serviceType));
        }));
    }

    public void unsetAddonCandidates() {
        this.addonCandidates.forEach(c -> c.getDiscoveryMethods().stream().filter(m -> SERVICE_TYPE.equals(m.getServiceType())).filter(m -> !this.getMdnsServiceType((AddonDiscoveryMethod)m).isEmpty()).forEach(m -> this.mdnsClient.removeServiceListener(this.getMdnsServiceType((AddonDiscoveryMethod)m), (ServiceListener)this)));
        super.unsetAddonCandidates();
    }

    public Set<AddonInfo> getSuggestedAddons() {
        HashSet<AddonInfo> result = new HashSet<AddonInfo>();
        for (AddonInfo candidate : this.addonCandidates) {
            block1: for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                Map<String, Pattern> matchProperties = method2.getMatchProperties().stream().collect(Collectors.toMap(property -> property.getName(), property -> property.getPattern()));
                Set matchPropertyKeys = matchProperties.keySet().stream().filter(property -> !NAME.equals(property) && !APPLICATION.equals(property)).collect(Collectors.toSet());
                this.logger.trace("Checking candidate: {}", (Object)candidate.getUID());
                for (ServiceInfo service : this.services.values()) {
                    this.logger.trace("Checking service: {}/{}", (Object)service.getQualifiedName(), (Object)service.getNiceTextString());
                    if (!this.getMdnsServiceType(method2).equals(service.getType()) || !MDNSAddonFinder.propertyMatches(matchProperties, (String)NAME, (String)service.getName()) || !MDNSAddonFinder.propertyMatches(matchProperties, (String)APPLICATION, (String)service.getApplication()) || !matchPropertyKeys.stream().allMatch(name -> MDNSAddonFinder.propertyMatches((Map)matchProperties, (String)name, (String)service.getPropertyString(name)))) continue;
                    result.add(candidate);
                    this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                    continue block1;
                }
            }
        }
        return result;
    }

    private String getMdnsServiceType(AddonDiscoveryMethod method) {
        String param = method.getParameters().stream().filter(p -> MDNS_SERVICE_TYPE.equals(p.getName())).map(p -> p.getValue()).findFirst().orElse("");
        return param == null ? "" : param;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void serviceAdded(@Nullable ServiceEvent event) {
        ServiceInfo service;
        if (event != null && (service = event.getInfo()) != null) {
            this.addService(service, false);
        }
    }

    public void serviceRemoved(@Nullable ServiceEvent event) {
    }

    public void serviceResolved(@Nullable ServiceEvent event) {
        ServiceInfo service;
        if (event != null && (service = event.getInfo()) != null) {
            this.addService(service, true);
        }
    }
}

