/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.karaf.internal.community;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import org.apache.karaf.kar.KarService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.OpenHAB;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.MarketplaceHandlerException;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.util.UIDUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class CommunityKarafAddonHandler
implements MarketplaceAddonHandler {
    private static final Path KAR_CACHE_PATH = Path.of(OpenHAB.getUserDataFolder(), "marketplace", "kar");
    private static final List<String> SUPPORTED_EXT_TYPES = List.of("automation", "binding", "misc", "persistence", "transformation", "ui", "voice");
    private static final String KAR_DOWNLOAD_URL_PROPERTY = "kar_download_url";
    private static final String KAR_EXTENSION = ".kar";
    private final Logger logger = LoggerFactory.getLogger(CommunityKarafAddonHandler.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final KarService karService;
    private boolean isReady = false;

    @Activate
    public CommunityKarafAddonHandler(@Reference KarService karService) {
        this.karService = karService;
        this.scheduler.execute(this::ensureCachedKarsAreInstalled);
    }

    public boolean supports(String type, String contentType) {
        return SUPPORTED_EXT_TYPES.contains(type) && "application/vnd.openhab.feature;type=karfile".equals(contentType);
    }

    private Stream<Path> karFilesStream(Path addonDirectory) throws IOException {
        if (Files.isDirectory(addonDirectory, new LinkOption[0])) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> files = Files.list(addonDirectory);){
                return files.map(Path::getFileName).filter(path -> path.toString().endsWith(KAR_EXTENSION)).toList().stream();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return Stream.empty();
    }

    private String pathToKarRepoName(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.substring(0, fileName.length() - KAR_EXTENSION.length());
    }

    public boolean isInstalled(String addonId) {
        try {
            Path addonDirectory = this.getAddonCacheDirectory(addonId);
            List repositories = this.karService.list();
            return this.karFilesStream(addonDirectory).findFirst().map(this::pathToKarRepoName).map(repositories::contains).orElse(false);
        }
        catch (Exception e) {
            this.logger.warn("Failed to determine installation status for {}: ", (Object)addonId, (Object)e);
            return false;
        }
    }

    public void install(Addon addon) throws MarketplaceHandlerException {
        try {
            URL sourceUrl = new URL((String)addon.getProperties().get(KAR_DOWNLOAD_URL_PROPERTY));
            this.addKarToCache(addon.getUid(), sourceUrl);
            this.installFromCache(addon.getUid());
        }
        catch (MalformedURLException e) {
            throw new MarketplaceHandlerException("Malformed source URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public void uninstall(Addon addon) throws MarketplaceHandlerException {
        try {
            Path addonPath = this.getAddonCacheDirectory(addon.getUid());
            List repositories = this.karService.list();
            for (Path path : this.karFilesStream(addonPath).toList()) {
                String karRepoName = this.pathToKarRepoName(path);
                if (repositories.contains(karRepoName)) {
                    this.karService.uninstall(karRepoName);
                }
                Files.delete(addonPath.resolve(path));
            }
            Files.delete(addonPath);
        }
        catch (Exception e) {
            throw new MarketplaceHandlerException("Failed uninstalling KAR: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addKarToCache(String addonId, URL sourceUrl) throws MarketplaceHandlerException {
        try {
            String fileName = new File(sourceUrl.toURI().getPath()).getName();
            Path addonFile = this.getAddonCacheDirectory(addonId).resolve(fileName);
            Files.createDirectories(addonFile.getParent(), new FileAttribute[0]);
            InputStream source = sourceUrl.openStream();
            Files.copy(source, addonFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | URISyntaxException e) {
            throw new MarketplaceHandlerException("Cannot copy KAR to local cache: " + e.getMessage(), (Throwable)e);
        }
    }

    private void installFromCache(String addonId) throws MarketplaceHandlerException {
        Path addonPath = this.getAddonCacheDirectory(addonId);
        if (Files.isDirectory(addonPath, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<Path> files = Files.list(addonPath);){
                    List<Path> karFiles = files.toList();
                    if (karFiles.size() != 1) {
                        throw new MarketplaceHandlerException("The local cache folder doesn't contain a single file: " + addonPath, null);
                    }
                    try {
                        this.karService.install(karFiles.get(0).toUri(), false);
                    }
                    catch (Exception e) {
                        throw new MarketplaceHandlerException("Cannot install KAR from marketplace cache: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new MarketplaceHandlerException("Could not list files in cache directory " + addonPath, (Throwable)e);
            }
        }
    }

    private void ensureCachedKarsAreInstalled() {
        if (Files.isDirectory(KAR_CACHE_PATH, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Stream<Path> files = Files.list(KAR_CACHE_PATH);){
                    files.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(this::addonIdFromPath).filter(addonId -> !this.isInstalled((String)addonId)).forEach(addonId -> {
                        this.logger.info("Reinstalling missing marketplace KAR: {}", addonId);
                        try {
                            this.installFromCache((String)addonId);
                        }
                        catch (MarketplaceHandlerException e) {
                            this.logger.warn("Failed reinstalling add-on from cache", (Throwable)e);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to re-install KARs: {}", (Object)e.getMessage());
            }
        }
        this.isReady = true;
    }

    private String addonIdFromPath(Path path) {
        String pathName = UIDUtils.decode((String)path.getFileName().toString());
        return pathName.contains(":") ? pathName : "marketplace:" + pathName;
    }

    private Path getAddonCacheDirectory(String addonId) {
        String dir = addonId.startsWith("marketplace:") ? addonId.replace("marketplace:", "") : UIDUtils.encode((String)addonId);
        return KAR_CACHE_PATH.resolve(dir);
    }

    public boolean isReady() {
        return this.isReady;
    }
}

