/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.openhab.core.voice.text.ASTNode;
import org.openhab.core.voice.text.AbstractRuleBasedInterpreter;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.TokenList;

public final class ExpressionIdentifier
extends Expression {
    private AbstractRuleBasedInterpreter interpreter;
    private Expression stopper;

    public ExpressionIdentifier(AbstractRuleBasedInterpreter interpreter) {
        this(interpreter, null);
    }

    public ExpressionIdentifier(AbstractRuleBasedInterpreter interpreter, Expression stopper) {
        this.interpreter = interpreter;
        this.stopper = stopper;
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList list) {
        ASTNode node = new ASTNode();
        node.setSuccess(list.size() > 0 && (this.stopper == null || !this.stopper.parse(language, list).isSuccess()));
        if (node.isSuccess()) {
            node.setRemainingTokens(list.skipHead());
            node.setValue(list.head());
            node.setChildren(new ASTNode[0]);
            this.generateValue(node);
        }
        return node;
    }

    @Override
    boolean collectFirsts(ResourceBundle language, Set<String> firsts) {
        HashSet<String> f = new HashSet<String>(this.interpreter.getAllItemTokens(language.getLocale()));
        if (this.stopper != null) {
            f.removeAll(this.stopper.getFirsts(language));
        }
        firsts.addAll(f);
        return true;
    }

    public String toString() {
        return "identifier(stop=" + this.stopper + ")";
    }

    public AbstractRuleBasedInterpreter getInterpreter() {
        return this.interpreter;
    }

    public Expression getStopper() {
        return this.stopper;
    }
}

