/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.openhab.core.voice.text.ASTNode;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.TokenList;

final class ExpressionAlternatives
extends Expression {
    private List<Expression> subExpressions;

    public ExpressionAlternatives(Expression ... subExpressions) {
        this.subExpressions = List.of(Arrays.copyOf(subExpressions, subExpressions.length));
    }

    @Override
    ASTNode parse(ResourceBundle language, TokenList list) {
        ASTNode node = new ASTNode();
        for (Expression subExpression : this.subExpressions) {
            ASTNode cr = subExpression.parse(language, list);
            if (!cr.isSuccess()) continue;
            node.setChildren(new ASTNode[]{cr});
            node.setRemainingTokens(cr.getRemainingTokens());
            node.setSuccess(true);
            node.setValue(cr.getValue());
            this.generateValue(node);
            return node;
        }
        return node;
    }

    @Override
    List<Expression> getChildExpressions() {
        return this.subExpressions;
    }

    @Override
    boolean collectFirsts(ResourceBundle language, Set<String> firsts) {
        boolean blocking = true;
        for (Expression e : this.subExpressions) {
            boolean bl = blocking = blocking && e.collectFirsts(language, firsts);
        }
        return blocking;
    }

    public String toString() {
        String s = null;
        for (Expression e : this.subExpressions) {
            String string = s = s == null ? e.toString() : String.valueOf(s) + ", " + e.toString();
        }
        return "alt(" + s + ")";
    }
}

