/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import org.openhab.core.voice.text.TokenList;

public class ASTNode {
    private boolean success = false;
    private ASTNode[] children;
    private TokenList remainingTokens;
    private String name;
    private Object value;
    private Object tag;

    public ASTNode() {
    }

    public ASTNode(ASTNode[] children, TokenList remainingTokens) {
        this.success = true;
        this.children = children;
        this.remainingTokens = remainingTokens;
    }

    public ASTNode findNode(String name) {
        if (this.name != null && this.name.equals(name)) {
            return this;
        }
        ASTNode[] aSTNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode sn = aSTNodeArray[n2];
            ASTNode n3 = sn.findNode(name);
            if (n3 != null) {
                return n3;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getValueAsStringArray() {
        Object[] objectArray;
        void var3_1;
        Object[] objectArray2;
        Object object = this.value;
        if (object instanceof Object[] && (objectArray2 = (Object[])object) == (Object[])var3_1) {
            void os;
            objectArray = os;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = this.value;
        }
        Object[] objs = objectArray;
        String[] result = new String[objs.length];
        int i = 0;
        while (i < objs.length) {
            result[i] = objs[i] == null ? "" : "" + objs[i];
            ++i;
        }
        return result;
    }

    public String getValueAsString() {
        return this.value == null ? "" : "" + this.value;
    }

    public String[] findValueAsStringArray(String name) {
        ASTNode node = this.findNode(name);
        return node == null ? null : node.getValueAsStringArray();
    }

    public String findValueAsString(String name) {
        ASTNode node = this.findNode(name);
        return node == null ? null : node.getValueAsString();
    }

    public Object findValue(String name, Class<?> cls) {
        ASTNode node = this.findNode(name);
        return node == null ? null : (node.value != null && cls.isAssignableFrom(node.value.getClass()) ? node.value : null);
    }

    public Object findValue(String name) {
        ASTNode node = this.findNode(name);
        return node == null ? null : node.value;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public ASTNode[] getChildren() {
        return this.children;
    }

    public void setChildren(ASTNode[] children) {
        this.children = children;
    }

    public TokenList getRemainingTokens() {
        return this.remainingTokens;
    }

    public void setRemainingTokens(TokenList remainingTokens) {
        this.remainingTokens = remainingTokens;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }
}

