/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.internal.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.cache.lru.InputStreamCacheWrapper;
import org.openhab.core.cache.lru.LRUMediaCache;
import org.openhab.core.cache.lru.LRUMediaCacheEntry;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.storage.StorageService;
import org.openhab.core.voice.TTSCache;
import org.openhab.core.voice.TTSException;
import org.openhab.core.voice.Voice;
import org.openhab.core.voice.internal.cache.AudioFormatInfo;
import org.openhab.core.voice.internal.cache.AudioStreamFromCache;
import org.openhab.core.voice.internal.cache.CachedTTSService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.openhab.voice"})
@NonNullByDefault
public class TTSLRUCacheImpl
implements TTSCache {
    private final Logger logger = LoggerFactory.getLogger(TTSLRUCacheImpl.class);
    private static final long DEFAULT_CACHE_SIZE_TTS = 10240L;
    private static final int DEFAULT_MAX_TEXT_LENGTH_CACHE_TTS = 150;
    static final String CONFIG_CACHE_SIZE_TTS = "cacheSizeTTS";
    static final String CONFIG_ENABLE_CACHE_TTS = "enableCacheTTS";
    static final String CONFIG_MAX_TEXTLENGTH_CACHE_TTS = "maxTextLengthCacheTTS";
    static final String VOICE_TTS_CACHE_PID = "org.openhab.voice.tts";
    private @Nullable LRUMediaCache<AudioFormatInfo> lruMediaCache;
    protected long cacheSizeTTS = 0xA00000L;
    private long maxTextLengthCacheTTS = 150L;
    protected boolean enableCacheTTS = true;
    private StorageService storageService;

    @Activate
    public TTSLRUCacheImpl(@Reference StorageService storageService, Map<String, Object> config) {
        this.storageService = storageService;
        this.modified(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.enableCacheTTS = (Boolean)ConfigParser.valueAsOrElse((Object)config.get(CONFIG_ENABLE_CACHE_TTS), Boolean.class, (Object)true);
        this.cacheSizeTTS = (Long)ConfigParser.valueAsOrElse((Object)config.get(CONFIG_CACHE_SIZE_TTS), Long.class, (Object)10240L) * 1024L;
        this.maxTextLengthCacheTTS = ((Integer)ConfigParser.valueAsOrElse((Object)config.get(CONFIG_MAX_TEXTLENGTH_CACHE_TTS), Integer.class, (Object)150)).intValue();
        if (this.enableCacheTTS) {
            this.lruMediaCache = new LRUMediaCache(this.storageService, this.cacheSizeTTS, VOICE_TTS_CACHE_PID, this.getClass().getClassLoader());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AudioStream get(CachedTTSService tts, String text, Voice voice, AudioFormat requestedFormat) throws TTSException {
        LRUMediaCacheEntry fileAndMetadata;
        LRUMediaCache<AudioFormatInfo> lruMediaCacheLocal = this.lruMediaCache;
        if (!this.enableCacheTTS || lruMediaCacheLocal == null || this.maxTextLengthCacheTTS > 0L && (long)text.length() > this.maxTextLengthCacheTTS) {
            return tts.synthesizeForCache(text, voice, requestedFormat);
        }
        String key = String.valueOf(tts.getClass().getSimpleName()) + "_" + tts.getCacheKey(text, voice, requestedFormat);
        try {
            fileAndMetadata = lruMediaCacheLocal.get(key, () -> {
                try {
                    AudioStream audioInputStream = tts.synthesizeForCache(text, voice, requestedFormat);
                    return new LRUMediaCacheEntry(key, (InputStream)audioInputStream, (Object)new AudioFormatInfo(audioInputStream.getFormat()));
                }
                catch (TTSException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IllegalStateException ise) {
            TTSException tTSException;
            Throwable throwable;
            if (ise.getCause() != null && (throwable = ise.getCause()) instanceof TTSException && (tTSException = (TTSException)throwable) == (TTSException)throwable) {
                void ttse;
                throw ttse;
            }
            throw ise;
        }
        try {
            InputStream inputStream = fileAndMetadata.getInputStream();
            AudioFormatInfo metadata = (AudioFormatInfo)fileAndMetadata.getMetadata();
            if (metadata == null) {
                throw new IllegalStateException("Cannot have an audio input stream without audio format information");
            }
            InputStream inputStream2 = inputStream;
            if (inputStream2 instanceof InputStreamCacheWrapper && (throwable = (InputStreamCacheWrapper)inputStream2) == (InputStreamCacheWrapper)inputStream2) {
                void inputStreamCacheWrapper;
                return new AudioStreamFromCache((InputStreamCacheWrapper)inputStreamCacheWrapper, metadata, key);
            }
            return (AudioStream)fileAndMetadata.getInputStream();
        }
        catch (IOException e) {
            this.logger.debug("Cannot get audio from cache, fallback to TTS service", (Throwable)e);
            return tts.synthesizeForCache(text, voice, requestedFormat);
        }
    }
}

