/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemNotUniqueException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.voice.DialogContext;
import org.openhab.core.voice.DialogRegistration;
import org.openhab.core.voice.KSService;
import org.openhab.core.voice.STTService;
import org.openhab.core.voice.TTSService;
import org.openhab.core.voice.Voice;
import org.openhab.core.voice.VoiceManager;
import org.openhab.core.voice.text.HumanLanguageInterpreter;
import org.openhab.core.voice.text.InterpretationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
@NonNullByDefault
public class VoiceConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_SAY = "say";
    private static final String SUBCMD_INTERPRET = "interpret";
    private static final String SUBCMD_VOICES = "voices";
    private static final String SUBCMD_START_DIALOG = "startdialog";
    private static final String SUBCMD_STOP_DIALOG = "stopdialog";
    private static final String SUBCMD_REGISTER_DIALOG = "registerdialog";
    private static final String SUBCMD_UNREGISTER_DIALOG = "unregisterdialog";
    private static final String SUBCMD_LISTEN_ANSWER = "listenandanswer";
    private static final String SUBCMD_DIALOGS = "dialogs";
    private static final String SUBCMD_DIALOG_REGS = "dialogregs";
    private static final String SUBCMD_INTERPRETERS = "interpreters";
    private static final String SUBCMD_KEYWORD_SPOTTERS = "keywordspotters";
    private static final String SUBCMD_STT_SERVICES = "sttservices";
    private static final String SUBCMD_TTS_SERVICES = "ttsservices";
    private final ItemRegistry itemRegistry;
    private final VoiceManager voiceManager;
    private final AudioManager audioManager;
    private final LocaleProvider localeProvider;

    @Activate
    public VoiceConsoleCommandExtension(@Reference VoiceManager voiceManager, @Reference AudioManager audioManager, @Reference LocaleProvider localeProvider, @Reference ItemRegistry itemRegistry) {
        super("voice", "Commands around voice enablement features.");
        this.voiceManager = voiceManager;
        this.audioManager = audioManager;
        this.localeProvider = localeProvider;
        this.itemRegistry = itemRegistry;
    }

    public List<String> getUsages() {
        return List.of(this.buildCommandUsage("say <text>", "speaks a text"), this.buildCommandUsage("interpret <command>", "interprets a human language command"), this.buildCommandUsage(SUBCMD_VOICES, "lists available voices of the TTS services"), this.buildCommandUsage(SUBCMD_DIALOGS, "lists the running dialog and their audio/voice services"), this.buildCommandUsage(SUBCMD_DIALOG_REGS, "lists the existing dialog registrations and their selected audio/voice services"), this.buildCommandUsage("registerdialog [--source <source>] [--sink <sink>] [--hlis <comma,separated,interpreters>] [--tts <tts> [--voice <voice>]] [--stt <stt>] [--ks ks [--keyword <ks>]] [--listening-item <listeningItem>] [--location-item <locationItem>] [--dialog-group <dialogGroup>]", "register a new dialog processing using the default services or the services identified with provided arguments, it will be persisted and keep running whenever is possible."), this.buildCommandUsage("unregisterdialog [source]", "unregister the dialog processing for the default audio source or the audio source identified with provided argument, stopping it if started"), this.buildCommandUsage("startdialog [--source <source>] [--sink <sink>] [--hlis <comma,separated,interpreters>] [--tts <tts> [--voice <voice>]] [--stt <stt>] [--ks ks [--keyword <ks>]] [--listening-item <listeningItem>] [--location-item <locationItem>] [--dialog-group <dialogGroup>]", "start a new dialog processing using the default services or the services identified with provided arguments"), this.buildCommandUsage("stopdialog [<source>]", "stop the dialog processing for the default audio source or the audio source identified with provided argument"), this.buildCommandUsage("listenandanswer [--source <source>] [--sink <sink>] [--hlis <comma,separated,interpreters>] [--tts <tts> [--voice <voice>]] [--stt <stt>] [--listening-item <listeningItem>] [--location-item <locationItem>] [--dialog-group <dialogGroup>]", "Execute a simple dialog sequence without keyword spotting using the default services or the services identified with provided arguments"), this.buildCommandUsage(SUBCMD_INTERPRETERS, "lists the interpreters"), this.buildCommandUsage(SUBCMD_KEYWORD_SPOTTERS, "lists the keyword spotters"), this.buildCommandUsage(SUBCMD_STT_SERVICES, "lists the Speech-to-Text services"), this.buildCommandUsage(SUBCMD_TTS_SERVICES, "lists the Text-to-Speech services"));
    }

    public void execute(String[] args, Console console) {
        block68: {
            String subCommand;
            if (args.length <= 0) break block68;
            switch (subCommand = args[0]) {
                case "say": {
                    if (args.length > 1) {
                        this.say(Arrays.copyOfRange(args, 1, args.length), console);
                    } else {
                        console.println("Specify text to say (e.g. 'say hello')");
                    }
                    return;
                }
                case "interpret": {
                    if (args.length > 1) {
                        this.interpret(Arrays.copyOfRange(args, 1, args.length), console);
                    } else {
                        console.println("Specify text to interpret (e.g. 'interpret turn all lights off')");
                    }
                    return;
                }
                case "voices": {
                    Locale locale = this.localeProvider.getLocale();
                    Voice defaultVoice = this.getDefaultVoice();
                    for (Voice voice : this.voiceManager.getAllVoices()) {
                        TTSService ttsService = this.voiceManager.getTTS(voice.getUID().split(":")[0]);
                        if (ttsService == null) continue;
                        console.println(String.format("%s %s - %s - %s (%s)", voice.equals(defaultVoice) ? "*" : " ", ttsService.getLabel(locale), voice.getLocale().getDisplayName(locale), voice.getLabel(), voice.getUID()));
                    }
                    return;
                }
                case "registerdialog": {
                    DialogRegistration dialogRegistration;
                    try {
                        dialogRegistration = this.parseDialogRegistration(args);
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while parsing the dialog options"));
                        break;
                    }
                    try {
                        this.voiceManager.registerDialog(dialogRegistration);
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while registering the dialog"));
                    }
                    return;
                }
                case "unregisterdialog": {
                    try {
                        String sourceId;
                        String string = sourceId = args.length < 2 ? this.audioManager.getSourceId() : args[1];
                        if (sourceId == null) {
                            console.println("No source provided nor default source available");
                            break;
                        }
                        this.voiceManager.unregisterDialog(sourceId);
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while stopping the dialog"));
                    }
                    return;
                }
                case "startdialog": {
                    DialogContext.Builder dialogContextBuilder;
                    try {
                        dialogContextBuilder = this.parseDialogContext(args);
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while parsing the dialog options"));
                        break;
                    }
                    try {
                        this.voiceManager.startDialog(dialogContextBuilder.build());
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while starting the dialog"));
                    }
                    return;
                }
                case "stopdialog": {
                    try {
                        this.voiceManager.stopDialog(args.length < 2 ? null : this.audioManager.getSource(args[1]));
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while stopping the dialog"));
                    }
                    return;
                }
                case "listenandanswer": {
                    DialogContext.Builder dialogContextBuilder;
                    try {
                        dialogContextBuilder = this.parseDialogContext(args);
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while parsing the dialog options"));
                        break;
                    }
                    try {
                        this.voiceManager.listenAndAnswer(dialogContextBuilder.build());
                    }
                    catch (IllegalStateException e) {
                        console.println(Objects.requireNonNullElse(e.getMessage(), "An error occurred while executing the simple dialog sequence"));
                    }
                    return;
                }
                case "dialogs": {
                    this.listDialogs(console);
                    return;
                }
                case "dialogregs": {
                    this.listDialogRegistrations(console);
                    return;
                }
                case "interpreters": {
                    this.listInterpreters(console);
                    return;
                }
                case "keywordspotters": {
                    this.listKeywordSpotters(console);
                    return;
                }
                case "sttservices": {
                    this.listSTTs(console);
                    return;
                }
                case "ttsservices": {
                    this.listTTSs(console);
                    return;
                }
            }
        }
        this.printUsage(console);
    }

    private @Nullable Voice getDefaultVoice() {
        TTSService tts;
        Voice defaultVoice = this.voiceManager.getDefaultVoice();
        if (defaultVoice == null && (tts = this.voiceManager.getTTS()) != null) {
            return this.voiceManager.getPreferredVoice(tts.getAvailableVoices());
        }
        return defaultVoice;
    }

    private void interpret(String[] args, Console console) {
        StringBuilder sb = new StringBuilder(args[0]);
        int i = 1;
        while (i < args.length) {
            sb.append(" ");
            sb.append(args[i]);
            ++i;
        }
        String msg = sb.toString();
        try {
            String result = this.voiceManager.interpret(msg);
            console.println(result);
        }
        catch (InterpretationException ie) {
            console.println(Objects.requireNonNullElse(ie.getMessage(), String.format("An error occurred while interpreting '%s'", msg)));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void say(String[] args, Console console) {
        msg = new StringBuilder();
        var7_4 = args;
        var6_5 = args.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block6: {
                word = var7_4[var5_6];
                if (word.startsWith("%") && word.endsWith("%") && word.length() > 2) {
                    itemName = word.substring(1, word.length() - 1);
                    try {
                        item = this.itemRegistry.getItemByPattern(itemName);
                        msg.append(item.getState());
                        break block6;
                    }
                    catch (ItemNotFoundException e) {
                        console.println("Error: Item '" + itemName + "' does not exist.");
                        break block6;
                    }
                    catch (ItemNotUniqueException e) {
                        console.print("Error: Multiple items match this pattern: ");
                        ** for (item : e.getMatchingItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        console.print(String.valueOf(item.getName()) + " ");
                        continue;
lbl22:
                        // 1 sources

                        break block6;
                    }
                }
                msg.append(word);
            }
            msg.append(" ");
            ++var5_6;
        }
        this.voiceManager.say(msg.toString());
    }

    private void listDialogRegistrations(Console console) {
        List<DialogRegistration> registrations = this.voiceManager.getDialogRegistrations();
        if (!registrations.isEmpty()) {
            registrations.stream().sorted(Comparator.comparing(dr -> dr.sourceId)).forEach(dr -> {
                String locationText = dr.locationItem != null ? String.format(" Location: %s", dr.locationItem) : "";
                console.println(String.format(" Source: %s - Sink: %s (STT: %s, TTS: %s, HLIs: %s, KS: %s, Keyword: %s, Dialog Group: %s)%s", dr.sourceId, dr.sinkId, this.getOrDefault(dr.sttId), this.getOrDefault(dr.ttsId), dr.hliIds.isEmpty() ? this.getOrDefault(null) : String.join((CharSequence)"->", dr.hliIds), this.getOrDefault(dr.ksId), this.getOrDefault(dr.keyword), this.getOrDefault(dr.dialogGroup), locationText));
            });
        } else {
            console.println("No dialog registrations.");
        }
    }

    private String getOrDefault(@Nullable String value) {
        return value != null && !value.isBlank() ? value : "**Default**";
    }

    private void listDialogs(Console console) {
        List<DialogContext> dialogContexts = this.voiceManager.getDialogsContexts();
        if (!dialogContexts.isEmpty()) {
            dialogContexts.stream().sorted(Comparator.comparing(s -> s.source().getId())).forEach(c -> {
                KSService ks = c.ks();
                String ksText = ks != null ? String.format(", KS: %s, Keyword: %s", ks.getId(), c.keyword()) : "";
                String locationText = c.locationItem() != null ? String.format(" Location: %s", c.locationItem()) : "";
                console.println(String.format(" Source: %s - Sink: %s (STT: %s, TTS: %s, HLIs: %s%s, Dialog Group: %s)%s", c.source().getId(), c.sink().getId(), c.stt().getId(), c.tts().getId(), c.hlis().stream().map(HumanLanguageInterpreter::getId).collect(Collectors.joining("->")), ksText, c.dialogGroup(), locationText));
            });
        } else {
            console.println("No running dialogs.");
        }
    }

    private void listInterpreters(Console console) {
        Collection<HumanLanguageInterpreter> interpreters = this.voiceManager.getHLIs();
        if (!interpreters.isEmpty()) {
            HumanLanguageInterpreter defaultHLI = this.voiceManager.getHLI();
            Locale locale = this.localeProvider.getLocale();
            interpreters.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(hli -> console.println(String.format("%s %s (%s)", hli.equals(defaultHLI) ? "*" : " ", hli.getLabel(locale), hli.getId())));
        } else {
            console.println("No interpreters found.");
        }
    }

    private void listKeywordSpotters(Console console) {
        Collection<KSService> spotters = this.voiceManager.getKSs();
        if (!spotters.isEmpty()) {
            KSService defaultKS = this.voiceManager.getKS();
            Locale locale = this.localeProvider.getLocale();
            spotters.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(ks -> console.println(String.format("%s %s (%s)", ks.equals(defaultKS) ? "*" : " ", ks.getLabel(locale), ks.getId())));
        } else {
            console.println("No keyword spotters found.");
        }
    }

    private void listSTTs(Console console) {
        Collection<STTService> services = this.voiceManager.getSTTs();
        if (!services.isEmpty()) {
            STTService defaultSTT = this.voiceManager.getSTT();
            Locale locale = this.localeProvider.getLocale();
            services.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(stt -> console.println(String.format("%s %s (%s)", stt.equals(defaultSTT) ? "*" : " ", stt.getLabel(locale), stt.getId())));
        } else {
            console.println("No Speech-to-Text services found.");
        }
    }

    private void listTTSs(Console console) {
        Collection<TTSService> services = this.voiceManager.getTTSs();
        if (!services.isEmpty()) {
            TTSService defaultTTS = this.voiceManager.getTTS();
            Locale locale = this.localeProvider.getLocale();
            services.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(tts -> console.println(String.format("%s %s (%s)", tts.equals(defaultTTS) ? "*" : " ", tts.getLabel(locale), tts.getId())));
        } else {
            console.println("No Text-to-Speech services found.");
        }
    }

    private @Nullable Voice getVoice(@Nullable String id) {
        return id == null ? null : (Voice)this.voiceManager.getAllVoices().stream().filter(voice -> voice.getUID().equals(id)).findAny().orElse(null);
    }

    private HashMap<String, String> parseDialogParameters(String[] args) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int i = 1;
        while (i < args.length) {
            String arg = args[i].trim();
            if (arg.startsWith("--")) {
                if (++i >= args.length) {
                    throw new IllegalStateException("Missing value for argument " + arg);
                }
            } else {
                throw new IllegalStateException("Argument name should start by -- " + arg);
            }
            parameters.put(arg.replace("--", ""), args[i].trim());
            ++i;
        }
        return parameters;
    }

    private DialogContext.Builder parseDialogContext(String[] args) {
        String sinkId;
        DialogContext.Builder dialogContextBuilder = this.voiceManager.getDialogContextBuilder();
        if (args.length < 2) {
            return dialogContextBuilder;
        }
        HashMap<String, String> parameters = this.parseDialogParameters(args);
        String sourceId = parameters.remove("source");
        if (sourceId != null) {
            AudioSource source = this.audioManager.getSource(sourceId);
            if (source == null) {
                throw new IllegalStateException("Audio source not found");
            }
            dialogContextBuilder.withSource(source);
        }
        if ((sinkId = parameters.remove("sink")) != null) {
            AudioSink sink = this.audioManager.getSink(sinkId);
            if (sink == null) {
                throw new IllegalStateException("Audio sink not found");
            }
            dialogContextBuilder.withSink(sink);
        }
        dialogContextBuilder.withSTT(this.voiceManager.getSTT(parameters.remove("stt"))).withTTS(this.voiceManager.getTTS(parameters.remove("tts"))).withVoice(this.getVoice(parameters.remove("voice"))).withHLIs(this.voiceManager.getHLIsByIds(parameters.remove("hlis"))).withKS(this.voiceManager.getKS(parameters.remove("ks"))).withListeningItem(parameters.remove("listening-item")).withLocationItem(parameters.remove("location-item")).withDialogGroup(parameters.remove("dialog-group")).withKeyword(parameters.remove("keyword"));
        if (!parameters.isEmpty()) {
            throw new IllegalStateException("Argument" + parameters.keySet().stream().findAny().orElse("") + "is not supported");
        }
        return dialogContextBuilder;
    }

    private DialogRegistration parseDialogRegistration(String[] args) {
        HashMap<String, String> parameters = this.parseDialogParameters(args);
        @Nullable String sourceId = parameters.remove("source");
        if (sourceId == null) {
            sourceId = this.audioManager.getSourceId();
        }
        if (sourceId == null) {
            throw new IllegalStateException("A source is required if the default is not configured");
        }
        @Nullable String sinkId = parameters.remove("sink");
        if (sinkId == null) {
            sinkId = this.audioManager.getSinkId();
        }
        if (sinkId == null) {
            throw new IllegalStateException("A sink is required if the default is not configured");
        }
        DialogRegistration dr = new DialogRegistration(sourceId, sinkId);
        dr.ksId = parameters.remove("ks");
        dr.keyword = parameters.remove("keyword");
        dr.sttId = parameters.remove("stt");
        dr.ttsId = parameters.remove("tts");
        dr.voiceId = parameters.remove("voice");
        dr.listeningItem = parameters.remove("listening-item");
        dr.locationItem = parameters.remove("location-item");
        dr.dialogGroup = parameters.remove("dialog-group");
        String hliIds = parameters.remove("hlis");
        if (hliIds != null) {
            dr.hliIds = Arrays.stream(hliIds.split(",")).map(String::trim).toList();
        }
        if (!parameters.isEmpty()) {
            throw new IllegalStateException("Argument " + parameters.keySet().stream().findAny().orElse("") + " is not supported");
        }
        return dr;
    }
}

