/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.voice.TTSCache;
import org.openhab.core.voice.TTSException;
import org.openhab.core.voice.Voice;
import org.openhab.core.voice.internal.cache.CachedTTSService;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
public abstract class AbstractCachedTTSService
implements CachedTTSService {
    private final TTSCache ttsCache;

    public AbstractCachedTTSService(@Reference TTSCache ttsCache) {
        this.ttsCache = ttsCache;
    }

    @Override
    public AudioStream synthesize(String text, Voice voice, AudioFormat requestedFormat) throws TTSException {
        return this.ttsCache.get(this, text, voice, requestedFormat);
    }

    @Override
    public String getCacheKey(String text, Voice voice, AudioFormat requestedFormat) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return "nomd5algorithm";
        }
        byte[] binaryKey = (String.valueOf(text) + voice.getUID() + requestedFormat.toString()).getBytes();
        return String.format("%032x", new BigInteger(1, md.digest(binaryKey)));
    }
}

