/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.karaf.internal;

import org.apache.karaf.features.FeaturesService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.config.discovery.addon.AddonFinderService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.openhab.core.karafaddonfinders", immediate=true)
@NonNullByDefault
public class KarafAddonFinderService
implements AddonFinderService {
    private final Logger logger = LoggerFactory.getLogger(KarafAddonFinderService.class);
    private final FeaturesService featuresService;
    private boolean deactivated;

    @Activate
    public KarafAddonFinderService(@Reference FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    @Deactivate
    protected void deactivate() {
        this.deactivated = true;
    }

    public void install(String id) {
        block4: {
            if (!this.deactivated) {
                try {
                    if (!this.featuresService.isInstalled(this.featuresService.getFeature(id))) {
                        this.featuresService.installFeature(id);
                    }
                }
                catch (Exception e) {
                    if (this.deactivated) break block4;
                    this.logger.error("Failed to install add-on suggestion finder {}", (Object)id, (Object)e);
                }
            }
        }
    }

    public void uninstall(String id) {
        block4: {
            if (!this.deactivated) {
                try {
                    if (this.featuresService.isInstalled(this.featuresService.getFeature(id))) {
                        this.featuresService.uninstallFeature(id);
                    }
                }
                catch (Exception e) {
                    if (this.deactivated) break block4;
                    this.logger.error("Failed to uninstall add-on suggestion finder {}", (Object)id, (Object)e);
                }
            }
        }
    }
}

