/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.id;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.openhab.core.OpenHAB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceUUID {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceUUID.class);
    static final String UUID_FILE_NAME = "uuid";
    static String uuid;

    public static synchronized String get() {
        if (uuid == null) {
            try {
                File file = new File(String.valueOf(OpenHAB.getUserDataFolder()) + File.separator + UUID_FILE_NAME);
                if (!file.exists()) {
                    uuid = UUID.randomUUID().toString();
                    InstanceUUID.writeFile(file, uuid);
                } else {
                    uuid = InstanceUUID.readFirstLine(file);
                    if (uuid != null && !uuid.isEmpty()) {
                        LOGGER.debug("UUID '{}' has been restored from file '{}'", (Object)file.getAbsolutePath(), (Object)uuid);
                    } else {
                        uuid = UUID.randomUUID().toString();
                        LOGGER.warn("UUID file '{}' has no content, rewriting it now with '{}'", (Object)file.getAbsolutePath(), (Object)uuid);
                        InstanceUUID.writeFile(file, uuid);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed writing the UUID file: {}", (Object)e.getMessage());
                return null;
            }
        }
        return uuid;
    }

    private static void writeFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        Files.writeString(file.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String readFirstLine(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                String line = reader.readLine();
                String string = line == null ? "" : line;
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed reading the UUID file '{}': {}", (Object)file.getAbsolutePath(), (Object)ioe.getMessage());
            return "";
        }
    }
}

