/*
 * Tile.java
 *
 * Created on March 14, 2006, 4:53 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.jdesktop.swingx.mapviewer;

import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.beans.AbstractBean;

import org.jdesktop.swingx.util.PaintUtils;

/**
 * The Tile class represents a particular square image
 * piece of the world bitmap at a particular zoom level.
 * @author joshy
 */

public class Tile extends AbstractBean {
    public enum Priority { High, Low }
    Priority priority = Priority.High;
    
    private static final Logger LOG = Logger.getLogger(Tile.class.getName());

    boolean isLoading = false;
    static {
        LOG.setLevel(Level.OFF);
    }
    
    
    //Most Recently Accessed Tiles. These are strong references, to prevent reloading
    //of most recently used tiles.
    //private static final Map<URI, BufferedImage> recentlyAccessed = new HashMap<URI, BufferedImage>();
    //private static final TileCache cache = new TileCache();
    
    /**
     * If an error occurs while loading a tile, store the exception
     * here.
     */
    Throwable error;
    
    /**
     * The url of the image to load for this tile
     */
    private String url;
    
    /**
     * Indicates that loading has succeeded. A PropertyChangeEvent will be fired
     * when the loading is completed
     */
    
    private boolean loaded = false;
    /**
     * The zoom level this tile is for
     */
    private int zoom, x, y;
    
    /**
     * The image loaded for this Tile
     */
    SoftReference<BufferedImage> image = new SoftReference<BufferedImage>(null);
    
    /**
     * Create a new Tile at the specified tile point and zoom level
     * @param location
     * @param zoom
     */
    public Tile(int x, int y, int zoom) {
        loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
    }
    
    /**
     * Create a new Tile that loads its data from the given URL. The URL must
     * resolve to an image
     */
    Tile(int x, int y, int zoom, String url, Priority priority, DefaultTileFactory dtf) {
        this.url = url;
        loaded = false;
        this.zoom = zoom;
        this.x = x;
        this.y = y;
        this.priority = priority;
        this.dtf = dtf;
        //startLoading();
    }
    
    /**
     *
     * Indicates if this tile's underlying image has been successfully loaded yet.
     * @returns true if the Tile has been loaded
     * @return
     */
    public synchronized boolean isLoaded() {
        return loaded;
    }
    
    /**
     * Toggles the loaded state, and fires the appropriate property change notification
     */
    synchronized void setLoaded(boolean loaded) {
        boolean old = isLoaded();
        this.loaded = loaded;
        firePropertyChange("loaded", old, isLoaded());
    }
    
    /**
     * Returns the last error in a possible chain of errors that occured during
     * the loading of the tile
     */
    public Throwable getUnrecoverableError() {
        return error;
    }
    
    /**
     * Returns the Throwable tied to any error that may have ocurred while
     * loading the tile. This error may change several times if multiple
     * errors occur
     * @return
     */
    public Throwable getLoadingError() {
        return error;
    }
    
    /**
     * Returns the Image associated with this Tile. This is a read only property
     *          This may return null at any time, however if this returns null,
     *          a load operation will automatically be started for it.
     */
    public BufferedImage getImage() {
        BufferedImage img = image.get();
        if (img == null) {
            setLoaded(false);
            dtf.startLoading(this);
        }
        
        return img;
    }
    
    /**
     * @return the location in the world at this zoom level that this tile should
     * be placed
     */
    /*
    public TilePoint getLocation() {
        return location;
    }*/
    
    /**
     * @return the zoom level that this tile belongs in
     */
    public int getZoom() {
        return zoom;
    }
    
    //////////////////JavaOne Hack///////////////////
    private PropertyChangeListener uniqueListener = null;
    /**
     * Adds a single property change listener. If a listener has been previously
     * added then it will be replaced by the new one.
     * @param propertyName
     * @param listener
     */
    public void addUniquePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (uniqueListener != null && uniqueListener != listener) {
            removePropertyChangeListener(propertyName, uniqueListener);
        }
        if (uniqueListener != listener) {
            uniqueListener = listener;
            addPropertyChangeListener(propertyName, uniqueListener);
        }
    }
    
    /////////////////End JavaOne Hack/////////////////
    
    /**
     */
    void firePropertyChangeOnEDT(final String propertyName, final Object oldValue, final Object newValue) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    firePropertyChange(propertyName, oldValue, newValue);
                }
            });
        }
    }
    
    private static void p(String string) {
        System.out.println(string);
    }
    
    /**
     * Gets the loading priority of this tile.
     * @return
     */
    public Priority getPriority() {
        return priority;
    }
    
    /**
     * Gets the URL of this tile.
     * @return
     */
    public String getURL() {
        return url;
    }

    public int getX() {
        return x;
    }

    public int getY() {
        return y;
    }
    private DefaultTileFactory dtf;
}

