/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components.win32;

import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.components.win32.NativeWMediaPlayer;
import chrriis.dj.nativeswing.swtimpl.components.win32.WMPControls;
import chrriis.dj.nativeswing.swtimpl.components.win32.WMPMedia;
import chrriis.dj.nativeswing.swtimpl.components.win32.WMPSettings;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWMediaPlayer
extends NSPanelComponent {
    private NativeWMediaPlayer nativeComponent;
    private WMPSettings wmpSettings;
    private WMPControls wmpControls;
    private WMPMedia wmpMedia;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);

    public JWMediaPlayer(NSOption ... options) {
        this.nativeComponent = new NativeWMediaPlayer();
        this.initialize(this.nativeComponent);
        this.wmpSettings = new WMPSettings(this);
        this.wmpControls = new WMPControls(this);
        this.wmpMedia = new WMPMedia(this);
        this.add(this.nativeComponent.createEmbeddableComponent(NSOption.createOptionMap((NSOption[])options)), "Center");
        this.wmpSettings.setAutoStart(true);
        this.wmpSettings.setErrorDialogsEnabled(false);
        this.setControlBarVisible(true);
    }

    public WMPSettings getWMPSettings() {
        return this.wmpSettings;
    }

    public WMPControls getWMPControls() {
        return this.wmpControls;
    }

    public WMPMedia getWMPMedia() {
        return this.wmpMedia;
    }

    public void load(String resourcePath) {
        this.nativeComponent.setOleProperty("url", resourcePath == null ? "" : resourcePath);
    }

    public void load(Class<?> clazz, String resourcePath) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath));
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        this.nativeComponent.setOleProperty("uiMode", isControlBarVisible ? "full" : "none");
    }

    public boolean isControlBarVisible() {
        return Boolean.TRUE.equals("full".equals(this.nativeComponent.getOleProperty("uiMode", new Object[0])));
    }

    public void setFullScreen(boolean isFullScreen) {
        this.nativeComponent.setOleProperty("fullScreen", isFullScreen);
    }

    public boolean isFullScreen() {
        return Boolean.TRUE.equals(this.nativeComponent.getOleProperty("fullScreen", new Object[0]));
    }

    public void setStretchToFit(boolean isStretchToFit) {
        this.nativeComponent.setOleProperty("stretchToFit", isStretchToFit);
    }

    public boolean isStretchToFit() {
        return Boolean.TRUE.equals(this.nativeComponent.getOleProperty("stretchToFit", new Object[0]));
    }

    public WMPMediaState getMediaState() {
        try {
            switch ((Integer)this.nativeComponent.getOleProperty("playState", new Object[0])) {
                case 1: {
                    return WMPMediaState.STOPPED;
                }
                case 2: {
                    return WMPMediaState.PAUSED;
                }
                case 3: {
                    return WMPMediaState.PLAYING;
                }
                case 4: {
                    return WMPMediaState.SCAN_FORWARD;
                }
                case 5: {
                    return WMPMediaState.SCAN_REVERSE;
                }
                case 6: {
                    return WMPMediaState.BUFFERING;
                }
                case 7: {
                    return WMPMediaState.WAITING;
                }
                case 8: {
                    return WMPMediaState.MEDIA_ENDED;
                }
                case 9: {
                    return WMPMediaState.TRANSITIONING;
                }
                case 10: {
                    return WMPMediaState.READY;
                }
                case 11: {
                    return WMPMediaState.RECONNECTING;
                }
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return WMPMediaState.UNDEFINED;
    }

    private void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(referenceClassLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(referenceClassLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(referenceClassLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader referenceClassLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(referenceClassLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WMPMediaState {
        UNDEFINED,
        STOPPED,
        PAUSED,
        PLAYING,
        SCAN_FORWARD,
        SCAN_REVERSE,
        BUFFERING,
        WAITING,
        MEDIA_ENDED,
        TRANSITIONING,
        READY,
        RECONNECTING;

    }
}

