/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeWebBrowser
extends NativeComponent {
    public static final String COMMAND_LOCATION_PREFIX = "command://";
    public static final String COMMAND_STATUS_PREFIX = "scommand://";
    private boolean isXULRunnerRuntime;
    private Reference<JWebBrowser> webBrowser;
    private static Pattern JAVASCRIPT_LINE_COMMENT_PATTERN = Pattern.compile("^\\s*//.*$", 8);
    private String status;
    private String title;
    private int loadingProgress = 100;

    public boolean isXULRunnerRuntime() {
        return this.isXULRunnerRuntime;
    }

    @Override
    protected Object[] getNativePeerCreationParameters() {
        return new Object[]{this.isXULRunnerRuntime};
    }

    protected static Control createControl(Shell shell, Object[] parameters) {
        String xulRunnerPath = System.getProperty("nativeswing.webbrowser.xulrunner.home");
        if (xulRunnerPath != null) {
            System.setProperty("org.eclipse.swt.browser.XULRunnerPath", xulRunnerPath);
        } else {
            xulRunnerPath = System.getProperty("org.eclipse.swt.browser.XULRunnerPath");
            if (xulRunnerPath == null && (xulRunnerPath = System.getenv("XULRUNNER_HOME")) != null) {
                System.setProperty("org.eclipse.swt.browser.XULRunnerPath", xulRunnerPath);
            }
        }
        int style = 0;
        if (((Boolean)parameters[0]).booleanValue()) {
            style |= 0x8000;
        }
        final Browser browser = new Browser((Composite)shell, style);
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                new CMJ_closeWindow().asyncExec((Control)browser, new Object[0]);
            }
        });
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent e) {
                Browser newWebBrowser;
                boolean isDisposed;
                e.required = true;
                final Integer componentID = (Integer)new CMJ_createWindow().syncExec((Control)browser, new Object[0]);
                if (componentID == null) {
                    isDisposed = true;
                    Shell shell = new Shell();
                    newWebBrowser = new Browser((Composite)shell, browser.getStyle());
                } else {
                    isDisposed = false;
                    newWebBrowser = (Browser)NativeWebBrowser.access$9().get(componentID.intValue());
                }
                e.browser = newWebBrowser;
                newWebBrowser.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(){

                    public void show(WindowEvent e) {
                        Browser browser = (Browser)e.widget;
                        if (isDisposed) {
                            final Shell shell = browser.getShell();
                            e.display.asyncExec(new Runnable(){

                                public void run() {
                                    shell.close();
                                }
                            });
                        } else {
                            browser.removeVisibilityWindowListener((VisibilityWindowListener)this);
                            new CMJ_showWindow().asyncExec((Control)newWebBrowser, componentID, e.menuBar, e.toolBar, e.addressBar, e.statusBar, e.location == null ? null : new Point(e.location.x, e.location.y), e.size == null ? null : new Dimension(e.size.x, e.size.y));
                        }
                    }
                });
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent e) {
                browser.setData("Browser.loading", (Object)false);
                new CMJ_locationChanged().asyncExec((Control)browser, e.location, e.top);
            }

            public void changing(LocationEvent e) {
                String location = e.location;
                if (location.startsWith(NativeWebBrowser.COMMAND_LOCATION_PREFIX)) {
                    e.doit = false;
                    String query = location.substring(NativeWebBrowser.COMMAND_LOCATION_PREFIX.length());
                    if (query.endsWith("/")) {
                        query = query.substring(0, query.length() - 1);
                    }
                    ArrayList<String> queryElementList = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(query, "&", true);
                    String lastToken = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("&".equals(token)) {
                            if (lastToken == null) {
                                queryElementList.add("");
                            }
                            lastToken = null;
                            continue;
                        }
                        lastToken = token;
                        queryElementList.add(Utils.decodeURL((String)token));
                    }
                    if (lastToken == null) {
                        queryElementList.add("");
                    }
                    String command = queryElementList.isEmpty() ? "" : (String)queryElementList.remove(0);
                    String[] args = queryElementList.toArray(new String[0]);
                    new CMJ_commandReceived().asyncExec((Control)browser, command, args);
                    return;
                }
                if (location.startsWith("javascript:")) {
                    return;
                }
                browser.setData("CMJ_updateStatus.status", null);
                browser.setData("CMJ_updateProgress.progress", null);
                browser.setData("Browser.loading", (Object)true);
                e.doit = Boolean.TRUE.equals(new CMJ_locationChanging().syncExec((Control)browser, location, e.top));
                if (!e.doit) {
                    browser.setData("Browser.loading", (Object)false);
                    new CMJ_locationChangeCanceled().asyncExec((Control)browser, location, e.top);
                }
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent e) {
                new CMJ_updateTitle().asyncExec((Control)browser, e.title);
            }
        });
        browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent e) {
                final String oldStatus = (String)browser.getData("CMJ_updateStatus.status");
                final String newStatus = e.text;
                if (newStatus.startsWith(NativeWebBrowser.COMMAND_STATUS_PREFIX)) {
                    e.display.asyncExec(new Runnable(){

                        public void run() {
                            browser.execute(NativeWebBrowser.fixJavascript(browser, "if(decodeURIComponent('" + Utils.encodeURL((String)newStatus) + "') == window.status) {window.status = decodeURIComponent('" + Utils.encodeURL((String)(oldStatus == null ? "" : oldStatus)) + "');}"));
                        }
                    });
                    String query = newStatus.substring(NativeWebBrowser.COMMAND_STATUS_PREFIX.length());
                    if (query.endsWith("/")) {
                        query = query.substring(0, query.length() - 1);
                    }
                    ArrayList<String> queryElementList = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(query, "&", true);
                    String lastToken = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("&".equals(token)) {
                            if (lastToken == null) {
                                queryElementList.add("");
                            }
                            lastToken = null;
                            continue;
                        }
                        lastToken = token;
                        queryElementList.add(Utils.decodeURL((String)token));
                    }
                    if (lastToken == null) {
                        queryElementList.add("");
                    }
                    String command = queryElementList.isEmpty() ? "" : (String)queryElementList.remove(0);
                    String[] args = queryElementList.toArray(new String[0]);
                    new CMJ_commandReceived().asyncExec((Control)browser, command, args);
                    return;
                }
                if (!Utils.equals((Object)oldStatus, (Object)newStatus)) {
                    browser.setData("CMJ_updateStatus.status", (Object)newStatus);
                    new CMJ_updateStatus().asyncExec((Control)browser, newStatus);
                }
            }
        });
        browser.addProgressListener(new ProgressListener(){

            private void updateProgress(int loadingProgress) {
                Integer oldLoadingProgress = (Integer)browser.getData("CMJ_updateProgress.progress");
                if (!Utils.equals((Object)oldLoadingProgress, (Object)loadingProgress)) {
                    browser.setData("CMJ_updateProgress.progress", (Object)loadingProgress);
                    new CMJ_updateLoadingProgress().asyncExec((Control)browser, loadingProgress);
                }
            }

            public void changed(ProgressEvent e) {
                if (e.total <= 0 || e.total < e.current) {
                    return;
                }
                browser.setData("Browser.loading", (Object)true);
                this.updateProgress(e.current == e.total ? 100 : Math.min(e.current * 100 / e.total, 99));
            }

            public void completed(ProgressEvent progressevent) {
                browser.setData("Browser.loading", (Object)false);
                this.updateProgress(100);
            }
        });
        NativeWebBrowser.registerDefaultPopupMenu(browser);
        return browser;
    }

    public NativeWebBrowser(JWebBrowser webBrowser, boolean isXULRunnerRuntime) {
        this.webBrowser = new WeakReference<JWebBrowser>(webBrowser);
        this.isXULRunnerRuntime = isXULRunnerRuntime || "xulrunner".equals(System.getProperty("nativeswing.webbrowser.runtime"));
    }

    public static void clearSessionCookies() {
        new CMN_clearSessionCookies().asyncExec(true, new Object[0]);
    }

    public static String getCookie(String url, String name) {
        return (String)new CMN_getCookie().syncExec(true, url, name);
    }

    public static void setCookie(String url, String value) {
        new CMN_setCookie().asyncExec(true, url, value);
    }

    public String getResourceLocation() {
        return (String)this.runSync(new CMN_getResourceLocation(), new Object[0]);
    }

    public boolean navigate(String resourceLocation) {
        return Boolean.TRUE.equals(this.runSync(new CMN_navigate(), resourceLocation));
    }

    public String getHTMLContent() {
        return (String)this.runSync(new CMN_getHTMLContent(), new Object[0]);
    }

    public boolean setHTMLContent(String html) {
        return Boolean.TRUE.equals(this.runSync(new CMN_setHTMLContent(), html));
    }

    public boolean isJavascriptEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isJavascriptEnabled(), new Object[0]));
    }

    public void setJavascriptEnabled(boolean isJavascriptEnabled) {
        this.runAsync(new CMN_setJavascriptEnabled(), isJavascriptEnabled);
    }

    private static String fixJavascript(Browser browser, String script) {
        if ("mozilla".equals(browser.getBrowserType())) {
            script = JAVASCRIPT_LINE_COMMENT_PATTERN.matcher(script).replaceAll("");
            script = Utils.encodeURL((String)script);
        }
        return script;
    }

    public boolean executeJavascriptAndWait(String script) {
        return Boolean.TRUE.equals(this.runSync(new CMN_executeJavascript(), script));
    }

    public void executeJavascript(String script) {
        this.runAsync(new CMN_executeJavascript(), script);
    }

    public Object executeJavascriptWithResult(String script) {
        return this.runSync(new CMN_executeJavascriptWithResult(), script);
    }

    public void stopLoading() {
        this.runAsync(new CMN_stopLoading(), new Object[0]);
    }

    public void reloadPage() {
        this.runAsync(new CMN_reloadPage(), new Object[0]);
    }

    public boolean isBackNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isBackNavigationEnabled(), new Object[0]));
    }

    public void navigateBack() {
        this.runAsync(new CMN_navigateBack(), new Object[0]);
    }

    public boolean isForwardNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isForwardNavigationEnabled(), new Object[0]));
    }

    public void navigateForward() {
        this.runAsync(new CMN_navigateForward(), new Object[0]);
    }

    private static void registerDefaultPopupMenu(final Browser browser) {
        Menu oldMenu = browser.getMenu();
        if (oldMenu != null) {
            oldMenu.dispose();
        }
        if ("ie".equals(browser.getBrowserType())) {
            browser.setMenu(null);
            return;
        }
        Menu menu = new Menu((Decorations)browser.getShell(), 8);
        String className = NativeWebBrowser.class.getName();
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/WebBrowser");
        final MenuItem backMenuItem = new MenuItem(menu, 8);
        backMenuItem.setText(bundle.getString("SystemMenuBack"));
        backMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuBackIcon"))));
        backMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.back();
            }
        });
        final MenuItem forwardMenuItem = new MenuItem(menu, 8);
        forwardMenuItem.setText(bundle.getString("SystemMenuForward"));
        forwardMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuForwardIcon"))));
        forwardMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.forward();
            }
        });
        MenuItem reloadMenuItem = new MenuItem(menu, 8);
        reloadMenuItem.setText(bundle.getString("SystemMenuReload"));
        reloadMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuReloadIcon"))));
        reloadMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.refresh();
            }
        });
        final MenuItem stopMenuItem = new MenuItem(menu, 8);
        stopMenuItem.setText(bundle.getString("SystemMenuStop"));
        stopMenuItem.setImage(new Image((Device)browser.getDisplay(), NativeWebBrowser.class.getResourceAsStream(bundle.getString("SystemMenuStopIcon"))));
        stopMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browser.stop();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                backMenuItem.setEnabled(browser.isBackEnabled());
                forwardMenuItem.setEnabled(browser.isForwardEnabled());
                stopMenuItem.setEnabled(Boolean.TRUE.equals(browser.getData("Browser.loading")));
            }
        });
        browser.setMenu(menu);
    }

    public void setDefaultPopupMenuRegistered(boolean isDefaultPopupMenuRegistered) {
        this.runAsync(new CMN_setDefaultPopupMenuRegistered(), isDefaultPopupMenuRegistered);
    }

    public String getStatusText() {
        return this.status == null ? "" : this.status;
    }

    public String getPageTitle() {
        return this.title == null ? "" : this.title;
    }

    public int getLoadingProgress() {
        return this.loadingProgress;
    }

    public void addWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.add(WebBrowserListener.class, listener);
    }

    public void removeWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.remove(WebBrowserListener.class, listener);
    }

    @Override
    protected Component createEmbeddableComponent(Map<Object, Object> optionMap) {
        return super.createEmbeddableComponent(optionMap);
    }

    @Override
    protected void disposeNativePeer() {
        super.disposeNativePeer();
    }

    static /* synthetic */ ObjectRegistry access$3() {
        return NativeComponent.getNativeComponentRegistry();
    }

    static /* synthetic */ ObjectRegistry access$9() {
        return NativeComponent.getControlRegistry();
    }

    private static class CMJ_closeWindow
    extends ControlCommandMessage {
        private CMJ_closeWindow() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).windowClosing(e);
                }
                i -= 2;
            }
            JWebBrowserWindow browserWindow = webBrowser.getWebBrowserWindow();
            if (browserWindow != null) {
                browserWindow.dispose();
            }
            return null;
        }
    }

    private static class CMJ_commandReceived
    extends ControlCommandMessage {
        private CMJ_commandReceived() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            String command = (String)args[0];
            String[] arguments = (String[])args[1];
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).commandReceived(e, command, arguments);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_createWindow
    extends ControlCommandMessage {
        private CMJ_createWindow() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            JWebBrowser jWebBrowser2 = nativeWebBrowser.isXULRunnerRuntime() ? new JWebBrowser(JWebBrowser.useXULRunnerRuntime()) : new JWebBrowser(new NSOption[0]);
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserWindowWillOpenEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0 && jWebBrowser2 != null) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserWindowWillOpenEvent(webBrowser, jWebBrowser2);
                    }
                    ((WebBrowserListener)listeners[i + 1]).windowWillOpen(e);
                    jWebBrowser2 = e.isConsumed() ? null : e.getNewWebBrowser();
                }
                i -= 2;
            }
            if (jWebBrowser2 == null) {
                return null;
            }
            if (!jWebBrowser2.isNativePeerInitialized()) {
                Window windowAncestor = SwingUtilities.getWindowAncestor(jWebBrowser2);
                if (windowAncestor == null) {
                    JWebBrowserWindow webBrowserWindow = new JWebBrowserWindow(jWebBrowser2);
                    windowAncestor = webBrowserWindow;
                }
                jWebBrowser2.getNativeComponent().initializeNativePeer();
            }
            return ((NativeWebBrowser)jWebBrowser2.getNativeComponent()).getComponentID();
        }
    }

    private static class CMJ_locationChangeCanceled
    extends ControlCommandMessage {
        private CMJ_locationChangeCanceled() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            WebBrowserNavigationEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i + 1]).locationChangeCanceled(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_locationChanged
    extends ControlCommandMessage {
        private CMJ_locationChanged() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            WebBrowserNavigationEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i + 1]).locationChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_locationChanging
    extends ControlCommandMessage {
        private CMJ_locationChanging() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return false;
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            String location = (String)args[0];
            boolean isTopFrame = (Boolean)args[1];
            boolean isNavigating = true;
            WebBrowserNavigationEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserNavigationEvent(webBrowser, location, isTopFrame);
                    }
                    ((WebBrowserListener)listeners[i + 1]).locationChanging(e);
                    isNavigating &= !e.isConsumed();
                }
                i -= 2;
            }
            return isNavigating;
        }
    }

    private static class CMJ_showWindow
    extends ControlCommandMessage {
        private CMJ_showWindow() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            int componentID = (Integer)args[0];
            final JWebBrowser newWebBrowser = (JWebBrowser)((NativeWebBrowser)NativeWebBrowser.access$3().get(componentID)).webBrowser.get();
            newWebBrowser.setMenuBarVisible((Boolean)args[1]);
            newWebBrowser.setButtonBarVisible((Boolean)args[2]);
            newWebBrowser.setLocationBarVisible((Boolean)args[3]);
            newWebBrowser.setStatusBarVisible((Boolean)args[4]);
            Point location = (Point)args[5];
            Dimension size = (Dimension)args[6];
            JWebBrowserWindow browserWindow = newWebBrowser.getWebBrowserWindow();
            if (browserWindow != null) {
                if (size != null) {
                    browserWindow.validate();
                    Dimension windowSize = browserWindow.getSize();
                    Dimension webBrowserSize = browserWindow.getWebBrowser().getNativeWebBrowserContainerPane().getSize();
                    windowSize.width -= webBrowserSize.width;
                    windowSize.height -= webBrowserSize.height;
                    windowSize.width += size.width;
                    windowSize.height += size.height;
                    browserWindow.setSize(windowSize);
                }
                if (location != null) {
                    browserWindow.setLocation(location);
                }
            }
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserWindowOpeningEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0 && newWebBrowser != null) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserWindowOpeningEvent(webBrowser, newWebBrowser, location, size);
                    }
                    ((WebBrowserListener)listeners[i + 1]).windowOpening(e);
                }
                i -= 2;
            }
            new Thread(){

                public void run() {
                    try {
                        1.sleep(600L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JWebBrowserWindow browserWindow = newWebBrowser.getWebBrowserWindow();
                            if (browserWindow != null && !newWebBrowser.getNativeComponent().isNativePeerDisposed()) {
                                browserWindow.setVisible(true);
                            }
                        }
                    });
                }
            }.start();
            return null;
        }
    }

    private static class CMJ_updateLoadingProgress
    extends ControlCommandMessage {
        private CMJ_updateLoadingProgress() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.loadingProgress = (Integer)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).loadingProgressChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_updateStatus
    extends ControlCommandMessage {
        private CMJ_updateStatus() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.status = (String)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).statusChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMJ_updateTitle
    extends ControlCommandMessage {
        private CMJ_updateTitle() {
        }

        public Object run(Object[] args) {
            JWebBrowser webBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser = webBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (webBrowser == null) {
                return null;
            }
            nativeWebBrowser.title = (String)args[0];
            Object[] listeners = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent e = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == WebBrowserListener.class) {
                    if (e == null) {
                        e = new WebBrowserEvent(webBrowser);
                    }
                    ((WebBrowserListener)listeners[i + 1]).titleChanged(e);
                }
                i -= 2;
            }
            return null;
        }
    }

    private static class CMN_clearSessionCookies
    extends CommandMessage {
        private CMN_clearSessionCookies() {
        }

        public Object run(Object[] args) {
            Browser.clearSessions();
            return null;
        }
    }

    private static class CMN_executeJavascript
    extends ControlCommandMessage {
        private CMN_executeJavascript() {
        }

        public Object run(Object[] args) {
            String script = (String)args[0];
            Browser browser = (Browser)this.getControl();
            return browser.execute(NativeWebBrowser.fixJavascript(browser, script));
        }
    }

    private static class CMN_executeJavascriptWithResult
    extends ControlCommandMessage {
        private CMN_executeJavascriptWithResult() {
        }

        public Object run(Object[] args) {
            String script = (String)args[0];
            Browser browser = (Browser)this.getControl();
            return browser.evaluate(NativeWebBrowser.fixJavascript(browser, script));
        }
    }

    private static class CMN_getCookie
    extends CommandMessage {
        private CMN_getCookie() {
        }

        public Object run(Object[] args) {
            return Browser.getCookie((String)((String)args[1]), (String)((String)args[0]));
        }
    }

    private static class CMN_getHTMLContent
    extends ControlCommandMessage {
        private CMN_getHTMLContent() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getText();
        }
    }

    private static class CMN_getResourceLocation
    extends ControlCommandMessage {
        private CMN_getResourceLocation() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getUrl();
        }
    }

    private static class CMN_isBackNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isBackNavigationEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).isBackEnabled();
        }
    }

    private static class CMN_isForwardNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isForwardNavigationEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).isForwardEnabled();
        }
    }

    private static class CMN_isJavascriptEnabled
    extends ControlCommandMessage {
        private CMN_isJavascriptEnabled() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).getJavascriptEnabled();
        }
    }

    private static class CMN_navigate
    extends ControlCommandMessage {
        private CMN_navigate() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).setUrl((String)args[0]);
        }
    }

    private static class CMN_navigateBack
    extends ControlCommandMessage {
        private CMN_navigateBack() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).back();
        }
    }

    private static class CMN_navigateForward
    extends ControlCommandMessage {
        private CMN_navigateForward() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).forward();
        }
    }

    private static class CMN_reloadPage
    extends ControlCommandMessage {
        private CMN_reloadPage() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).refresh();
            return null;
        }
    }

    private static class CMN_setCookie
    extends CommandMessage {
        private CMN_setCookie() {
        }

        public Object run(Object[] args) {
            Browser.setCookie((String)((String)args[1]), (String)((String)args[0]));
            return null;
        }
    }

    private static class CMN_setDefaultPopupMenuRegistered
    extends ControlCommandMessage {
        private CMN_setDefaultPopupMenuRegistered() {
        }

        public Object run(Object[] args) {
            Browser browser = (Browser)this.getControl();
            boolean isDefaultPopupMenuRegistered = (Boolean)args[0];
            if (isDefaultPopupMenuRegistered) {
                NativeWebBrowser.registerDefaultPopupMenu(browser);
            } else {
                Menu oldMenu = browser.getMenu();
                if (oldMenu != null) {
                    oldMenu.dispose();
                }
                final Menu menu = new Menu((Decorations)browser.getShell(), 8);
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuShown(MenuEvent e) {
                        menu.setVisible(false);
                    }
                });
                browser.setMenu(menu);
            }
            return null;
        }
    }

    private static class CMN_setHTMLContent
    extends ControlCommandMessage {
        private CMN_setHTMLContent() {
        }

        public Object run(Object[] args) {
            return ((Browser)this.getControl()).setText((String)args[0]);
        }
    }

    private static class CMN_setJavascriptEnabled
    extends ControlCommandMessage {
        private CMN_setJavascriptEnabled() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).setJavascriptEnabled(((Boolean)args[0]).booleanValue());
            return null;
        }
    }

    private static class CMN_stopLoading
    extends ControlCommandMessage {
        private CMN_stopLoading() {
        }

        public Object run(Object[] args) {
            ((Browser)this.getControl()).stop();
            return null;
        }
    }
}

