/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.mozilla.interfaces.nsIComponentRegistrar;
import org.mozilla.interfaces.nsIWebBrowser;

public class MozillaXPCOM {
    private static Map<Integer, Object> idToNativeInterfaceMap = new HashMap<Integer, Object>();
    private static Map<Integer, WeakReference<NativeSwingProxy>> idToProxyInterfaceReferenceMap = new HashMap<Integer, WeakReference<NativeSwingProxy>>();
    private static Map<InterfaceInfo, Integer> interfaceInfoToIDMap = new HashMap<InterfaceInfo, Integer>();
    private static int nextNativeSideID = 1;
    private static int nextSwingSideID = -1;

    private MozillaXPCOM() {
    }

    public static nsIWebBrowser getWebBrowser(JWebBrowser webBrowser) {
        return (nsIWebBrowser)MozillaXPCOM.unpack(webBrowser.getNativeComponent().runSync(new CMN_getWebBrowser(), new Object[0]));
    }

    private static Object pack(Object o, boolean isNativeSide) {
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            Object[] array = (Object[])o;
            Object[] newArray = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                newArray[i] = MozillaXPCOM.pack(array[i], isNativeSide);
                ++i;
            }
            return new ArrayInfo(array.getClass(), newArray);
        }
        Package pckage = o.getClass().getPackage();
        if (pckage != null && pckage.getName().equals("java.lang")) {
            return o;
        }
        InterfaceInfo interfaceInfo = new InterfaceInfo(o);
        Integer id = interfaceInfoToIDMap.get(interfaceInfo);
        if (id == null) {
            ArrayList interfaceList = new ArrayList();
            ClassLoader cl = MozillaXPCOM.class.getClassLoader();
            Class<?>[] classArray = o.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> intrface = classArray[n2];
                Class<?> interfaceClass = null;
                try {
                    interfaceClass = Class.forName(intrface.getName(), false, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (interfaceClass == intrface) {
                    interfaceList.add(intrface);
                }
                ++n2;
            }
            interfaceList.add(NativeSwingProxy.class);
            id = isNativeSide ? Integer.valueOf(nextNativeSideID++) : Integer.valueOf(nextSwingSideID--);
            idToNativeInterfaceMap.put(id, o);
            interfaceInfoToIDMap.put(interfaceInfo, id);
            return new InterfaceDefinition(id, interfaceList.toArray(new Class[0]), true, !isNativeSide);
        }
        return new InterfaceDefinition(id, null, !(o instanceof NativeSwingProxy), !isNativeSide);
    }

    private static Object unpack(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ArrayInfo) {
            ArrayInfo arrayInfo = (ArrayInfo)o;
            Class<?> arrayClass = arrayInfo.getArrayClass();
            Object[] items = arrayInfo.getItems();
            Object[] array = (Object[])Array.newInstance(arrayClass.getComponentType(), items.length);
            int i = 0;
            while (i < items.length) {
                array[i] = MozillaXPCOM.unpack(items[i]);
                ++i;
            }
            return array;
        }
        if (o instanceof InterfaceDefinition) {
            InterfaceDefinition interfaceDefinition = (InterfaceDefinition)o;
            final Integer id = interfaceDefinition.getID();
            if (interfaceDefinition.isProxy()) {
                NativeSwingProxy proxyInterface;
                WeakReference<NativeSwingProxy> proxyInterfaceReference = idToProxyInterfaceReferenceMap.get(id);
                NativeSwingProxy nativeSwingProxy = proxyInterface = proxyInterfaceReference == null ? null : (NativeSwingProxy)proxyInterfaceReference.get();
                if (proxyInterface == null) {
                    Class<?>[] interfaces = interfaceDefinition.getInterfaces();
                    final boolean isNativeSide = interfaceDefinition.isNativeSide();
                    proxyInterface = (NativeSwingProxy)Proxy.newProxyInstance(MozillaXPCOM.class.getClassLoader(), interfaces, new InvocationHandler(){

                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            String methodName = method.getName();
                            Class<?>[] parameterTypes = method.getParameterTypes();
                            if ("finalize".equals(methodName) && parameterTypes.length == 0) {
                                idToProxyInterfaceReferenceMap.remove(id);
                                interfaceInfoToIDMap.remove(new InterfaceInfo(this));
                                new CM_disposeResources().syncExec(!isNativeSide, id);
                                return null;
                            }
                            return MozillaXPCOM.unpack(new CM_runMethod().syncExec(!isNativeSide, id, methodName, parameterTypes, MozillaXPCOM.pack(args, isNativeSide), !isNativeSide));
                        }
                    });
                    idToProxyInterfaceReferenceMap.put(id, new WeakReference<NativeSwingProxy>(proxyInterface));
                    interfaceInfoToIDMap.put(new InterfaceInfo(proxyInterface), id);
                }
                return proxyInterface;
            }
            return idToNativeInterfaceMap.get(id);
        }
        return o;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayInfo
    implements Serializable {
        private Class<?> arrayClass;
        private Object[] content;

        public ArrayInfo(Class<?> arrayClass, Object[] content) {
            ClassLoader cl = MozillaXPCOM.class.getClassLoader();
            Class<?> arrayClass_ = null;
            while (true) {
                try {
                    arrayClass_ = Class.forName(arrayClass.getName(), false, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (arrayClass_ == arrayClass) break;
                arrayClass_ = arrayClass_.getSuperclass();
            }
            this.arrayClass = arrayClass;
            this.content = content;
        }

        public Class<?> getArrayClass() {
            return this.arrayClass;
        }

        public Object[] getItems() {
            return this.content;
        }

        public String toString() {
            return Arrays.deepToString(this.content);
        }
    }

    private static class CMN_getWebBrowser
    extends ControlCommandMessage {
        private CMN_getWebBrowser() {
        }

        public Object run(Object[] args) {
            return MozillaXPCOM.pack(((Browser)this.getControl()).getWebBrowser(), true);
        }
    }

    private static class CM_disposeResources
    extends CommandMessage {
        private CM_disposeResources() {
        }

        public Object run(Object[] args) {
            Object nativeInterface = idToNativeInterfaceMap.remove(args[0]);
            interfaceInfoToIDMap.remove(new InterfaceInfo(nativeInterface));
            return null;
        }
    }

    private static class CM_runMethod
    extends CommandMessage {
        private CM_runMethod() {
        }

        public Object run(Object[] args) {
            Integer interfaceID = (Integer)args[0];
            String methodName = (String)args[1];
            Class[] parameterTypes = (Class[])args[2];
            Object[] parameterValues = (Object[])MozillaXPCOM.unpack(args[3]);
            boolean isNativeSide = (Boolean)args[4];
            Object nativeInterface = idToNativeInterfaceMap.get(interfaceID);
            try {
                Method method = nativeInterface.getClass().getMethod(methodName, parameterTypes);
                method.setAccessible(true);
                Object result = method.invoke(nativeInterface, parameterValues);
                return MozillaXPCOM.pack(result, isNativeSide);
            }
            catch (Exception e) {
                throw new IllegalStateException("The method " + methodName + " could not be invoked on interface " + nativeInterface + "!", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InterfaceDefinition
    implements Serializable {
        private int id;
        private Class<?>[] interfaces;
        private boolean isProxy;
        private boolean isNativeSide;

        private InterfaceDefinition(int id, Class<?>[] interfaces, boolean isProxy, boolean isNativeSide) {
            this.id = id;
            this.interfaces = interfaces;
            this.isProxy = isProxy;
            this.isNativeSide = isNativeSide;
        }

        public int getID() {
            return this.id;
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces;
        }

        public boolean isProxy() {
            return this.isProxy;
        }

        public boolean isNativeSide() {
            return this.isNativeSide;
        }
    }

    private static class InterfaceInfo {
        private WeakReference<Object> interfaceReference;
        private int id;

        public InterfaceInfo(Object intrface) {
            this.interfaceReference = new WeakReference<Object>(intrface);
            this.id = System.identityHashCode(intrface);
        }

        public int hashCode() {
            return this.id;
        }

        public Object getInterface() {
            return this.interfaceReference.get();
        }

        public boolean equals(Object o) {
            return ((InterfaceInfo)o).id == this.id;
        }
    }

    public static class Mozilla {
        public static nsIComponentRegistrar getComponentRegistrar() {
            return (nsIComponentRegistrar)MozillaXPCOM.unpack(new CMN_getComponentRegistrar().syncSend(true));
        }

        private static class CMN_getComponentRegistrar
        extends CommandMessage {
            private CMN_getComponentRegistrar() {
            }

            public Object run(Object[] args) {
                return MozillaXPCOM.pack(org.mozilla.xpcom.Mozilla.getInstance().getComponentRegistrar(), true);
            }
        }
    }

    private static interface NativeSwingProxy {
        public void finalize();
    }
}

