/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class JWebBrowserWindow
extends JFrame {
    private final ResourceBundle RESOURCES = ResourceBundle.getBundle(String.valueOf(JWebBrowserWindow.class.getPackage().getName().replace('.', '/')) + "/resource/WebBrowser");
    private JWebBrowser webBrowser;

    public JWebBrowserWindow(NSOption ... options) {
        this(new JWebBrowser(options));
    }

    public JWebBrowserWindow(JWebBrowser webBrowser) {
        this.setDefaultCloseOperation(2);
        this.webBrowser = webBrowser;
        JMenu fileMenu = webBrowser.getFileMenu();
        fileMenu.addSeparator();
        JMenuItem fileCloseMenuItem = new JMenuItem(this.RESOURCES.getString("FileCloseMenu"));
        fileCloseMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JWebBrowserWindow.this.dispose();
            }
        });
        fileMenu.add(fileCloseMenuItem);
        webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void titleChanged(WebBrowserEvent e) {
                MessageFormat mf = new MessageFormat(JWebBrowserWindow.this.RESOURCES.getString("BrowserTitle"));
                JWebBrowserWindow.this.setTitle(mf.format(new Object[]{e.getWebBrowser().getPageTitle()}));
            }
        });
        String value = this.RESOURCES.getString("BrowserIcon");
        if (value.length() > 0) {
            this.setIconImage(new ImageIcon(JWebBrowserWindow.class.getResource(value)).getImage());
        }
        this.getContentPane().add((Component)webBrowser, "Center");
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        size.width = size.width * 80 / 100;
        size.height = size.height * 80 / 100;
        this.setSize(size);
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                JWebBrowserWindow.this.webBrowser.requestFocus();
            }
        });
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void setBarsVisible(boolean areBarsVisible) {
        this.webBrowser.setBarsVisible(areBarsVisible);
    }

    public void setStatusBarVisible(boolean isStatusBarVisible) {
        this.webBrowser.setStatusBarVisible(isStatusBarVisible);
    }

    public boolean isStatusBarVisisble() {
        return this.webBrowser.isStatusBarVisible();
    }

    public void setMenuBarVisible(boolean isMenuBarVisible) {
        this.webBrowser.setMenuBarVisible(isMenuBarVisible);
    }

    public boolean isMenuBarVisisble() {
        return this.webBrowser.isMenuBarVisible();
    }

    public void setButtonBarVisible(boolean isButtonBarVisible) {
        this.webBrowser.setButtonBarVisible(isButtonBarVisible);
    }

    public boolean isButtonBarVisisble() {
        return this.webBrowser.isButtonBarVisible();
    }

    public void setLocationBarVisible(boolean isLocationBarVisible) {
        this.webBrowser.setLocationBarVisible(isLocationBarVisible);
    }

    public boolean isLocationBarVisisble() {
        return this.webBrowser.isLocationBarVisible();
    }
}

