/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.EventDispatchUtils;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.components.HTMLEditorListener;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditorFCKeditor;
import chrriis.dj.nativeswing.swtimpl.components.JHTMLEditorTinyMCE;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.util.EventListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JHTMLEditor
extends NSPanelComponent {
    private static final String HTML_EDITOR_COMPONENT_OPTION_KEY = "HTML Editor";
    static final String SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY = "HTML Editor Custom Configuration Script";
    private JWebBrowser webBrowser;
    private int instanceID;
    private JHTMLEditorImplementation implementation;
    private static /* synthetic */ int[] $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation;

    public static NSOption setEditorImplementation(final HTMLEditorImplementation comp) {
        return new NSOption(HTML_EDITOR_COMPONENT_OPTION_KEY){

            public Object getOptionValue() {
                return comp;
            }
        };
    }

    public static NSOption setCustomJavascriptConfiguration(final String javascript) {
        return new NSOption(SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY){

            public Object getOptionValue() {
                return javascript;
            }
        };
    }

    JHTMLEditorImplementation getImplementation() {
        return this.implementation;
    }

    /*
     * Unable to fully structure code
     */
    public JHTMLEditor(NSOption ... options) {
        super();
        optionMap = NSOption.createOptionMap((NSOption[])options);
        this.webBrowser = new JWebBrowser(options);
        this.initialize(this.webBrowser.getNativeComponent());
        editorImplementation = (HTMLEditorImplementation)optionMap.get("HTML Editor");
        editorImplementation_ = editorImplementation == null ? HTMLEditorImplementation.FCKEditor : editorImplementation;
        switch (JHTMLEditor.$SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation()[editorImplementation_.ordinal()]) {
            case 1: {
                try {
                    this.implementation = new JHTMLEditorFCKeditor(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl15
                    throw e;
                }
            }
lbl15:
            // 2 sources

            case 2: {
                try {
                    this.implementation = new JHTMLEditorTinyMCE(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl22
                    throw e;
                }
            }
lbl22:
            // 2 sources

            default: {
                throw new IllegalStateException("A suitable HTML editor (FCKeditor, TinyMCE) distribution could not be found on the classpath!");
            }
        }
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void commandReceived(WebBrowserEvent e, String command, String[] args) {
                if ("JH_setLoaded".equals(command)) {
                    Object[] listeners = JHTMLEditor.this.listenerList.getListenerList();
                    int i = listeners.length - 2;
                    while (i >= 0) {
                        if (listeners[i] == InitializationListener.class) {
                            ((InitializationListener)listeners[i + 1]).objectInitialized();
                        }
                        i -= 2;
                    }
                }
            }
        });
        this.webBrowser.setBarsVisible(false);
        this.add((Component)this.webBrowser, "Center");
        this.instanceID = ObjectRegistry.getInstance().add((Object)this);
        resultArray = new boolean[1];
        initializationListener = new InitializationListener(){

            public void objectInitialized() {
                JHTMLEditor.this.removeInitializationListener(this);
                resultArray[0] = true;
            }
        };
        this.addInitializationListener(initializationListener);
        this.webBrowser.navigate(WebServer.getDefaultWebServer().getDynamicContentURL(JHTMLEditor.class.getName(), String.valueOf(this.instanceID), "index.html"));
        this.webBrowser.getNativeComponent().runSync(new LocalMessage(){

            public Object run(Object[] args) {
                InitializationListener initializationListener = (InitializationListener)args[0];
                final boolean[] resultArray = (boolean[])args[1];
                EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                    public boolean getValue() {
                        return resultArray[0];
                    }
                }, 4000);
                JHTMLEditor.this.removeInitializationListener(initializationListener);
                return null;
            }
        }, new Object[]{initializationListener, resultArray});
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    protected static WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
        String resourcePath = httpRequest.getResourcePath();
        int index = resourcePath.indexOf(47);
        int instanceID = Integer.parseInt(resourcePath.substring(0, index));
        JHTMLEditor htmlEditor = (JHTMLEditor)ObjectRegistry.getInstance().get(instanceID);
        if (htmlEditor == null) {
            return null;
        }
        String resourcePath_ = resourcePath.substring(index + 1);
        if (resourcePath_.startsWith("/")) {
            resourcePath_ = resourcePath_.substring(1);
        }
        JHTMLEditorImplementation implementation = htmlEditor.getImplementation();
        return implementation.getWebServerContent(httpRequest, resourcePath_, instanceID);
    }

    public String getHTMLContent() {
        return JHTMLEditor.convertLinksToLocal(this.implementation.getHTMLContent());
    }

    public void setHTMLContent(String html) {
        html = JHTMLEditor.convertLinksFromLocal(html.replaceAll("[\r\n]", " "));
        this.implementation.setHTMLContent(html);
    }

    static String convertLinksToLocal(String html) {
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(" + WebServer.getDefaultWebServer().getURLPrefix() + "/resource/)([^/]+)/([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            String codeBase = html.substring(m.start(2), m.end(2));
            String resource = html.substring(m.start(3), m.end(3));
            try {
                resource = new File(Utils.decodeURL((String)Utils.decodeURL((String)codeBase)), resource).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(3));
        }
        return html;
    }

    static String convertLinksFromLocal(String html) {
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(file:/{1,3})([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            String resource = html.substring(m.start(2), m.end(2));
            File resourceFile = new File(resource);
            resource = WebServer.getDefaultWebServer().getResourcePathURL(Utils.encodeURL((String)resourceFile.getParent()), resourceFile.getName());
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(2));
        }
        return html;
    }

    public void addHTMLEditorListener(HTMLEditorListener listener) {
        this.listenerList.add(HTMLEditorListener.class, listener);
    }

    public void removeHTMLEditorListener(HTMLEditorListener listener) {
        this.listenerList.remove(HTMLEditorListener.class, listener);
    }

    public HTMLEditorListener[] getHTMLEditorListeners() {
        return (HTMLEditorListener[])this.listenerList.getListeners(HTMLEditorListener.class);
    }

    private void addInitializationListener(InitializationListener listener) {
        this.listenerList.add(InitializationListener.class, listener);
    }

    private void removeInitializationListener(InitializationListener listener) {
        this.listenerList.remove(InitializationListener.class, listener);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation() {
        if ($SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation != null) {
            return $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation;
        }
        int[] nArray = new int[HTMLEditorImplementation.values().length];
        try {
            nArray[HTMLEditorImplementation.FCKEditor.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTMLEditorImplementation.TinyMCE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$chrriis$dj$nativeswing$swtimpl$components$JHTMLEditor$HTMLEditorImplementation = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTMLEditorImplementation {
        FCKEditor,
        TinyMCE;

    }

    private static interface InitializationListener
    extends EventListener {
        public void objectInitialized();
    }

    static interface JHTMLEditorImplementation {
        public WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest var1, String var2, int var3);

        public String getHTMLContent();

        public void setHTMLContent(String var1);
    }
}

