/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.EventDispatchUtils;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import java.io.File;
import java.io.InputStream;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public abstract class WebBrowserObject {
    private JWebBrowser webBrowser;
    private int instanceID;
    private String resourcePath;
    private static final String LS = Utils.LINE_SEPARATOR;
    private EventListenerList listenerList = new EventListenerList();

    public WebBrowserObject(JWebBrowser webBrowser) {
        this.webBrowser = webBrowser;
        webBrowser.setDefaultPopupMenuRegistered(false);
        webBrowser.setBarsVisible(false);
        webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void commandReceived(WebBrowserEvent e, String command, String[] args) {
                if ("WB_setLoaded".equals(command)) {
                    Object[] listeners = WebBrowserObject.this.listenerList.getListenerList();
                    int i = listeners.length - 2;
                    while (i >= 0) {
                        if (listeners[i] == InitializationListener.class) {
                            ((InitializationListener)listeners[i + 1]).objectInitialized();
                        }
                        i -= 2;
                    }
                }
            }
        });
    }

    public String getLoadedResource() {
        return "".equals(this.resourcePath) ? null : this.resourcePath;
    }

    public boolean hasContent() {
        return this.resourcePath != null;
    }

    protected void finalize() throws Throwable {
        ObjectRegistry.getInstance().remove(this.instanceID);
        super.finalize();
    }

    public void load(String resourcePath) {
        this.resourcePath = resourcePath;
        ObjectRegistry.getInstance().remove(this.instanceID);
        if (resourcePath == null) {
            if (!this.webBrowser.isNativePeerDisposed()) {
                this.webBrowser.setHTMLContent("");
            }
            return;
        }
        this.instanceID = ObjectRegistry.getInstance().add((Object)this);
        resourcePath = WebServer.getDefaultWebServer().getDynamicContentURL(WebBrowserObject.class.getName(), "html/" + this.instanceID);
        final boolean[] resultArray = new boolean[1];
        InitializationListener initializationListener = new InitializationListener(){

            public void objectInitialized() {
                WebBrowserObject.this.removeInitializationListener(this);
                resultArray[0] = true;
            }
        };
        this.addInitializationListener(initializationListener);
        this.webBrowser.navigate(resourcePath);
        this.webBrowser.getNativeComponent().runSync(new LocalMessage(){

            public Object run(Object[] args) {
                InitializationListener initializationListener = (InitializationListener)args[0];
                final boolean[] resultArray = (boolean[])args[1];
                EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                    public boolean getValue() {
                        return resultArray[0];
                    }
                }, 4000);
                WebBrowserObject.this.removeInitializationListener(initializationListener);
                return null;
            }
        }, initializationListener, resultArray);
    }

    public String getLocalFileURL(File localFile) {
        try {
            return localFile.toURI().toURL().toExternalForm();
        }
        catch (Exception exception) {
            return WebServer.getDefaultWebServer().getResourcePathURL(localFile.getParent(), localFile.getName());
        }
    }

    public static String getEmbeddedObjectJavascriptName() {
        return "myEmbeddedObject";
    }

    protected static WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
        String resourcePath = httpRequest.getResourcePath();
        int index = resourcePath.indexOf(47);
        if (index == -1) {
            return null;
        }
        String type = resourcePath.substring(0, index);
        resourcePath = resourcePath.substring(index + 1);
        if ("html".equals(type)) {
            final int instanceID = Integer.parseInt(resourcePath);
            WebBrowserObject component = (WebBrowserObject)ObjectRegistry.getInstance().get(instanceID);
            if (component == null) {
                return new WebServer.WebServerContent(){

                    public InputStream getInputStream() {
                        return 4.getInputStream((String)"<html><body></body></html>");
                    }
                };
            }
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String javascriptDefinitions = WebBrowserObject.this.getJavascriptDefinitions();
                    javascriptDefinitions = javascriptDefinitions == null ? "" : String.valueOf(javascriptDefinitions) + LS;
                    String content = "<html>" + LS + "  <head>" + LS + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>" + LS + "    <script language=\"JavaScript\" type=\"text/javascript\">" + LS + "      <!--" + LS + "      function sendCommand(command) {" + LS + "        var s = '" + "command://" + "' + encodeURIComponent(command);" + LS + "        for(var i=1; i<arguments.length; s+='&'+encodeURIComponent(arguments[i++]));" + LS + "        window.location = s;" + LS + "      }" + LS + "      function postCommand(command) {" + LS + "        var elements = new Array();" + LS + "        for(var i=1; i<arguments.length; i++) {" + LS + "          var element = document.createElement('input');" + LS + "          element.type='text';" + LS + "          element.name='j_arg' + (i-1);" + LS + "          element.value=arguments[i];" + LS + "          document.createElement('j_arg' + (i-1));" + LS + "          elements[i-1] = element;" + LS + "          document.j_form.appendChild(element);" + LS + "        }" + LS + "        document.j_form.j_command.value = command;" + LS + "        document.j_form.submit();" + LS + "        for(var i=0; i<elements.length; i++) {" + LS + "          document.j_form.removeChild(elements[i]);" + LS + "        }" + LS + "      }" + LS + "      function getEmbeddedObject() {" + LS + "        var movieName = \"" + WebBrowserObject.getEmbeddedObjectJavascriptName() + "\";" + LS + "        if(window.document[movieName]) {" + LS + "          return window.document[movieName];" + LS + "        }" + LS + "        if(navigator.appName.indexOf(\"Microsoft Internet\") == -1) {" + LS + "          if(document.embeds && document.embeds[movieName]) {" + LS + "            return document.embeds[movieName];" + LS + "          }" + LS + "        } else {" + LS + "          return document.getElementById(movieName);" + LS + "        }" + LS + "      }" + LS + javascriptDefinitions + "      //-->" + LS + "    </script>" + LS + "    <style type=\"text/css\">" + LS + "      html, object, embed, div, body, table { width: 100%; height: 100%; min-height: 100%; margin: 0; padding: 0; overflow: hidden; background-color: #FFFFFF; text-align: center; }" + LS + "      object, embed, div { position: absolute; left:0; top:0;}" + LS + "      td { vertical-align: middle; }" + LS + "    </style>" + LS + "  </head>" + LS + "  <body height=\"*\">" + LS + "    <iframe style=\"display:none;\" name=\"j_iframe\"></iframe>" + LS + "    <form style=\"display:none;\" name=\"j_form\" action=\"" + WebServer.getDefaultWebServer().getDynamicContentURL(WebBrowserObject.class.getName(), "postCommand/" + instanceID) + "\" method=\"POST\" target=\"j_iframe\">" + LS + "      <input name=\"j_command\" type=\"text\"></input>" + LS + "    </form>" + LS + "    <script src=\"" + WebServer.getDefaultWebServer().getDynamicContentURL(WebBrowserObject.class.getName(), "js/" + instanceID) + "\"></script>" + LS + "  </body>" + LS + "</html>" + LS;
                    return 5.getInputStream((String)content);
                }
            };
        }
        if ("js".equals(type)) {
            int instanceID = Integer.parseInt(resourcePath);
            WebBrowserObject webBrowserObject = (WebBrowserObject)ObjectRegistry.getInstance().get(instanceID);
            if (webBrowserObject == null) {
                return null;
            }
            String url = webBrowserObject.resourcePath;
            File file = Utils.getLocalFile((String)url);
            if (file != null) {
                url = webBrowserObject.getLocalFileURL(file);
            }
            final String escapedURL = Utils.escapeXML((String)url);
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    return 6.getDefaultMimeType((String)".js");
                }

                public InputStream getInputStream() {
                    ObjectHTMLConfiguration objectHtmlConfiguration = WebBrowserObject.this.getObjectHtmlConfiguration();
                    StringBuffer objectParameters = new StringBuffer();
                    StringBuffer embedParameters = new StringBuffer();
                    Map<String, String> parameters = objectHtmlConfiguration.getHTMLParameters();
                    HashMap htmlParameters = parameters == null ? new HashMap() : new HashMap<String, String>(parameters);
                    String windowsParamName = objectHtmlConfiguration.getWindowsParamName();
                    String paramName = objectHtmlConfiguration.getParamName();
                    htmlParameters.remove("width");
                    htmlParameters.remove("height");
                    htmlParameters.remove("type");
                    htmlParameters.remove("name");
                    if (windowsParamName != null) {
                        htmlParameters.remove(windowsParamName);
                    }
                    if (paramName != null) {
                        htmlParameters.remove(paramName);
                    }
                    for (Map.Entry param : htmlParameters.entrySet()) {
                        String name = Utils.escapeXML((String)((String)param.getKey()));
                        String value = Utils.escapeXML((String)((String)param.getValue()));
                        embedParameters.append(' ').append(name).append("=\"").append(value).append("\"");
                        objectParameters.append("window.document.write('  <param name=\"").append(name).append("\" value=\"").append(value).append("\"/>');" + LS);
                    }
                    String version = objectHtmlConfiguration.getVersion();
                    String versionParameter = version != null ? " version=\"" + version + "\"" : "";
                    String embeddedObjectJavascriptName = WebBrowserObject.getEmbeddedObjectJavascriptName();
                    String content = "<!--" + LS + "window.document.write('<object classid=\"clsid:" + objectHtmlConfiguration.getWindowsClassID() + "\" id=\"" + embeddedObjectJavascriptName + "\" codebase=\"" + objectHtmlConfiguration.getWindowsInstallationURL() + "\" events=\"true\">');" + LS + (windowsParamName == null ? "" : "window.document.write('  <param name=\"" + windowsParamName + "\" value=\"' + decodeURIComponent('" + escapedURL + "') + '\"/>');" + LS) + objectParameters + "window.document.write('  <embed" + embedParameters + " name=\"" + embeddedObjectJavascriptName + "\"" + (paramName == null ? "" : " " + paramName + "=\"" + escapedURL + "\"") + " type=\"" + objectHtmlConfiguration.getMimeType() + "\" pluginspage=\"" + objectHtmlConfiguration.getInstallationURL() + "\"" + versionParameter + ">');" + LS + "window.document.write('  </embed>');" + LS + "window.document.write('</object>');" + LS + "window.document.write('<div id=\"messageDiv\" style=\"display:none;\"><table><tr><td>" + objectHtmlConfiguration.getHTMLLoadingMessage() + "</td></tr></table></div>');" + LS + "setTimeout('document.getElementById(\\'messageDiv\\').style.display = \\'inline\\'', 200);" + LS + "var embeddedObject = getEmbeddedObject();" + LS + "embeddedObject.style.width = '100%';" + LS + "embeddedObject.style.height = '100%';" + LS + "sendCommand('WB_setLoaded');" + LS + "//-->" + LS;
                    return 6.getInputStream((String)content);
                }
            };
        }
        if ("postCommand".equals(type)) {
            int instanceID = Integer.parseInt(resourcePath);
            WebBrowserObject webBrowserObject = (WebBrowserObject)ObjectRegistry.getInstance().get(instanceID);
            if (webBrowserObject == null) {
                return null;
            }
            WebServer.HTTPData postData = httpRequest.getHTTPPostDataArray()[0];
            Map headerMap = postData.getHeaderMap();
            int size = headerMap.size();
            final String command = (String)headerMap.get("j_command");
            final String[] arguments = new String[size - 1];
            int i = 0;
            while (i < arguments.length) {
                arguments[i] = (String)headerMap.get("j_arg" + i);
                System.err.println(arguments[i]);
                ++i;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WebBrowserListener[] webBrowserListeners = WebBrowserObject.this.webBrowser.getWebBrowserListeners();
                    WebBrowserEvent e = null;
                    int i = webBrowserListeners.length - 1;
                    while (i >= 0) {
                        if (e == null) {
                            e = new WebBrowserEvent(WebBrowserObject.this.webBrowser);
                        }
                        webBrowserListeners[i].commandReceived(e, command, arguments);
                        --i;
                    }
                }
            });
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Command sent successfully." + LS + "  </body>" + LS + "</html>" + LS;
                    return 8.getInputStream((String)content);
                }
            };
        }
        return null;
    }

    protected abstract ObjectHTMLConfiguration getObjectHtmlConfiguration();

    protected String getJavascriptDefinitions() {
        return null;
    }

    private void addInitializationListener(InitializationListener listener) {
        this.listenerList.add(InitializationListener.class, listener);
    }

    private void removeInitializationListener(InitializationListener listener) {
        this.listenerList.remove(InitializationListener.class, listener);
    }

    public void setObjectProperty(String property, Object value) {
        this.webBrowser.executeJavascript("try {getEmbeddedObject()." + property + " = " + JWebBrowser.convertJavaObjectToJavascript(value) + ";} catch(exxxxx) {}");
    }

    public Object getObjectProperty(String property) {
        return this.webBrowser.executeJavascriptWithResult("return getEmbeddedObject()." + property);
    }

    public void invokeObjectFunction(String functionName, Object ... args) {
        this.webBrowser.executeJavascript("try {getEmbeddedObject()." + JWebBrowser.createJavascriptFunctionCall(functionName, args) + ";} catch(exxxxx) {}");
    }

    public Object invokeObjectFunctionWithResult(String functionName, Object ... args) {
        return this.webBrowser.executeJavascriptWithResult("return getEmbeddedObject()." + JWebBrowser.createJavascriptFunctionCall(functionName, args));
    }

    private static interface InitializationListener
    extends EventListener {
        public void objectInitialized();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectHTMLConfiguration {
        private String htmlLoadingMessage;
        private String windowsClassID;
        private String windowsInstallationURL;
        private String installationURL;
        private String version;
        private String windowsParamName;
        private String paramName;
        private Map<String, String> htmlParameters;
        private String mimeType;

        public void setHTMLLoadingMessage(String htmlLoadingMessage) {
            this.htmlLoadingMessage = htmlLoadingMessage;
        }

        public String getHTMLLoadingMessage() {
            return this.htmlLoadingMessage;
        }

        public void setWindowsClassID(String windowsClassID) {
            this.windowsClassID = windowsClassID;
        }

        public String getWindowsClassID() {
            return this.windowsClassID;
        }

        public String getWindowsInstallationURL() {
            return this.windowsInstallationURL;
        }

        public void setWindowsInstallationURL(String windowsInstallationURL) {
            this.windowsInstallationURL = windowsInstallationURL;
        }

        public String getInstallationURL() {
            return this.installationURL;
        }

        public void setInstallationURL(String installationURL) {
            this.installationURL = installationURL;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getWindowsParamName() {
            return this.windowsParamName;
        }

        public void setWindowsParamName(String windowsParamName) {
            this.windowsParamName = windowsParamName;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public Map<String, String> getHTMLParameters() {
            return this.htmlParameters;
        }

        public void setHTMLParameters(Map<String, String> htmlParameters) {
            this.htmlParameters = htmlParameters;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }
    }
}

