/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.MessagingInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Display;

abstract class OutProcessMessagingInterface
extends MessagingInterface {
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private Socket socket;
    private static final int OOS_RESET_THRESHOLD;
    private int oosByteCount;

    static {
        String maxByteCountProperty = System.getProperty("nativeswing.interface.streamresetthreshold");
        OOS_RESET_THRESHOLD = maxByteCountProperty != null ? Integer.parseInt(maxByteCountProperty) : 500000;
    }

    public OutProcessMessagingInterface(boolean isNativeSide, Socket socket, boolean exitOnEndOfStream) {
        super(isNativeSide);
        this.socket = socket;
        this.initialize(exitOnEndOfStream);
    }

    public void destroy() {
        this.setAlive(false);
        try {
            this.ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void openChannel() {
        try {
            this.oos = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()){

                public synchronized void write(int b) throws IOException {
                    super.write(b);
                    OutProcessMessagingInterface outProcessMessagingInterface = OutProcessMessagingInterface.this;
                    outProcessMessagingInterface.oosByteCount = outProcessMessagingInterface.oosByteCount + 1;
                }

                public synchronized void write(byte[] b, int off, int len) throws IOException {
                    super.write(b, off, len);
                    OutProcessMessagingInterface outProcessMessagingInterface = OutProcessMessagingInterface.this;
                    outProcessMessagingInterface.oosByteCount = outProcessMessagingInterface.oosByteCount + len;
                }
            });
            this.oos.flush();
            this.ois = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void closeChannel() {
        try {
            this.oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMessageToChannel(Message message) throws IOException {
        ObjectOutputStream objectOutputStream = this.oos;
        synchronized (objectOutputStream) {
            this.oos.writeUnshared(message);
            this.oos.flush();
            if (this.oosByteCount > OOS_RESET_THRESHOLD) {
                this.oos.reset();
                this.oosByteCount = 0;
            }
        }
    }

    protected Message readMessageFromChannel() throws IOException, ClassNotFoundException {
        Object o = this.ois.readUnshared();
        if (o instanceof Message) {
            Message message = (Message)o;
            if (IS_DEBUGGING_MESSAGES) {
                System.err.println("RECV: " + message.getID() + ", " + message);
            }
            return message;
        }
        System.err.println("Unknown message: " + o);
        return null;
    }

    static class SWTOutProcessMessagingInterface
    extends OutProcessMessagingInterface {
        private Display display;

        public SWTOutProcessMessagingInterface(Socket socket, boolean exitOnEndOfStream, Display display) {
            super(true, socket, exitOnEndOfStream);
            this.display = display;
        }

        protected void asyncUIExec(Runnable runnable) {
            this.display.asyncExec(runnable);
        }

        public boolean isUIThread() {
            return Thread.currentThread() == this.display.getThread();
        }
    }

    static class SwingOutProcessMessagingInterface
    extends OutProcessMessagingInterface {
        public SwingOutProcessMessagingInterface(Socket socket, boolean exitOnEndOfStream) {
            super(false, socket, exitOnEndOfStream);
        }

        protected void asyncUIExec(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }

        public boolean isUIThread() {
            return SwingUtilities.isEventDispatchThread();
        }
    }
}

