/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.OleParameterDescription;
import org.eclipse.swt.ole.win32.Variant;

public abstract class OleNativeComponent
extends NativeComponent {
    protected static void configureOleFrame(OleClientSite site, OleFrame frame) {
        frame.setData("NS_site", (Object)site);
    }

    protected static OleClientSite getSite(OleFrame frame) {
        OleClientSite oleClientSite = (OleClientSite)frame.getData("NS_site");
        if (oleClientSite == null) {
            throw new IllegalStateException("The OleNativeComponent is not properly initialized! You need to call configureOleFrame() after the site creation.");
        }
        return oleClientSite;
    }

    public void invokeOleFunction(String functionName, Object ... args) {
        this.invokeOleFunction(new String[]{functionName}, args);
    }

    public void invokeOleFunction(String[] functionPath, Object ... args) {
        this.runAsync(new CMN_invokeOleFunction(), false, functionPath, args);
    }

    public Object invokeOleFunctionWithResult(String functionName, Object ... args) {
        return this.invokeOleFunctionWithResult(new String[]{functionName}, args);
    }

    public Object invokeOleFunctionWithResult(String[] functionPath, Object ... args) {
        return this.runSync(new CMN_invokeOleFunction(), true, functionPath, args);
    }

    public void setOleProperty(String property, Object ... args) {
        this.setOleProperty(new String[]{property}, args);
    }

    public void setOleProperty(String[] propertyPath, Object ... args) {
        this.runAsync(new CMN_setOleProperty(), propertyPath, args);
    }

    public Object getOleProperty(String property, Object ... args) {
        return this.getOleProperty(new String[]{property}, args);
    }

    public Object getOleProperty(String[] propertyPath, Object ... args) {
        return this.runSync(new CMN_getOleProperty(), propertyPath, args);
    }

    protected static Variant createVariant(Object value) {
        if (value instanceof Boolean) {
            return new Variant(((Boolean)value).booleanValue());
        }
        if (value instanceof Short) {
            return new Variant(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new Variant(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new Variant(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new Variant(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new Variant(((Double)value).doubleValue());
        }
        if (value instanceof String || value == null) {
            return new Variant((String)value);
        }
        throw new IllegalArgumentException("The value could not be converted to a Variant: " + value);
    }

    protected static Object getVariantValue(Variant variant) {
        if (variant == null) {
            return null;
        }
        switch (variant.getType()) {
            case 11: {
                return variant.getBoolean();
            }
            case 2: {
                return variant.getShort();
            }
            case 3: {
                return variant.getInt();
            }
            case 20: {
                return variant.getLong();
            }
            case 4: {
                return Float.valueOf(variant.getFloat());
            }
            case 5: {
                return variant.getDouble();
            }
            case 8: {
                return variant.getString();
            }
        }
        throw new IllegalArgumentException("The value could not be converted from a Variant: " + variant);
    }

    private static void dispose(Variant variant) {
        if (variant == null) {
            return;
        }
        variant.dispose();
    }

    public void dumpOleInterfaceDefinitions() {
        this.runSync(new CMN_dumpOleInterfaceDefinitions(), new Object[0]);
    }

    private static class CMN_dumpOleInterfaceDefinitions
    extends ControlCommandMessage {
        private Map<Short, String> oleTypeToDescriptionMap;

        private CMN_dumpOleInterfaceDefinitions() {
        }

        private void dumpOleInterfaceDefinitions(StringBuilder sb, OleAutomation automation, int index) {
            String name;
            Object functionDescription;
            ArrayList<OleFunctionDescription> functionList = new ArrayList<OleFunctionDescription>();
            int i = 0;
            while ((functionDescription = automation.getFunctionDescription(i)) != null) {
                functionList.add((OleFunctionDescription)functionDescription);
                ++i;
            }
            Collections.sort(functionList, new Comparator<OleFunctionDescription>(){

                @Override
                public int compare(OleFunctionDescription o1, OleFunctionDescription o2) {
                    return o1.name.toLowerCase(Locale.ENGLISH).compareTo(o2.name.toLowerCase(Locale.ENGLISH));
                }
            });
            for (OleFunctionDescription functionDescription2 : functionList) {
                int j = 0;
                while (j < index) {
                    sb.append("  ");
                    ++j;
                }
                sb.append(this.getTypeDescription(functionDescription2.returnType)).append(' ').append(functionDescription2.name).append("(");
                int i2 = 0;
                while (i2 < functionDescription2.args.length) {
                    OleParameterDescription param = functionDescription2.args[i2];
                    if (i2 > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.getTypeDescription(param.type)).append(' ').append(param.name == null ? "arg" + i2 : param.name);
                    ++i2;
                }
                sb.append(")").append(Utils.LINE_SEPARATOR);
            }
            ArrayList<String> propertyList = new ArrayList<String>();
            int i3 = 1;
            while ((name = automation.getName(i3)) != null) {
                propertyList.add(name);
                ++i3;
            }
            Collections.sort(propertyList, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.toLowerCase(Locale.ENGLISH).compareTo(o2.toLowerCase(Locale.ENGLISH));
                }
            });
            for (String propertyName : propertyList) {
                int j = 0;
                while (j < index) {
                    sb.append("  ");
                    ++j;
                }
                sb.append(propertyName).append(Utils.LINE_SEPARATOR);
                Variant variantProperty = automation.getProperty(automation.getIDsOfNames(new String[]{propertyName})[0]);
                if (variantProperty != null && variantProperty.getType() == 9) {
                    OleAutomation newAutomation = variantProperty.getAutomation();
                    this.dumpOleInterfaceDefinitions(sb, newAutomation, index + 1);
                    newAutomation.dispose();
                }
                OleNativeComponent.dispose(variantProperty);
            }
        }

        private String getTypeDescription(short type) {
            String description = this.oleTypeToDescriptionMap.get(type);
            if (description == null) {
                description = String.valueOf('[') + String.valueOf(type) + ']';
            }
            return description;
        }

        public Object run(Object[] args) {
            this.oleTypeToDescriptionMap = new HashMap<Short, String>();
            Field[] fieldArray = OLE.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String fieldName = field.getName();
                Short value = null;
                if (fieldName.startsWith("VT_")) {
                    try {
                        value = (Short)field.get(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (value != null) {
                    String fieldDescription = fieldName.substring("VT_".length()).toLowerCase(Locale.ENGLISH);
                    this.oleTypeToDescriptionMap.put(value, fieldDescription);
                }
                ++n2;
            }
            OleAutomation automation = new OleAutomation(OleNativeComponent.getSite((OleFrame)this.getControl()));
            StringBuilder sb = new StringBuilder();
            this.dumpOleInterfaceDefinitions(sb, automation, 0);
            automation.dispose();
            System.out.print(sb.toString());
            return null;
        }
    }

    private static class CMN_getOleProperty
    extends ControlCommandMessage {
        private CMN_getOleProperty() {
        }

        public Object run(Object[] args) {
            String[] propertyPath = (String[])args[0];
            OleAutomation automation = new OleAutomation(OleNativeComponent.getSite((OleFrame)this.getControl()));
            int i = 0;
            while (i < propertyPath.length) {
                int[] ids = automation.getIDsOfNames(new String[]{propertyPath[i]});
                if (ids == null) {
                    automation.dispose();
                    return null;
                }
                if (i == propertyPath.length - 1) {
                    Object[] vargs = (Object[])args[1];
                    Variant[] params = new Variant[vargs.length];
                    int j = 0;
                    while (j < vargs.length) {
                        params[j] = OleNativeComponent.createVariant(vargs[j]);
                        ++j;
                    }
                    Variant propertyVariant = automation.getProperty(ids[0], params);
                    Variant[] variantArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Variant param = variantArray[n2];
                        OleNativeComponent.dispose(param);
                        ++n2;
                    }
                    Object result = OleNativeComponent.getVariantValue(propertyVariant);
                    OleNativeComponent.dispose(propertyVariant);
                    automation.dispose();
                    return result;
                }
                Variant variantProperty = automation.getProperty(ids[0]);
                OleAutomation newAutomation = variantProperty.getAutomation();
                variantProperty.dispose();
                automation.dispose();
                automation = newAutomation;
                ++i;
            }
            automation.dispose();
            return null;
        }
    }

    private static class CMN_invokeOleFunction
    extends ControlCommandMessage {
        private CMN_invokeOleFunction() {
        }

        public Object run(Object[] args) {
            String[] propertyPath = (String[])args[1];
            OleAutomation automation = new OleAutomation(OleNativeComponent.getSite((OleFrame)this.getControl()));
            int i = 0;
            while (i < propertyPath.length) {
                int[] ids = automation.getIDsOfNames(new String[]{propertyPath[i]});
                if (ids == null) {
                    automation.dispose();
                    return null;
                }
                if (i == propertyPath.length - 1) {
                    Object result;
                    Object[] vargs = (Object[])args[2];
                    Variant[] params = new Variant[vargs.length];
                    int j = 0;
                    while (j < vargs.length) {
                        params[j] = OleNativeComponent.createVariant(vargs[j]);
                        ++j;
                    }
                    if (((Boolean)args[0]).booleanValue()) {
                        Variant resultVariant = automation.invoke(ids[0], params);
                        result = OleNativeComponent.getVariantValue(resultVariant);
                        OleNativeComponent.dispose(resultVariant);
                    } else {
                        result = null;
                        automation.invokeNoReply(ids[0], params);
                    }
                    Variant[] variantArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Variant param = variantArray[n2];
                        OleNativeComponent.dispose(param);
                        ++n2;
                    }
                    automation.dispose();
                    return result;
                }
                Variant variantProperty = automation.getProperty(ids[0]);
                OleAutomation newAutomation = variantProperty.getAutomation();
                variantProperty.dispose();
                automation.dispose();
                automation = newAutomation;
                ++i;
            }
            automation.dispose();
            return null;
        }
    }

    private static class CMN_setOleProperty
    extends ControlCommandMessage {
        private CMN_setOleProperty() {
        }

        public Object run(Object[] args) {
            String[] propertyPath = (String[])args[0];
            OleAutomation automation = new OleAutomation(OleNativeComponent.getSite((OleFrame)this.getControl()));
            int i = 0;
            while (i < propertyPath.length) {
                int[] ids = automation.getIDsOfNames(new String[]{propertyPath[i]});
                if (ids == null) {
                    automation.dispose();
                    return false;
                }
                if (i == propertyPath.length - 1) {
                    Object[] vargs = (Object[])args[1];
                    Variant[] params = new Variant[vargs.length];
                    int j = 0;
                    while (j < vargs.length) {
                        params[j] = OleNativeComponent.createVariant(vargs[j]);
                        ++j;
                    }
                    boolean result = automation.setProperty(ids[0], params);
                    Variant[] variantArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Variant param = variantArray[n2];
                        OleNativeComponent.dispose(param);
                        ++n2;
                    }
                    automation.dispose();
                    return result;
                }
                Variant variantProperty = automation.getProperty(ids[0]);
                OleAutomation newAutomation = variantProperty.getAutomation();
                variantProperty.dispose();
                automation.dispose();
                automation = newAutomation;
                ++i;
            }
            automation.dispose();
            return false;
        }
    }
}

