/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.NetworkURLClassLoader;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NativeSwing;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.InProcessMessagingInterface;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.MessagingInterface;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceConfiguration;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceListener;
import chrriis.dj.nativeswing.swtimpl.OutProcessMessagingInterface;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.widgets.Display;

public class NativeInterface {
    private static final boolean IS_SYNCING_MESSAGES = Boolean.parseBoolean(System.getProperty("nativeswing.interface.syncmessages"));
    private static boolean isOpen;
    private static NativeInterfaceConfiguration nativeInterfaceConfiguration;
    private static boolean isInitialized;
    private static boolean isInProcess;
    private static volatile MessagingInterface messagingInterface;
    private static Display display;
    private static EventListenerList listenerList;

    static {
        listenerList = new EventListenerList();
    }

    static boolean isAlive() {
        return NativeInterface.isOpen() && messagingInterface.isAlive();
    }

    private static boolean isOpen() {
        return isOpen;
    }

    private static void checkOpen() {
        if (!NativeInterface.isOpen()) {
            throw new IllegalStateException("The native interface is not open! Please refer to the instructions to set it up properly.");
        }
    }

    public static void close() {
        if (!isOpen) {
            return;
        }
        isOpen = false;
        messagingInterface.destroy();
        messagingInterface = null;
        NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
        int n = nativeInterfaceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
            listener.nativeInterfaceClosed();
            ++n2;
        }
    }

    public static NativeInterfaceConfiguration getConfiguration() {
        if (nativeInterfaceConfiguration == null) {
            nativeInterfaceConfiguration = new NativeInterfaceConfiguration();
        }
        return nativeInterfaceConfiguration;
    }

    private static void loadClipboardDebuggingProperties() {
        try {
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader((String)systemClipboard.getData(DataFlavor.stringFlavor)));
            if ("[nativeswing debug]".equals(reader.readLine().trim().toLowerCase(Locale.ENGLISH))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int index = line.indexOf(61);
                    if (index <= 0) break;
                    String propertyName = line.substring(0, index).trim();
                    String propertyValue = line.substring(index + 1).trim();
                    if (!propertyName.startsWith("nativeswing.")) continue;
                    System.setProperty(propertyName, propertyValue);
                }
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    static boolean isInProcess() {
        return isInProcess;
    }

    public static void initialize() {
        if (NativeInterface.isInitialized()) {
            return;
        }
        if (SWT.getVersion() < 3536) {
            throw new IllegalStateException("The version of SWT that is required is 3.5M6 or later!");
        }
        if (nativeInterfaceConfiguration == null) {
            nativeInterfaceConfiguration = new NativeInterfaceConfiguration();
        }
        NativeSwing.initialize();
        String inProcessProperty = System.getProperty("nativeswing.interface.inprocess");
        isInProcess = inProcessProperty != null ? Boolean.parseBoolean(inProcessProperty) : Utils.IS_MAC;
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = nativeInterfaceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                listener.nativeInterfaceInitialized();
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isInProcess) {
            InProcess.initialize();
        }
        isInitialized = true;
    }

    public static void open() {
        if (NativeInterface.isOpen()) {
            return;
        }
        NativeInterface.initialize();
        NativeInterface.loadClipboardDebuggingProperties();
        if (isInProcess) {
            InProcess.createInProcessCommunicationChannel();
        } else {
            OutProcess.createOutProcessCommunicationChannel();
        }
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = nativeInterfaceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                listener.nativeInterfaceOpened();
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean notifyKilled() {
        isOpen = false;
        messagingInterface = null;
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = nativeInterfaceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                listener.nativeInterfaceClosed();
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!OutProcess.isNativeSide() && nativeInterfaceConfiguration.isNativeSideRespawnedOnError()) {
            OutProcess.createOutProcessCommunicationChannel();
            return true;
        }
        return false;
    }

    static void notifyRespawned() {
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = nativeInterfaceListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n2];
                listener.nativeInterfaceOpened();
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NativeInterface() {
    }

    static Object syncSend(boolean isTargetNativeSide, Message message) {
        NativeInterface.checkOpen();
        if (message instanceof LocalMessage) {
            LocalMessage localMessage = (LocalMessage)message;
            return localMessage.runCommand();
        }
        return NativeInterface.getMessagingInterface(!isTargetNativeSide).syncSend(message);
    }

    static void asyncSend(boolean isTargetNativeSide, Message message) {
        if (IS_SYNCING_MESSAGES) {
            NativeInterface.syncSend(isTargetNativeSide, message);
        } else {
            NativeInterface.checkOpen();
            if (message instanceof LocalMessage) {
                LocalMessage localMessage = (LocalMessage)message;
                localMessage.runCommand();
                return;
            }
            NativeInterface.getMessagingInterface(!isTargetNativeSide).asyncSend(message);
        }
    }

    static MessagingInterface getMessagingInterface(boolean isNativeSide) {
        if (NativeInterface.isInProcess()) {
            if (isNativeSide) {
                InProcessMessagingInterface.SWTInProcessMessagingInterface swtInProcessMessagingInterface = (InProcessMessagingInterface.SWTInProcessMessagingInterface)((InProcessMessagingInterface.SwingInProcessMessagingInterface)messagingInterface).getMirrorMessagingInterface();
                return swtInProcessMessagingInterface;
            }
            InProcessMessagingInterface.SwingInProcessMessagingInterface swingInProcessMessagingInterface = (InProcessMessagingInterface.SwingInProcessMessagingInterface)messagingInterface;
            return swingInProcessMessagingInterface;
        }
        if (isNativeSide) {
            OutProcessMessagingInterface.SWTOutProcessMessagingInterface swtOutProcessMessagingInterface = (OutProcessMessagingInterface.SWTOutProcessMessagingInterface)messagingInterface;
            return swtOutProcessMessagingInterface;
        }
        OutProcessMessagingInterface.SwingOutProcessMessagingInterface swingOutProcessMessagingInterface = (OutProcessMessagingInterface.SwingOutProcessMessagingInterface)messagingInterface;
        return swingOutProcessMessagingInterface;
    }

    public static Display getDisplay() {
        return display;
    }

    public static boolean isUIThread(boolean isNativeSide) {
        if (!NativeInterface.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        return NativeInterface.getMessagingInterface(isNativeSide).isUIThread();
    }

    static void checkUIThread(boolean isNativeSide) {
        if (!NativeInterface.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        NativeInterface.getMessagingInterface(isNativeSide).checkUIThread();
    }

    public static void runEventPump() {
        if (isInProcess) {
            InProcess.runEventPump();
        }
    }

    public static void addNativeInterfaceListener(NativeInterfaceListener listener) {
        listenerList.add(NativeInterfaceListener.class, listener);
    }

    public static void removeNativeInterfaceListener(NativeInterfaceListener listener) {
        listenerList.remove(NativeInterfaceListener.class, listener);
    }

    public static NativeInterfaceListener[] getNativeInterfaceListeners() {
        return (NativeInterfaceListener[])listenerList.getListeners(NativeInterfaceListener.class);
    }

    public static void main(String[] args) throws Exception {
        OutProcess.runNativeSide(args);
    }

    static /* synthetic */ boolean access$0() {
        return isInProcess;
    }

    static class InProcess {
        private static volatile boolean isEventPumpRunning;

        InProcess() {
        }

        /*
         * Unable to fully structure code
         */
        static void runEventPump() {
            if (NativeInterface.access$0()) ** GOTO lbl10
            return;
lbl-1000:
            // 1 sources

            {
                try {
                    if (NativeInterface.access$1().readAndDispatch() || !InProcess.isEventPumpRunning) continue;
                    NativeInterface.access$1().sleep();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
lbl10:
                // 4 sources

                ** while (InProcess.isEventPumpRunning)
            }
lbl11:
            // 1 sources

        }

        static void createInProcessCommunicationChannel() {
            NativeInterface.messagingInterface = InProcess.createInProcessMessagingInterface();
            isOpen = true;
            isEventPumpRunning = true;
        }

        private static void initialize() {
            Device.DEBUG = Boolean.parseBoolean(System.getProperty("nativeswing.swt.debug.device"));
            DeviceData data = new DeviceData();
            data.debug = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.debug"));
            data.tracking = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.tracking"));
            NativeInterface.display = new Display(data);
            InProcess.startAutoShutdownThread();
        }

        private static MessagingInterface createInProcessMessagingInterface() {
            return new InProcessMessagingInterface.SWTInProcessMessagingInterface(display).getMirrorMessagingInterface();
        }

        static void startAutoShutdownThread() {
            Thread autoShutdownThread = new Thread("NativeSwing Auto-Shutdown"){
                protected Thread[] activeThreads = new Thread[1024];

                public void run() {
                    while (true) {
                        boolean isAlive;
                        ThreadGroup group;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ThreadGroup parentGroup = group = Thread.currentThread().getThreadGroup();
                        while ((parentGroup = parentGroup.getParent()) != null) {
                            group = parentGroup;
                        }
                        boolean bl = isAlive = display == null;
                        if (!isAlive) {
                            int i = group.enumerate(this.activeThreads, true) - 1;
                            while (i >= 0) {
                                Thread t = this.activeThreads[i];
                                if (t != display.getThread() && !t.isDaemon() && t.isAlive()) {
                                    isAlive = true;
                                    break;
                                }
                                --i;
                            }
                        }
                        if (isAlive) continue;
                        isEventPumpRunning = false;
                        display.wake();
                    }
                }
            };
            autoShutdownThread.setDaemon(true);
            autoShutdownThread.start();
        }
    }

    static class OutProcess {
        OutProcess() {
        }

        static boolean isNativeSide() {
            return display != null;
        }

        static void createOutProcessCommunicationChannel() {
            NativeInterface.messagingInterface = OutProcess.createOutProcessMessagingInterface();
            isOpen = true;
            Properties nativeProperties = new Properties();
            Properties properties = System.getProperties();
            for (Object key : properties.keySet()) {
                Object value;
                if (!(key instanceof String) || !((value = properties.get(key)) instanceof String)) continue;
                nativeProperties.setProperty((String)key, (String)value);
            }
            new CMN_setProperties().syncExec(true, nativeProperties);
        }

        /*
         * WARNING - void declaration
         */
        private static Process createProcess(String localHostAddress, int port) {
            String[] flags;
            int n;
            boolean isProxyClassLoaderUsed;
            String[] nativeClassPathReferenceResources;
            ArrayList<String> classPathList = new ArrayList<String>();
            String pathSeparator = System.getProperty("path.separator");
            ArrayList<Object> referenceList = new ArrayList<Object>();
            ArrayList<String> optionalReferenceList = new ArrayList<String>();
            referenceList.add(NativeSwing.class);
            referenceList.add(NativeInterface.class);
            referenceList.add("org/eclipse/swt/widgets/Display.class");
            optionalReferenceList.add("org/mozilla/xpcom/Mozilla.class");
            optionalReferenceList.add("org/mozilla/interfaces/nsIWebBrowser.class");
            for (String optionalReference : optionalReferenceList) {
                if (NativeInterface.class.getClassLoader().getResource(optionalReference) == null) continue;
                referenceList.add(optionalReference);
            }
            Class<?>[] nativeClassPathReferenceClasses = nativeInterfaceConfiguration.getNativeClassPathReferenceClasses();
            if (nativeClassPathReferenceClasses != null) {
                referenceList.addAll((Collection)Arrays.asList(nativeClassPathReferenceClasses));
            }
            if ((nativeClassPathReferenceResources = nativeInterfaceConfiguration.getNativeClassPathReferenceResources()) != null) {
                referenceList.addAll((Collection)Arrays.asList(nativeClassPathReferenceResources));
            }
            if (!(isProxyClassLoaderUsed = Boolean.parseBoolean(System.getProperty("nativeswing.peervm.forceproxyclassloader")))) {
                for (Object e : referenceList) {
                    File clazzClassPath;
                    if (e instanceof Class) {
                        clazzClassPath = Utils.getClassPathFile((Class)((Class)e));
                    } else {
                        clazzClassPath = Utils.getClassPathFile((String)((String)e));
                        if (NativeInterface.class.getClassLoader().getResource((String)e) == null) {
                            throw new IllegalStateException("A resource that is needed in the classpath is missing: " + e);
                        }
                    }
                    File file = clazzClassPath = e instanceof Class ? Utils.getClassPathFile((Class)((Class)e)) : Utils.getClassPathFile((String)((String)e));
                    if (clazzClassPath != null) {
                        String path = clazzClassPath.getAbsolutePath();
                        if (classPathList.contains(path)) continue;
                        classPathList.add(path);
                        continue;
                    }
                    isProxyClassLoaderUsed = true;
                }
            }
            if (isProxyClassLoaderUsed) {
                classPathList.clear();
                File file = new File(System.getProperty("java.io.tmpdir"), ".djnativeswing/classpath");
                Utils.deleteAll((File)file);
                String classPath = String.valueOf(NetworkURLClassLoader.class.getName().replace('.', '/')) + ".class";
                File mainClassFile = new File(file, classPath);
                mainClassFile.getParentFile().mkdirs();
                if (!mainClassFile.exists()) {
                    try {
                        int n2;
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(mainClassFile));
                        BufferedInputStream in = new BufferedInputStream(NativeInterface.class.getResourceAsStream("/" + classPath));
                        byte[] bytes = new byte[1024];
                        while ((n2 = in.read(bytes)) != -1) {
                            void n3;
                            out.write(bytes, 0, (int)n3);
                        }
                        in.close();
                        out.close();
                    }
                    catch (Exception out) {
                        // empty catch block
                    }
                    mainClassFile.deleteOnExit();
                }
                classPathList.add(file.getAbsolutePath());
            }
            StringBuilder stringBuilder = new StringBuilder();
            int i = 0;
            while (i < classPathList.size()) {
                if (i > 0) {
                    stringBuilder.append(pathSeparator);
                }
                stringBuilder.append((String)classPathList.get(i));
                ++i;
            }
            String javaHome = System.getProperty("java.home");
            String[] candidateBinaries = new String[]{new File(javaHome, "bin/java").getAbsolutePath(), new File("/usr/lib/java").getAbsolutePath(), "java"};
            Process p = null;
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(null);
            String[] peerVMParams = nativeInterfaceConfiguration.getPeerVMParams();
            if (peerVMParams != null) {
                String[] stringArray = peerVMParams;
                n = peerVMParams.length;
                int n4 = 0;
                while (n4 < n) {
                    String param = stringArray[n4];
                    argList.add(param);
                    ++n4;
                }
            }
            String[] stringArray = flags = new String[]{"nativeswing.interface.syncmessages", "nativeswing.interface.debug.printmessages", "nativeswing.peervm.debug.printstartmessage", "nativeswing.swt.debug.device", "nativeswing.swt.devicedata.debug", "nativeswing.swt.devicedata.tracking"};
            int n8 = flags.length;
            n = 0;
            while (n < n8) {
                String flag = stringArray[n];
                if (Boolean.parseBoolean(System.getProperty(flag))) {
                    argList.add("-D" + flag + "=true");
                }
                ++n;
            }
            argList.add("-Dnativeswing.localhostaddress=" + localHostAddress);
            argList.add("-classpath");
            argList.add(stringBuilder.toString());
            if (isProxyClassLoaderUsed) {
                argList.add(NetworkURLClassLoader.class.getName());
                argList.add(WebServer.getDefaultWebServer().getClassPathResourceURL("", ""));
            }
            argList.add(NativeInterface.class.getName());
            argList.add(String.valueOf(port));
            String javaVersion = System.getProperty("java.version");
            if (javaVersion != null && javaVersion.compareTo("1.6.0_10") >= 0 && "Sun Microsystems Inc.".equals(System.getProperty("java.vendor"))) {
                boolean isTryingAppletCompatibility = true;
                if (peerVMParams != null) {
                    String[] iOException = peerVMParams;
                    int n5 = peerVMParams.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String peerVMParam = iOException[n6];
                        if (peerVMParam.startsWith("-Xbootclasspath/a:")) {
                            isTryingAppletCompatibility = false;
                            break;
                        }
                        ++n6;
                    }
                }
                if (isTryingAppletCompatibility) {
                    File[] deploymentFiles = new File[]{new File(javaHome, "lib/deploy.jar"), new File(javaHome, "lib/plugin.jar"), new File(javaHome, "lib/javaws.jar")};
                    ArrayList<String> argListX = new ArrayList<String>();
                    argListX.add(candidateBinaries[0]);
                    StringBuilder sbX = new StringBuilder();
                    int i2 = 0;
                    while (i2 < deploymentFiles.length) {
                        File deploymentFile;
                        if (i2 != 0) {
                            sbX.append(pathSeparator);
                        }
                        if ((deploymentFile = deploymentFiles[i2]).exists()) {
                            sbX.append(deploymentFile.getAbsolutePath());
                        }
                        ++i2;
                    }
                    if (sbX.indexOf(" ") != -1) {
                        argListX.add("\"-Xbootclasspath/a:" + sbX + "\"");
                    } else {
                        argListX.add("-Xbootclasspath/a:" + sbX);
                    }
                    argListX.addAll(argList.subList(1, argList.size()));
                    if (Boolean.parseBoolean(System.getProperty("nativeswing.peervm.debug.printcommandline"))) {
                        System.err.println("Native Command: " + Arrays.toString(argListX.toArray()));
                    }
                    try {
                        p = new ProcessBuilder(argListX).start();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (p == null) {
                String[] stringArray2 = candidateBinaries;
                int n7 = candidateBinaries.length;
                int n9 = 0;
                while (n9 < n7) {
                    String candidateBinary = stringArray2[n9];
                    argList.set(0, candidateBinary);
                    if (Boolean.parseBoolean(System.getProperty("nativeswing.peervm.debug.printcommandline"))) {
                        System.err.println("Native Command: " + Arrays.toString(argList.toArray()));
                    }
                    try {
                        p = new ProcessBuilder(argList).start();
                        break;
                    }
                    catch (IOException iOException) {
                        ++n9;
                    }
                }
            }
            if (p == null) {
                throw new IllegalStateException("Failed to spawn the VM!");
            }
            return p;
        }

        private static MessagingInterface createOutProcessMessagingInterface() {
            Process p;
            String localHostAddress = Utils.getLocalHostAddress();
            if (localHostAddress == null) {
                throw new IllegalStateException("Failed to find a suitable local host address to communicate with a spawned VM!");
            }
            int port = Integer.parseInt(System.getProperty("nativeswing.interface.port", "-1"));
            if (port <= 0) {
                ServerSocket serverSocket;
                try {
                    serverSocket = new ServerSocket();
                    serverSocket.setReuseAddress(false);
                    serverSocket.bind(new InetSocketAddress(InetAddress.getByName(localHostAddress), 0));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                port = serverSocket.getLocalPort();
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (Boolean.parseBoolean(System.getProperty("nativeswing.peervm.create", "true"))) {
                p = OutProcess.createProcess(localHostAddress, port);
                OutProcess.connectStream(System.err, p.getErrorStream());
                OutProcess.connectStream(System.out, p.getInputStream());
            } else {
                p = null;
            }
            Socket socket = null;
            int i = 99;
            while (i >= 0) {
                try {
                    socket = new Socket(localHostAddress, port);
                    break;
                }
                catch (IOException e) {
                    if (i == 0) {
                        throw new RuntimeException(e);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --i;
                }
            }
            if (socket == null) {
                if (p != null) {
                    p.destroy();
                }
                throw new IllegalStateException("Failed to connect to spawned VM!");
            }
            return new OutProcessMessagingInterface.SwingOutProcessMessagingInterface(socket, false);
        }

        private static void connectStream(final PrintStream out, InputStream in) {
            final BufferedInputStream bin = new BufferedInputStream(in);
            Thread streamThread = new Thread("NativeSwing Stream Connector"){

                public void run() {
                    try {
                        int i;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        String lineSeparator = Utils.LINE_SEPARATOR;
                        byte lastByte = (byte)lineSeparator.charAt(lineSeparator.length() - 1);
                        boolean addMessage = true;
                        byte[] bytes = new byte[1024];
                        while ((i = bin.read(bytes)) != -1) {
                            baos.reset();
                            int j = 0;
                            while (j < i) {
                                byte b = bytes[j];
                                if (addMessage) {
                                    baos.write("NativeSwing: ".getBytes());
                                }
                                addMessage = b == lastByte;
                                baos.write(b);
                                ++j;
                            }
                            try {
                                out.write(baos.toByteArray());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            streamThread.setDaemon(true);
            streamThread.start();
        }

        static void runNativeSide(String[] args) throws IOException {
            Socket socket;
            if (Boolean.parseBoolean(System.getProperty("nativeswing.peervm.debug.printstartmessage"))) {
                System.err.println("Starting spawned VM");
            }
            isOpen = true;
            int port = Integer.parseInt(args[0]);
            ServerSocket serverSocket = null;
            int i = 19;
            while (i >= 0) {
                try {
                    serverSocket = new ServerSocket();
                    serverSocket.setReuseAddress(true);
                    serverSocket.bind(new InetSocketAddress(Utils.getLocalHostAddress(), port));
                    break;
                }
                catch (IOException e2) {
                    if (i == 0) {
                        throw e2;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    --i;
                }
            }
            final ServerSocket serverSocket_ = serverSocket;
            if (!Boolean.parseBoolean(System.getProperty("nativeswing.peervm.keepalive"))) {
                Thread shutdownThread = new Thread("NativeSwing Shutdown"){

                    public void run() {
                        try {
                            2.sleep(10000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (messagingInterface == null) {
                            try {
                                serverSocket_.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                shutdownThread.setDaemon(true);
                shutdownThread.start();
            }
            try {
                socket = serverSocket.accept();
            }
            catch (Exception e) {
                throw new IllegalStateException("The native side did not receive an incoming connection!");
            }
            Device.DEBUG = Boolean.parseBoolean(System.getProperty("nativeswing.swt.debug.device"));
            DeviceData data = new DeviceData();
            data.debug = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.debug"));
            data.tracking = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.tracking"));
            NativeInterface.display = new Display(data);
            Display.setAppName((String)"DJ Native Swing");
            NativeInterface.messagingInterface = new OutProcessMessagingInterface.SWTOutProcessMessagingInterface(socket, true, display);
            while (display != null && !display.isDisposed()) {
                try {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private static class CMN_setProperties
        extends CommandMessage {
            private CMN_setProperties() {
            }

            public Object run(Object[] args) {
                Properties systemProperties = System.getProperties();
                Properties properties = (Properties)args[0];
                for (Object o : properties.keySet()) {
                    if (systemProperties.containsKey(o)) continue;
                    try {
                        System.setProperty((String)o, properties.getProperty((String)o));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
    }
}

