/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceAdapter;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceListener;
import chrriis.dj.nativeswing.swtimpl.SWTUtils;
import com.sun.jna.Native;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeComponent
extends Canvas {
    private static final boolean IS_PRINTING_FAILED_MESSAGES = Boolean.parseBoolean(System.getProperty("nativeswing.components.debug.printfailedmessages"));
    private NativeComponentWrapper nativeComponentWrapper = new NativeComponentWrapper(this){

        protected String getComponentDescription() {
            return NativeComponent.this.getComponentDescription();
        }

        protected void paintNativeComponent(BufferedImage image, Rectangle[] rectangles) {
            NativeComponent.this.paintComponent(image, rectangles);
        }

        protected void setNativeComponentEnabled(boolean isEnabled) {
            NativeComponent.this.setShellEnabled(isEnabled);
        }
    };
    private volatile List<CommandMessage> initializationCommandMessageList = new ArrayList<CommandMessage>();
    private static ObjectRegistry nativeComponentRegistry;
    private static ObjectRegistry controlRegistry;
    private int componentID;
    private Thread resizeThread;
    private int additionCount;
    private boolean isForcingInitialization;
    private Method getAWTHandleMethod;
    private NativeInterfaceListener nativeInterfaceListener;
    private boolean isNativePeerValid;
    private String invalidNativePeerText;
    private boolean isNativePeerInitialized;
    private boolean isNativePeerDisposed;
    private boolean isShellEnabled = true;
    protected EventListenerList listenerList = new EventListenerList();

    static {
        if (NativeInterface.isInProcess()) {
            nativeComponentRegistry = new ObjectRegistry();
            controlRegistry = new ObjectRegistry();
        } else if (NativeInterface.OutProcess.isNativeSide()) {
            controlRegistry = new ObjectRegistry();
        } else {
            nativeComponentRegistry = new ObjectRegistry();
        }
    }

    public void runInSequence(Runnable runnable) {
        this.runSync(new CMLocal_runInSequence(), runnable);
    }

    public Object runSync(CommandMessage commandMessage, Object ... args) {
        if (NativeInterface.isAlive()) {
            NativeInterface.checkUIThread(false);
        }
        if (commandMessage instanceof ControlCommandMessage) {
            ((ControlCommandMessage)commandMessage).setNativeComponent(this);
        }
        if (this.initializationCommandMessageList != null) {
            commandMessage.setSyncExec(true);
            commandMessage.setArgs(args);
            this.initializationCommandMessageList.add(commandMessage);
            return null;
        }
        if (!this.isNativePeerValid()) {
            commandMessage.setArgs(args);
            this.printFailedInvocation(commandMessage);
            return null;
        }
        return commandMessage.syncExec(true, args);
    }

    public void runAsync(CommandMessage commandMessage, Object ... args) {
        if (NativeInterface.isAlive()) {
            NativeInterface.checkUIThread(false);
        }
        if (commandMessage instanceof ControlCommandMessage) {
            ((ControlCommandMessage)commandMessage).setNativeComponent(this);
        }
        if (this.initializationCommandMessageList != null) {
            commandMessage.setSyncExec(false);
            commandMessage.setArgs(args);
            this.initializationCommandMessageList.add(commandMessage);
        } else if (!this.isNativePeerValid()) {
            commandMessage.setArgs(args);
            this.printFailedInvocation(commandMessage);
        } else {
            commandMessage.asyncExec(true, args);
        }
    }

    private void printFailedInvocation(Message message) {
        if (IS_PRINTING_FAILED_MESSAGES) {
            System.err.println("Invalid " + this.getComponentDescription() + ": " + message);
        }
    }

    protected static ObjectRegistry getNativeComponentRegistry() {
        return nativeComponentRegistry;
    }

    protected static ObjectRegistry getControlRegistry() {
        return controlRegistry;
    }

    protected int getComponentID() {
        return this.componentID;
    }

    public NativeComponent() {
        this.componentID = NativeComponent.getNativeComponentRegistry().add((Object)this);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (NativeComponent.this.isNativePeerValid() && !NativeComponent.this.isNativePeerDisposed()) {
                    NativeComponent.this.runSync(new CMN_transferFocus(), new Object[0]);
                }
            }
        });
        this.enableEvents(8L);
        this.setFocusable(true);
    }

    @Override
    protected void processKeyEvent(java.awt.event.KeyEvent e) {
        java.awt.event.KeyEvent ke = e;
        if (!(ke instanceof CKeyEvent)) {
            this.getPeer().handleEvent(e);
            e.consume();
            return;
        }
        super.processKeyEvent(ke);
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (this.resizeThread == null && width != this.getWidth() || height != this.getHeight()) {
            this.resizeThread = new Thread("NativeSwing Resize"){

                public void run() {
                    try {
                        3.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            NativeComponent.this.resizeThread = null;
                            if (NativeComponent.this.isNativePeerValid()) {
                                new CMN_reshape().asyncExec(NativeComponent.this, NativeComponent.this.getWidth(), NativeComponent.this.getHeight());
                            }
                        }
                    });
                }
            };
            this.resizeThread.start();
        }
        super.reshape(x, y, width, height);
    }

    private static Object[] getKeyEventArgs(KeyEvent keyEvent, int keyEventType) {
        return new Object[]{keyEventType, keyEvent.stateMask, Character.valueOf(keyEvent.character), keyEvent.keyCode};
    }

    private static Object[] getMouseEventArgs(Control control, org.eclipse.swt.events.MouseEvent e, int mouseEventType) {
        Integer lastEventType;
        org.eclipse.swt.events.MouseEvent lastEvent = (org.eclipse.swt.events.MouseEvent)control.getData("NS_LastMouseEvent");
        if (lastEvent != null && (lastEventType = (Integer)control.getData("NS_LastMouseEventType")) == mouseEventType && lastEvent.x == e.x && lastEvent.y == e.y && lastEvent.button == e.button && lastEvent.count == e.count && lastEvent.stateMask == e.stateMask) {
            return null;
        }
        control.setData("NS_LastMouseEvent", (Object)e);
        control.setData("NS_LastMouseEventType", (Object)mouseEventType);
        lastEvent = e;
        return new Object[]{mouseEventType, e.x, e.y, e.button, e.count, e.stateMask, e.display.getCursorLocation()};
    }

    private static void configureControl(final Control control, int componentID) {
        control.setData("NS_ID", (Object)componentID);
        control.setData("NS_EnabledEventsMask", (Object)0L);
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 501);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 502);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs;
                if (((Long)e.widget.getData("NS_EnabledEventsMask") & 0x20L) != 0L && (mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 503)) != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = NativeComponent.getMouseEventArgs(control, e, 507);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 9) {
                    e.doit = false;
                }
                new CMJ_dispatchKeyEvent().asyncExec(control, NativeComponent.getKeyEventArgs(e, 401));
            }

            public void keyReleased(KeyEvent e) {
                new CMJ_dispatchKeyEvent().asyncExec(control, NativeComponent.getKeyEventArgs(e, 402));
                new CMJ_dispatchKeyEvent().asyncExec(control, NativeComponent.getKeyEventArgs(e, 400));
            }
        });
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener listener) {
        if (this.getMouseMotionListeners().length == 0 && listener != null) {
            this.runAsync(new CMN_setEventsEnabled(), 32L, true);
        }
        super.addMouseMotionListener(listener);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener listener) {
        super.removeMouseMotionListener(listener);
        if (this.getMouseMotionListeners().length == 0) {
            this.runAsync(new CMN_setEventsEnabled(), 32L, false);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNativePeerValid()) {
            String text = this.invalidNativePeerText;
            if (text == null) {
                text = "Invalid " + this.getComponentDescription();
            }
            FontMetrics fm = g.getFontMetrics();
            BufferedReader r = new BufferedReader(new StringReader(text));
            int lineHeight = fm.getHeight();
            int ascent = fm.getAscent();
            try {
                String line;
                int i = 0;
                while ((line = r.readLine()) != null) {
                    g.drawString(line, 5, ascent + 5 + lineHeight * i);
                    ++i;
                }
            }
            catch (Exception exception) {}
        } else {
            this.nativeComponentWrapper.paintBackBuffer(g);
        }
    }

    @Override
    public void print(Graphics g) {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paintComponent(image);
        g.drawImage(image, 0, 0, null);
        g.dispose();
        image.flush();
    }

    private void throwDuplicateCreationException() {
        this.isNativePeerValid = false;
        this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\nA native component cannot be re-created after having been disposed.";
        this.repaint();
        throw new IllegalStateException("A native component cannot be re-created after having been disposed! To achieve re-parenting or allow re-creation, set the option to defer destruction until finalization (note that re-parenting accross different windows is not supported).");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isForcingInitialization) {
            return;
        }
        if (this.isNativePeerDisposed) {
            this.throwDuplicateCreationException();
        }
        ++this.additionCount;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (NativeComponent.this.isNativePeerDisposed && NativeComponent.this.additionCount > 1) {
                    NativeComponent.this.throwDuplicateCreationException();
                }
                if (!NativeComponent.this.isNativePeerInitialized) {
                    NativeComponent.this.createNativePeer();
                }
            }
        });
    }

    public void initializeNativePeer() {
        Window windowAncestor;
        if (NativeInterface.isAlive()) {
            NativeInterface.checkUIThread(false);
        }
        if ((windowAncestor = SwingUtilities.getWindowAncestor(this)) == null) {
            throw new IllegalStateException("This method can only be called when the component has a Window ancestor!");
        }
        if (this.isNativePeerDisposed) {
            this.throwDuplicateCreationException();
        }
        if (!this.isNativePeerInitialized) {
            this.isForcingInitialization = true;
            try {
                windowAncestor.addNotify();
                this.createNativePeer();
            }
            finally {
                this.isForcingInitialization = false;
            }
        }
    }

    private Object getHandle() {
        if (NativeInterface.isInProcess()) {
            return this;
        }
        try {
            if (this.getAWTHandleMethod == null) {
                Method loadLibraryMethod = SWT_AWT.class.getDeclaredMethod("loadLibrary", new Class[0]);
                loadLibraryMethod.setAccessible(true);
                loadLibraryMethod.invoke(null, new Object[0]);
                this.getAWTHandleMethod = SWT_AWT.class.getDeclaredMethod("getAWTHandle", Canvas.class);
                this.getAWTHandleMethod.setAccessible(true);
            }
            return this.getAWTHandleMethod.invoke(null, this);
        }
        catch (Exception e) {
            try {
                return Native.getComponentID((Component)this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        }
    }

    protected Object[] getNativePeerCreationParameters() {
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void createNativePeer() {
        isInterfaceAlive = NativeInterface.isAlive();
        if (isInterfaceAlive) {
            NativeInterface.checkUIThread(false);
        }
        if (this.initializationCommandMessageList == null) {
            this.throwDuplicateCreationException();
        }
        initializationCommandMessageList_ = this.initializationCommandMessageList;
        this.initializationCommandMessageList = null;
        this.isNativePeerInitialized = true;
        if (isInterfaceAlive) {
            block10: {
                this.nativeInterfaceListener = new NNativeInterfaceListener(this);
                NativeInterface.addNativeInterfaceListener(this.nativeInterfaceListener);
                this.isNativePeerValid = true;
                try {
                    this.runSync(new CMN_createControl(), new Object[]{this.componentID, this.getClass().getName(), this.getHandle(), this.getNativePeerCreationParameters()});
                    break block10;
                }
                catch (Exception e) {
                    this.isNativePeerValid = false;
                    sb = new StringBuilder();
                    t /* !! */  = e;
                    ** while (t /* !! */  != null)
                }
lbl-1000:
                // 1 sources

                {
                    sb.append("    " + t /* !! */ .toString() + "\n");
                    t /* !! */  = t /* !! */ .getCause();
                    continue;
                }
lbl26:
                // 1 sources

                this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\n" + sb.toString();
                e.printStackTrace();
            }
            new CMN_reshape().asyncExec(this, new Object[]{this.getWidth(), this.getHeight()});
        } else {
            this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\nThe native interface is not open!";
        }
        for (CommandMessage initCommandMessage : initializationCommandMessageList_) {
            if (!this.isNativePeerValid()) {
                this.printFailedInvocation(initCommandMessage);
                continue;
            }
            if (initCommandMessage.isSyncExec()) {
                initCommandMessage.syncSend(true);
                continue;
            }
            initCommandMessage.asyncSend(true);
        }
    }

    @Override
    public void removeNotify() {
        this.disposeNativePeer();
        super.removeNotify();
    }

    protected void disposeNativePeer() {
        if (!this.isNativePeerDisposed) {
            this.isNativePeerDisposed = true;
            if (this.isNativePeerInitialized) {
                NativeInterface.removeNativeInterfaceListener(this.nativeInterfaceListener);
                if (this.isNativePeerValid()) {
                    this.runSync(new CMN_destroyControl(), new Object[0]);
                }
            }
            this.invalidateNativePeer("The native component was disposed.");
            NativeComponent.getNativeComponentRegistry().remove(this.componentID);
            this.isNativePeerValid = false;
            this.nativeComponentWrapper.disposeNativeComponent();
        }
    }

    public boolean isNativePeerDisposed() {
        return this.isNativePeerDisposed;
    }

    public boolean isNativePeerInitialized() {
        return this.isNativePeerInitialized;
    }

    public boolean isNativePeerValid() {
        return this.isNativePeerValid && NativeInterface.isAlive();
    }

    private void invalidateNativePeer(String invalidNativePeerText) {
        if (this.isNativePeerValid) {
            this.isNativePeerValid = false;
            this.invalidNativePeerText = "Invalid " + this.getComponentDescription() + "\n\nReason:\n" + invalidNativePeerText;
            this.repaint();
        }
    }

    private String getComponentDescription() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getComponentID() + "/" + this.hashCode() + "]";
    }

    @Override
    public String toString() {
        return this.getComponentDescription();
    }

    protected Component createEmbeddableComponent(Map<Object, Object> optionMap) {
        return this.nativeComponentWrapper.createEmbeddableComponent(optionMap);
    }

    private void setShellEnabled(boolean isEnabled) {
        if (isEnabled == this.isShellEnabled) {
            return;
        }
        this.isShellEnabled = isEnabled;
        this.runAsync(new CMN_setShellEnabled(), isEnabled);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.runAsync(new CMN_setEnabled(), isEnabled);
    }

    @Override
    public boolean hasFocus() {
        boolean hasFocus = super.hasFocus();
        if (!hasFocus && this.isNativePeerValid() && !this.isNativePeerDisposed) {
            return Boolean.TRUE.equals(new CMN_hasFocus().syncExec(this, new Object[0]));
        }
        return hasFocus;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = null;
        if (this.isNativePeerValid() && !this.isNativePeerDisposed) {
            result = (Dimension)new CMN_getPreferredSize().syncExec(this, new Object[0]);
        }
        if (result == null) {
            result = super.getPreferredSize();
        }
        return result;
    }

    public void paintComponent(BufferedImage image) {
        this.paintComponent(image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(BufferedImage image, Rectangle[] rectangles) {
        if (image == null || !this.isNativePeerValid() || this.isNativePeerDisposed) {
            return;
        }
        int width = Math.min(this.getWidth(), image.getWidth());
        int height = Math.min(this.getHeight(), image.getHeight());
        if (width <= 0 || height <= 0) {
            return;
        }
        if (rectangles == null) {
            rectangles = new Rectangle[]{new Rectangle(width, height)};
        }
        Rectangle bounds = new Rectangle(width, height);
        ArrayList<Rectangle> rectangleList = new ArrayList<Rectangle>();
        Rectangle[] rectangleArray = rectangles;
        int n = rectangles.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray[n2];
            if (rectangle.intersects(bounds)) {
                rectangleList.add(rectangle.intersection(bounds));
            }
            ++n2;
        }
        if (rectangleList.isEmpty()) {
            return;
        }
        rectangles = rectangleList.toArray(new Rectangle[0]);
        try {
            final ServerSocket serverSocket = new ServerSocket();
            String localHostAddress = Utils.getLocalHostAddress();
            if (localHostAddress == null) {
                localHostAddress = "127.0.0.1";
            }
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName(localHostAddress), 0));
            NativeInterfaceAdapter nativeInterfaceListener = new NativeInterfaceAdapter(){

                public void nativeInterfaceClosed() {
                    NativeInterface.removeNativeInterfaceListener(this);
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            CMN_getComponentImage getComponentImage = new CMN_getComponentImage();
            NativeInterface.addNativeInterfaceListener(nativeInterfaceListener);
            getComponentImage.asyncExec(this, serverSocket.getLocalPort(), rectangles, localHostAddress);
            Socket socket = serverSocket.accept();
            byte[] bytes = new byte[3072];
            int count = 0;
            int readCount = 0;
            try {
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedImage bufferedImage = image;
                synchronized (bufferedImage) {
                    Rectangle[] rectangleArray2 = rectangles;
                    int n3 = rectangles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Rectangle rectangle = rectangleArray2[n4];
                        int[] pixels = new int[rectangle.width];
                        int y = 0;
                        while (y < rectangle.height && readCount != -1) {
                            int x = 0;
                            while (x < rectangle.width && readCount != -1) {
                                if (readCount == 0 && (readCount = in.read(bytes)) != -1 && readCount % 3 != 0) {
                                    int c = in.read(bytes, readCount, bytes.length - readCount);
                                    readCount = c == -1 ? -1 : (readCount += c);
                                }
                                if (readCount == -1) break;
                                pixels[x] = 0xFF000000 | (0xFF & bytes[count]) << 16 | (0xFF & bytes[count + 1]) << 8 | 0xFF & bytes[count + 2];
                                if ((count += 3) == readCount) {
                                    count = 0;
                                    readCount = 0;
                                }
                                ++x;
                            }
                            if (readCount != -1) {
                                image.setRGB(rectangle.x, rectangle.y + y, rectangle.width, 1, pixels, 0, rectangle.width);
                            }
                            ++y;
                        }
                        if (readCount == -1) break;
                        ++n4;
                    }
                }
                NativeInterface.removeNativeInterfaceListener(nativeInterfaceListener);
                in.close();
                socket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void createBackBuffer() {
        this.nativeComponentWrapper.createBackBuffer();
    }

    public void updateBackBufferOnVisibleTranslucentAreas() {
        this.nativeComponentWrapper.updateBackBufferOnVisibleTranslucentAreas();
    }

    public void updateBackBuffer(Rectangle[] rectangles) {
        this.nativeComponentWrapper.updateBackBuffer(rectangles);
    }

    public void destroyBackBuffer() {
        this.nativeComponentWrapper.destroyBackBuffer();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result = this.listenerList.getListeners(listenerType);
        if (result.length == 0) {
            return super.getListeners(listenerType);
        }
        return result;
    }

    private static class CKeyEvent
    extends java.awt.event.KeyEvent {
        public CKeyEvent(Component source, int id, long when, int modifiers, int keyCode, char keyChar) {
            super(source, id, when, modifiers, keyCode, keyChar);
        }
    }

    private static class CMJ_dispatchKeyEvent
    extends ControlCommandMessage {
        private CMJ_dispatchKeyEvent() {
        }

        public Object run(Object[] args) {
            int keyCode;
            NativeComponent nativeComponent = this.getNativeComponent();
            if (nativeComponent == null || !nativeComponent.isShowing()) {
                return null;
            }
            int type = (Integer)args[0];
            int e_stateMask = (Integer)args[1];
            char e_character = ((Character)args[2]).charValue();
            int e_keyCode = (Integer)args[3];
            if (e_keyCode == 9) {
                if (type == 401 && (e_stateMask & 0x40000) != 0) {
                    boolean isForward = (e_stateMask & 0x20000) == 0;
                    nativeComponent.nativeComponentWrapper.transferFocus(!isForward);
                }
                return null;
            }
            char character = e_character;
            if (type == 400) {
                if (character == '\u0000') {
                    return null;
                }
                keyCode = 0;
            } else {
                keyCode = SWTUtils.translateSWTKeyCode(e_keyCode);
            }
            CKeyEvent ke = new CKeyEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), keyCode, character);
            nativeComponent.dispatchEvent(ke);
            return null;
        }
    }

    private static class CMJ_dispatchMouseEvent
    extends ControlCommandMessage {
        private static int buttonPressedCount;

        private CMJ_dispatchMouseEvent() {
        }

        public Object run(Object[] args) {
            NativeComponent nativeComponent = this.getNativeComponent();
            if (nativeComponent == null || !nativeComponent.isShowing()) {
                return null;
            }
            int type = (Integer)args[0];
            int e_x = (Integer)args[1];
            int e_y = (Integer)args[2];
            int e_button = (Integer)args[3];
            int e_count = (Integer)args[4];
            int e_stateMask = (Integer)args[5];
            Point e_cursorLocation = (Point)args[6];
            switch (type) {
                case 501: {
                    ++buttonPressedCount;
                    break;
                }
                case 502: {
                    if (--buttonPressedCount >= 0) break;
                    buttonPressedCount = 0;
                    break;
                }
            }
            int button = SWTUtils.translateSWTMouseButton(e_button);
            if (button == 0) {
                switch (type) {
                    case 500: 
                    case 501: 
                    case 502: {
                        return null;
                    }
                }
            }
            if (buttonPressedCount != 0 && type == 503) {
                type = 506;
            }
            MouseEvent me = Utils.IS_JAVA_6_OR_GREATER ? (type == 507 ? new MouseWheelEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_cursorLocation.x, e_cursorLocation.y, 0, false, 0, Math.abs(e_count), e_count < 0 ? 1 : -1) : new MouseEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_cursorLocation.x, e_cursorLocation.y, e_count, false, button)) : (type == 507 ? new MouseWheelEvent((Component)nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, 0, false, 0, Math.abs(e_count), e_count < 0 ? 1 : -1) : new MouseEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_count, false, button));
            nativeComponent.dispatchEvent(me);
            return null;
        }
    }

    private class CMLocal_runInSequence
    extends LocalMessage {
        private CMLocal_runInSequence() {
        }

        public Object run(Object[] args) {
            ((Runnable)args[0]).run();
            return null;
        }
    }

    private static class CMN_createControl
    extends CommandMessage {
        private CMN_createControl() {
        }

        public Shell createShell(Object handle) throws Exception {
            if (NativeInterface.isInProcess()) {
                ComponentListener componentListener;
                Canvas canvas = (Canvas)handle;
                ComponentListener[] componentListeners = canvas.getComponentListeners();
                Shell shell = SWT_AWT.new_Shell((Display)NativeInterface.getDisplay(), (Canvas)canvas);
                ComponentListener[] componentListenerArray = canvas.getComponentListeners();
                int n = componentListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    componentListener = componentListenerArray[n2];
                    canvas.removeComponentListener(componentListener);
                    ++n2;
                }
                componentListenerArray = componentListeners;
                n = componentListeners.length;
                n2 = 0;
                while (n2 < n) {
                    componentListener = componentListenerArray[n2];
                    canvas.addComponentListener(componentListener);
                    ++n2;
                }
                return shell;
            }
            Method shellCreationMethod = null;
            try {
                shellCreationMethod = Shell.class.getMethod(String.valueOf(SWT.getPlatform()) + "_new", Display.class, Integer.TYPE);
            }
            catch (Exception componentListeners) {
                // empty catch block
            }
            if (shellCreationMethod != null) {
                return (Shell)shellCreationMethod.invoke(null, NativeInterface.getDisplay(), ((Number)handle).intValue());
            }
            try {
                shellCreationMethod = Shell.class.getMethod(String.valueOf(SWT.getPlatform()) + "_new", Display.class, Long.TYPE);
            }
            catch (Exception componentListeners) {
                // empty catch block
            }
            if (shellCreationMethod != null) {
                return (Shell)shellCreationMethod.invoke(null, NativeInterface.getDisplay(), ((Number)handle).longValue());
            }
            Constructor shellConstructor = null;
            try {
                shellConstructor = Shell.class.getConstructor(Display.class, Shell.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellConstructor != null) {
                shellConstructor.setAccessible(true);
                return (Shell)shellConstructor.newInstance(NativeInterface.getDisplay(), null, 8, ((Number)handle).intValue());
            }
            try {
                shellConstructor = Shell.class.getConstructor(Display.class, Shell.class, Integer.TYPE, Long.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellConstructor != null) {
                shellConstructor.setAccessible(true);
                return (Shell)shellConstructor.newInstance(NativeInterface.getDisplay(), null, 8, ((Number)handle).longValue());
            }
            throw new IllegalStateException("Failed to create a Shell!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(Object[] args) throws Exception {
            ObjectRegistry objectRegistry = NativeComponent.getControlRegistry();
            synchronized (objectRegistry) {
                Shell shell = this.createShell(args[2]);
                shell.addControlListener((ControlListener)new ControlAdapter(){
                    private boolean isAdjusting;

                    public void controlMoved(ControlEvent e) {
                        if (this.isAdjusting) {
                            return;
                        }
                        Shell shell = (Shell)e.widget;
                        Point location = shell.getLocation();
                        if (location.x != 0 || location.y != 0) {
                            this.isAdjusting = true;
                            shell.setLocation(0, 0);
                            this.isAdjusting = false;
                        }
                    }
                });
                shell.setLayout((Layout)new FillLayout());
                int componentID = (Integer)args[0];
                Method createControlMethod = Class.forName((String)args[1]).getDeclaredMethod("createControl", Shell.class, Object[].class);
                createControlMethod.setAccessible(true);
                Control control = (Control)createControlMethod.invoke(null, shell, args[3]);
                NativeComponent.getControlRegistry().add((Object)control, componentID);
                NativeComponent.configureControl(control, componentID);
                shell.setVisible(true);
            }
            return null;
        }
    }

    private static class CMN_destroyControl
    extends ControlCommandMessage {
        private CMN_destroyControl() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            NativeComponent.getControlRegistry().remove(this.getComponentID());
            if (control != null) {
                Shell shell;
                if (!control.isDisposed() && (shell = control.getShell()) != null) {
                    shell.dispose();
                }
                control.dispose();
            }
            return null;
        }
    }

    private static class CMN_getComponentImage
    extends ControlCommandMessage {
        private CMN_getComponentImage() {
        }

        private void printRemoveClip(Control control, GC gc) {
            Point size = control.getSize();
            Display display = control.getDisplay();
            Shell oldParent = control.getShell();
            Shell tmpHiddenParentShell = new Shell();
            Shell tmpParentShell = new Shell(tmpHiddenParentShell, 786440);
            Point location = display.map(control, null, control.getLocation());
            tmpParentShell.setLocation(location);
            tmpParentShell.setSize(size);
            org.eclipse.swt.widgets.Canvas screenshotCanvas = new org.eclipse.swt.widgets.Canvas((Composite)tmpParentShell, 262144);
            screenshotCanvas.setSize(size);
            GC displayGC = new GC((Drawable)display);
            final Image screenshot = new Image((Device)display, size.x, size.y);
            displayGC.copyArea(screenshot, location.x, location.y);
            displayGC.dispose();
            PaintListener paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(screenshot, 0, 0);
                }
            };
            tmpParentShell.addPaintListener(paintListener);
            screenshotCanvas.addPaintListener(paintListener);
            oldParent.addPaintListener(paintListener);
            org.eclipse.swt.widgets.Canvas controlReplacementCanvas = new org.eclipse.swt.widgets.Canvas((Composite)oldParent, 262144);
            controlReplacementCanvas.setSize(size);
            controlReplacementCanvas.addPaintListener(paintListener);
            control.setRedraw(false);
            oldParent.setRedraw(false);
            control.setParent((Composite)tmpParentShell);
            control.moveBelow((Control)screenshotCanvas);
            tmpParentShell.setVisible(true);
            control.print(gc);
            control.setParent((Composite)oldParent);
            control.moveAbove((Control)controlReplacementCanvas);
            controlReplacementCanvas.dispose();
            oldParent.removePaintListener(paintListener);
            tmpParentShell.dispose();
            tmpHiddenParentShell.dispose();
            oldParent.setRedraw(true);
            control.setRedraw(true);
            screenshot.dispose();
        }

        private ImageData getImageData(Control control, Region region) {
            if (control.isDisposed()) {
                return null;
            }
            Point size = control.getSize();
            if (size.x <= 0 || size.y <= 0) {
                return null;
            }
            org.eclipse.swt.graphics.Rectangle bounds = region.getBounds();
            Display display = control.getDisplay();
            Image image = new Image((Device)display, bounds.x + bounds.width, bounds.y + bounds.height);
            GC gc = new GC((Drawable)image);
            gc.setClipping(region);
            if ("win32".equals(SWT.getPlatform()) && control instanceof Browser) {
                this.printRemoveClip(control, gc);
            } else {
                control.print(gc);
            }
            gc.dispose();
            ImageData imageData = image.getImageData();
            image.dispose();
            return imageData;
        }

        public Object run(Object[] args) throws Exception {
            ImageData imageData;
            int port = (Integer)args[0];
            Rectangle[] rectangles = (Rectangle[])args[1];
            String hostAddress = (String)args[2];
            final Control control = this.getControl();
            final Region region = new Region();
            Rectangle[] rectangleArray = rectangles;
            int n = rectangles.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle rectangle = rectangleArray[n2];
                region.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n2;
            }
            if (!NativeInterface.isUIThread(true)) {
                final Exception[] eArray = new Exception[1];
                final ImageData[] resultArray = new ImageData[1];
                control.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            resultArray[0] = CMN_getComponentImage.this.getImageData(control, region);
                        }
                        catch (Exception e) {
                            eArray[0] = e;
                        }
                    }
                });
                if (eArray[0] != null) {
                    new Socket(hostAddress, port).close();
                    throw eArray[0];
                }
                imageData = resultArray[0];
            } else {
                imageData = this.getImageData(control, region);
            }
            region.dispose();
            if (imageData == null) {
                new Socket(hostAddress, port).close();
                return null;
            }
            int cursor = 0;
            byte[] bytes = new byte[3072];
            PaletteData palette = imageData.palette;
            if (palette.isDirect) {
                Socket socket = new Socket(hostAddress, port);
                BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
                int width = imageData.width;
                int height = imageData.height;
                try {
                    Rectangle[] rectangleArray2 = rectangles;
                    int n3 = rectangles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Rectangle rectangle = rectangleArray2[n4];
                        int j = 0;
                        while (j < rectangle.height) {
                            int y = rectangle.y + j;
                            int i = 0;
                            while (i < rectangle.width) {
                                int x = rectangle.x + i;
                                if (x < width && y < height) {
                                    int pixel = imageData.getPixel(x, y);
                                    int red = pixel & palette.redMask;
                                    bytes[cursor++] = (byte)(palette.redShift < 0 ? red >>> -palette.redShift : red << palette.redShift);
                                    int green = pixel & palette.greenMask;
                                    bytes[cursor++] = (byte)(palette.greenShift < 0 ? green >>> -palette.greenShift : green << palette.greenShift);
                                    int blue = pixel & palette.blueMask;
                                    bytes[cursor++] = (byte)(palette.blueShift < 0 ? blue >>> -palette.blueShift : blue << palette.blueShift);
                                } else {
                                    cursor += 3;
                                }
                                if (cursor == bytes.length) {
                                    out.write(bytes);
                                    cursor = 0;
                                }
                                ++i;
                            }
                            ++j;
                        }
                        ++n4;
                    }
                    out.write(bytes, 0, cursor);
                    out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                out.close();
                socket.close();
                return null;
            }
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class CMN_getPreferredSize
    extends ControlCommandMessage {
        private CMN_getPreferredSize() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            Point cSize = control.computeSize(-1, -1);
            return new Dimension(cSize.x, cSize.y);
        }
    }

    private static class CMN_hasFocus
    extends ControlCommandMessage {
        private CMN_hasFocus() {
        }

        public Object run(Object[] args) {
            return this.getControl().isFocusControl();
        }
    }

    private static class CMN_reshape
    extends ControlCommandMessage {
        private CMN_reshape() {
        }

        public Object run(Object[] args) {
            Shell shell = this.getControl().getShell();
            if (!shell.isDisposed()) {
                shell.setSize(((Integer)args[0]).intValue(), ((Integer)args[1]).intValue());
            }
            return null;
        }
    }

    private static class CMN_setEnabled
    extends ControlCommandMessage {
        private CMN_setEnabled() {
        }

        public Object run(Object[] args) {
            this.getControl().setEnabled(((Boolean)args[0]).booleanValue());
            return null;
        }
    }

    private static class CMN_setEventsEnabled
    extends ControlCommandMessage {
        private CMN_setEventsEnabled() {
        }

        public Object run(Object[] args) {
            long eventMask = (Long)args[0];
            boolean isEnabled = (Boolean)args[1];
            long events = (Long)this.getControl().getData("NS_EnabledEventsMask");
            events = isEnabled ? (events |= eventMask) : (events &= eventMask ^ 0xFFFFFFFFFFFFFFFFL);
            this.getControl().setData("NS_EnabledEventsMask", (Object)events);
            return null;
        }
    }

    private static class CMN_setShellEnabled
    extends ControlCommandMessage {
        private CMN_setShellEnabled() {
        }

        public Object run(Object[] args) {
            this.getControl().getShell().setEnabled(((Boolean)args[0]).booleanValue());
            return null;
        }
    }

    private static class CMN_transferFocus
    extends ControlCommandMessage {
        private CMN_transferFocus() {
        }

        public Object run(Object[] args) {
            this.getControl().traverse(16);
            return null;
        }
    }

    private static class NNativeInterfaceListener
    extends NativeInterfaceAdapter {
        protected Reference<NativeComponent> nativeComponent;

        protected NNativeInterfaceListener(NativeComponent nativeComponent) {
            this.nativeComponent = new WeakReference<NativeComponent>(nativeComponent);
        }

        public void nativeInterfaceClosed() {
            NativeInterface.removeNativeInterfaceListener(this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NativeComponent nativeComponent = NNativeInterfaceListener.this.nativeComponent.get();
                    if (nativeComponent == null) {
                        return;
                    }
                    nativeComponent.invalidateNativePeer("The native peer died unexpectedly.");
                    nativeComponent.repaint();
                }
            });
        }
    }
}

